/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult, inspired by the Eel stock dialogs,
 * written by Darin Adler.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <libgnomeui/gnome-messagebox.h>
#include <libgnomeui/gnome-stock.h>
#include <bonobo/bonobo-exception.h>
#include "util/type-utils.h"
#include "mr-message-box.h"

static void
wrap_message_label (GtkWidget *widget, gpointer message)
{
	char *text;

	/* Find the message label so we can wrap it. */
	if (GTK_IS_LABEL (widget)) {
		gtk_label_get (GTK_LABEL (widget), &text);
		if (!strcmp (text, message)) {
			gtk_label_set_line_wrap (GTK_LABEL (widget), TRUE);
			return;
		}
	}

	/* Recurse for children. */
	if (GTK_IS_CONTAINER (widget)) {
		gtk_container_foreach (GTK_CONTAINER (widget),
				       wrap_message_label,
				       (char *) message);
	}
}

typedef struct {
	GtkWidget *dialog;
	GtkWidget *button;
} HackAccelData;

static void
set_button_accelerator (GtkWidget *widget, gpointer data)
{
	gchar         *text;
	guint          keysym;
	HackAccelData *hdata = data;

	/* Find the label so we can parse its uline. */
	if (GTK_IS_LABEL (widget) && gtk_widget_is_ancestor (widget, hdata->button)) {
		gtk_label_get (GTK_LABEL (widget), &text);
		keysym = gtk_label_parse_uline (GTK_LABEL (widget), text);
		if (keysym) {
			gtk_widget_add_accelerator (hdata->button,
						    "clicked",
						    GNOME_DIALOG (hdata->dialog)->accelerators,
						    keysym,
						    GDK_MOD1_MASK,
						    GTK_ACCEL_VISIBLE);
			return;
		}
	}

	/* Recurse for children. */
	if (GTK_IS_CONTAINER (widget)) {
		gtk_container_foreach (GTK_CONTAINER (widget),
				       set_button_accelerator, data);
	}
}

gint
mr_message_box_show_message (const gchar *message_box_type,
			     const gchar *message)
{
	GtkWidget *box;

	box = gnome_message_box_new (message,
				     message_box_type,
				     GNOME_STOCK_BUTTON_OK,
				     NULL);

       	gtk_window_set_wmclass (GTK_WINDOW (box), "message-box", "MrProject");
	wrap_message_label (GNOME_DIALOG (box)->vbox, (gchar *) message);
	
	return gnome_dialog_run (GNOME_DIALOG (box));
}

#if 0
gint
mr_message_box_show_message (const gchar *message_box_type,
			     const gchar *message,
			     ...)
{
	va_list         ap;
	GtkWidget      *box;
	GList          *list, *buttons;
	gchar         **button_names;
	gint            i;
	HackAccelData   data;

	va_start (ap, message);
	buttons = NULL;
	while (1) {
		gchar *button_name;

		button_name = va_arg (ap, gchar *);
		
		if (button_name == NULL) {
			break;
		}

		buttons = g_list_append (buttons, button_name);
	}
	va_end (ap);

	button_names = g_new0 (char *, g_list_length (buttons));
	for (i = 0, list = buttons; list; list = list->next, i++) {
		button_names[i] = list->data;
		g_print ("added %s\n", button_names[i]);
	}
	g_list_free (buttons);

	box = gnome_message_box_newv (message,
				      message_box_type,
				      (const gchar **) button_names);

       	gtk_window_set_wmclass (GTK_WINDOW (box), "message-box", "MrProject");

	data.dialog = box;
	for (list = GNOME_DIALOG (box)->buttons; list; list = list->next) {
		data.button = list->data;
		set_button_accelerator (list->data, &data);
	}

	wrap_message_label (GNOME_DIALOG (box)->vbox, (gchar *) message);

	
	return gnome_dialog_run (GNOME_DIALOG (box));
}
#endif
