/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __GOTO_POPUP_H__
#define __GOTO_POPUP_H__

#include <gtk/gtktypeutils.h>
#include <gal/widgets/gtk-combo-box.h>

#define TYPE_GOTO_POPUP		(goto_popup_get_type ())
#define GOTO_POPUP(object)	(GTK_CHECK_CAST ((object), TYPE_GOTO_POPUP, GotoPopup))
#define GOTO_POPUP_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), TYPE_GOTO_POPUP, GotoPopupClass))
#define IS_GOTO_POPUP(object)   (GTK_CHECK_TYPE ((object), TYPE_GOTO_POPUP))
#define IS_GOTO_POPUP_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_POPUP))

typedef struct _GotoPopup GotoPopup;
typedef struct _GotoPopupClass GotoPopupClass;

typedef enum {
	GOTO_TODAY    = 1 << 0,
	GOTO_START    = 1 << 1,
	GOTO_SELECTED = 1 << 2
} GotoButtonFlags;

struct _GotoPopup
{
        GtkComboBox      parent;
	GtkWidget       *calendar;
	GotoButtonFlags  flags;
	gchar           *title;
};

struct _GotoPopupClass
{
        GtkComboBoxClass parent_class;
};

GtkType    goto_popup_get_type (void);
GtkWidget *goto_popup_new      (const gchar     *title,
				GotoButtonFlags  flags);


#endif /* __GOTO_POPUP_H__ */

