/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* ECellGantt - Gantt item for e-table.
 * Copyright (C) 2000 Ximian, Inc.
 * Author: Chris Toshok <toshok@ximian.com>
 *
 */
#ifndef _E_CELL_GANTT_H_
#define _E_CELL_GANTT_H_

#include <libgnomeui/gnome-canvas.h>
#include <gal/e-table/e-cell.h>

BEGIN_GNOME_DECLS

#define E_CELL_GANTT_TYPE        (e_cell_gantt_get_type ())
#define E_CELL_GANTT(o)          (GTK_CHECK_CAST ((o), E_CELL_GANTT_TYPE, ECellGantt))
#define E_CELL_GANTT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), E_CELL_GANTT_TYPE, ECellGanttClass))
#define E_IS_CELL_GANTT(o)       (GTK_CHECK_TYPE ((o), E_CELL_GANTT_TYPE))
#define E_IS_CELL_GANTT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), E_CELL_GANTT_TYPE))

typedef struct {
	time_t start;
	time_t end;
} ECellGanttData;

typedef struct {
	ECell parent;

	gchar *font_name;
	
	gboolean draw_lines;

	GdkPixbuf   *open_pixbuf;
	GdkPixbuf   *closed_pixbuf;
} ECellGantt;

typedef struct {
	ECellClass parent_class;
} ECellGanttClass;

GtkType    e_cell_gantt_get_type (void);
ECell     *e_cell_gantt_new      (GdkPixbuf *open_pixbuf,
				 GdkPixbuf *closed_pixbuf,
				 gboolean draw_lines,
				 ECell *subcell);
void       e_cell_gantt_construct (ECellGantt *ect,
				  GdkPixbuf *open_pixbuf,
				  GdkPixbuf *closed_pixbuf,
				  gboolean draw_lines,
				  ECell *subcell);


END_GNOME_DECLS

#endif /* _E_CELL_GANTT_H_ */


