/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>XS
 */

#ifndef __ALLOC_TABLE_MODEL_H__
#define __ALLOC_TABLE_MODEL_H__

#include <glib.h>
#include <gal/e-table/e-table-model.h>
#include <gtk/gtktypeutils.h>
#include "libmrproject/GNOME_MrProject.h"

#define ALLOC_TABLE_MODEL_TYPE        (alloc_table_model_get_type ())
#define ALLOC_TABLE_MODEL(o)          (GTK_CHECK_CAST ((o), ALLOC_TABLE_MODEL_TYPE, AllocTableModel))
#define ALLOC_TABLE_MODEL_CLASS(k)    (GTK_CHECK_CLASS_CAST ((k), ALLOC_TABLE_MODEL_TYPE, AllocTableModelClass))
#define IS_ALLOC_TABLE_MODEL(o)       (GTK_CHECK_TYPE ((o), ALLOC_TABLE_MODEL_TYPE))
#define IS_ALLOC_TABLE_MODEL_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), ALLOC_TABLE_MODEL_TYPE))

enum {
	AT_COL_ID,
	AT_COL_ALLOCATED,
	AT_COL_NAME,
	AT_COL_UNITS,
	LAST_AT_COL
};

typedef struct _AllocTableModel        AllocTableModel;
typedef struct _AllocTableModelClass   AllocTableModelClass;
typedef struct _AllocTableModelPriv    AllocTableModelPriv;

struct _AllocTableModel {
        ETableModel          parent;

        AllocTableModelPriv *priv;
};

struct _AllocTableModelClass {
        ETableModelClass     parent_class;
  
	void (*resource_allocated)       (AllocTableModel          *atm,
					  GNOME_MrProject_Id        res_id);
	 
	void (*resource_deallocated)     (AllocTableModel          *atm,
					  GNOME_MrProject_Id        res_id);
};

GtkType       alloc_table_model_get_type (void);
ETableModel * alloc_table_model_new      (void);

void  alloc_table_model_add_resource     (AllocTableModel          *atm,
					 GNOME_MrProject_Resource  *res);
void  alloc_table_model_update_resource  (AllocTableModel          *atm,
					 GNOME_MrProject_Resource  *res );
void  alloc_table_model_remove_resource  (AllocTableModel          *atm,
					 GNOME_MrProject_Id         res_id);

void  alloc_table_model_set_allocation   (AllocTableModel          *atm,
					  GNOME_MrProject_Id        res_id,
					  gboolean                  allocate);

#endif /* __ALLOC_TABLE_MODEL_H__ */
