/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000 CodeFactory AB
 * Copyright (C) 2000 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef _SHELL_COMPONENT_H_
#define _SHELL_COMPONENT_H_

#include <bonobo/bonobo-xobject.h>
#include "libmrproject/GNOME_MrProject.h"
#include "util/corba-utils.h"

#define SHELL_COMPONENT_TYPE        (shell_component_get_type ())
#define SHELL_COMPONENT(o)          (GTK_CHECK_CAST ((o), SHELL_COMPONENT_TYPE, ShellComponent))
#define SHELL_COMPONENT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), SHELL_COMPONENT_TYPE, ShellComponentClass))
#define IS_SHELL_COMPONENT(o)       (GTK_CHECK_TYPE ((o), SHELL_COMPONENT_TYPE))
#define IS_SHELL_COMPONENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), SHELL_COMPONENT_TYPE))

typedef struct _ShellComponentPriv ShellComponentPriv;

typedef struct {
	BonoboXObject            parent;

	GNOME_MrProject_Shell    shell;
	ShellComponentPriv      *priv;
} ShellComponent;

typedef struct {
	BonoboXObjectClass                        parent_class;
	POA_GNOME_MrProject_ShellComponent__epv   epv;
	
	/* Signals, invoked when the corresponding CORBA method is called. */
	gboolean (*add_to_shell)  (ShellComponent    *component, 
				   GM_Shell           shell);
	void (*remove_from_shell) (ShellComponent    *component);
	void (*set_debug_flags)	  (ShellComponent    *component,
				   glong              flags);

	/* Other signals. */
	void (*shell_event)       (ShellComponent    *component,
				   const gchar       *event_name,
				   CORBA_any         *any);
} ShellComponentClass;


GtkType	        shell_component_get_type  (void);
ShellComponent *shell_component_construct (ShellComponent *component, 
					   const gchar    *mask);


#endif /* _SHELL_COMPONENT_H_ */

