/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __SEND_COMPONENT_H__
#define __SEND_COMPONENT_H__

#include <gtk/gtktypeutils.h>
#include "client/components/shell-component/shell-component.h"

#define SEND_COMPONENT_TYPE        (send_component_get_type ())
#define SEND_COMPONENT(o)          (GTK_CHECK_CAST ((o), SEND_COMPONENT_TYPE, SendComponent))
#define SEND_COMPONENT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), SEND_COMPONENT_TYPE, SendComponentClass))
#define IS_SEND_COMPONENT(o)       (GTK_CHECK_TYPE ((o), SEND_COMPONENT_TYPE))
#define IS_SEND_COMPONENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), SEND_COMPONENT_TYPE))

typedef struct _SendComponentPriv SendComponentPriv;

typedef struct {
	ShellComponent          parent;
	SendComponentPriv   *priv;
} SendComponent;

typedef struct {
	ShellComponentClass      parent_class;
} SendComponentClass;


GtkType  send_component_get_type  (void);


#endif /* _SEND_COMPONENT_H_ */

