/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000-2001 CodeFactory AB
 * Copyright (C) 2000-2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifndef __GANTT_CHART_H__
#define __GANTT_CHART_H__

#include <libgnomeui/gnome-canvas.h>
#include <gal/e-table/e-table-model.h>
#include "gantt-model.h"
#include "gantt-scale.h"

#define TYPE_GANTT_CHART		(gantt_chart_get_type ())
#define GANTT_CHART(obj)		(GTK_CHECK_CAST ((obj), TYPE_GANTT_CHART, GanttChart))
#define GANTT_CHART_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), TYPE_GANTT_CHART, GanttChartClass))
#define IS_GANTT_CHART(obj)		(GTK_CHECK_TYPE ((obj), TYPE_GANTT_CHART))
#define IS_GANTT_CHART_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), TYPE_GANTT_CHART))

typedef struct _GanttChart       GanttChart;
typedef struct _GanttChartPriv   GanttChartPriv;

struct _GanttChart
{
	GtkTable	 parent;
	
	GtkWidget	*table;
	GtkWidget	*vscroll, *hscroll;
	GtkWidget	*header_canvas;
	GnomeCanvasItem *header_item;
	GtkWidget	*gantt_canvas;
	GnomeCanvasItem *gantt_item;
	GanttModel      *gantt_model;
	GanttScale      *gantt_scale;
	GtkAdjustment   *gantt_hadj;

	GanttChartPriv	*priv;
};

typedef struct
{
	GtkTableClass	  parent_class;
} GanttChartClass;

GtkType		 gantt_chart_get_type (void);
GtkWidget	*gantt_chart_new (GanttModel *gantt_model, ETableModel *table_model);
GtkAdjustment	*gantt_chart_get_vadjustment (GanttChart *chart);
void		 gantt_chart_set_vadjustment (GanttChart *chart, GtkAdjustment *vadj);
time_t		 gantt_chart_get_first_visible_time (GanttChart *widget);
time_t           gantt_chart_get_last_visible_time (GanttChart *chart);
time_t           gantt_chart_get_centered_time (GanttChart *chart);
void             gantt_chart_scroll_to_time (GanttChart *chart, time_t t);
void             gantt_chart_customize_scale (GanttChart *chart);
void             gantt_chart_zoom (GanttChart *chart);
void             gantt_chart_zoom_entire (GanttChart *chart);
void             gantt_chart_select (GanttChart *chart, GSList *rows);

#endif /* __GANTT_CHART_H__ */
