/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2000-2001 CodeFactory AB
 * Copyright (C) 2000-2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <gal/e-table/e-tree.h>
#include "e-tree-extensions.h"

typedef struct {
	ETree      *e_tree;
	GSList     *list;
} GetSelectionData;

#if 0
/* Get the selected row numbers in a GSList. */
static void
get_selected_rows_cb (ETreePath path, gpointer user_data)
{
	GetSelectionData *data = user_data;
	gint              row;

	row = e_tree_row_of_node (data->e_tree, path);
	if (row != -1) {
		data->list = g_slist_prepend (data->list, GINT_TO_POINTER (row));
	}
}

GSList *
e_tree_extension_get_selected_row_numbers (ETree *e_tree)
{
	GetSelectionData data;

	g_return_val_if_fail (e_tree != NULL, NULL);
	g_return_val_if_fail (E_IS_TREE (e_tree), NULL);
	
	data.list = NULL;
	data.e_tree = e_tree;
	e_tree_selected_path_foreach (e_tree,
				      get_selected_rows_cb,
				      &data);

	return data.list;
}
#endif

static void
get_selected_rows_cb (gint model_row, gpointer user_data)
{
	GSList **list = user_data;

	if (model_row != -1) {
		*list = g_slist_prepend (*list, GINT_TO_POINTER (model_row));
	}
}

GSList *
e_tree_extension_get_selected_row_numbers (ETree *e_tree)
{
	GSList *list;

	g_return_val_if_fail (e_tree != NULL, NULL);
	g_return_val_if_fail (E_IS_TREE (e_tree), NULL);
	
	list = NULL;
	e_tree_selected_row_foreach (e_tree,
				     get_selected_rows_cb,
				     &list);

	return list;
}
