/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * Author : 
 *  Damon Chaplin <damon@ximian.com>
 *
 * Copyright 1999, Ximian, Inc.
 * Copyright 2001, Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
/*
 * This code was taken from Evolution and modified/changed
 * by Thomas Nyberg <thomas@codefactory.se>
 */
#include <glib.h>
#include <stdio.h>
#include <gal/widgets/e-unicode.h>
#include "util/type-utils.h"
#include "util/eel-gdk-font-extensions.h"
#include "month-view.h"
#include "month-view-task-item.h"

#define debug 1
#include "util/debug.h"

static void month_view_task_item_class_init	(MonthViewTaskItemClass *klass);
static void month_view_task_item_init	        (MonthViewTaskItem *self);

static void month_view_task_item_set_arg	(GtkObject	   *o,
						 GtkArg		   *arg,
						 guint		    arg_id);
static void month_view_task_item_get_arg        (GtkObject         *o,
						 GtkArg            *arg,
						 guint              arg_id);
static void month_view_task_item_draw_triangle  (MonthViewTaskItem *self,
						 GdkDrawable	   *drawable,
						 gint	            x,
						 gint	            y,
						 gint	            w,
						 gint	            h);
static void month_view_task_item_update         (GnomeCanvasItem   *item,
						 double            *affine,
						 ArtSVP            *clip_path,
						 int                flags);

static void month_view_task_item_draw           (GnomeCanvasItem   *canvas_item,
						 GdkDrawable       *drawable,
						 int                x,
						 int                y,
						 int                width,
						 int                height);
/* The arguments we take */
enum {
	ARG_0,
	ARG_MONTH_VIEW,
	ARG_TASK_NUM,
	ARG_SPAN_NUM,
	ARG_ARROWS,
};


GNOME_CLASS_BOILERPLATE (MonthViewTaskItem, month_view_task_item,
			 GnomeCanvasItem,    gnome_canvas_item);

static void
month_view_task_item_class_init (MonthViewTaskItemClass *klass)
{
	GtkObjectClass  *object_class;
	GnomeCanvasItemClass *item_class;

	parent_class = gtk_type_class (gnome_canvas_item_get_type());

	object_class = (GtkObjectClass *)klass;
	item_class = (GnomeCanvasItemClass *)klass;

	gtk_object_add_arg_type ("MonthViewTaskItem::month_view",
				 GTK_TYPE_POINTER, GTK_ARG_WRITABLE,
				 ARG_MONTH_VIEW);

	gtk_object_add_arg_type ("MonthViewTaskItem::arrows",
				 GTK_TYPE_INT, GTK_ARG_READWRITE,
				 ARG_ARROWS);
	gtk_object_add_arg_type ("MonthViewTaskItem::task_num",
				GTK_TYPE_INT, GTK_ARG_WRITABLE,
				ARG_TASK_NUM);
	gtk_object_add_arg_type ("MonthViewTaskItem::span_num",
				 GTK_TYPE_INT, GTK_ARG_WRITABLE,
				 ARG_SPAN_NUM);

	object_class->set_arg = month_view_task_item_set_arg;
	object_class->get_arg = month_view_task_item_get_arg;

	/* GnomeCanvasItem method overrides */
	item_class->update      = month_view_task_item_update;
	item_class->draw        = month_view_task_item_draw;
	/* item_class->point       = month_view_titles_item_point; */
}


static void
month_view_task_item_init (MonthViewTaskItem *self)
{
	g_assert (self != NULL);
	g_assert (IS_MONTH_VIEW_TASK_ITEM (self));

	self->month_view = NULL;
	self->task_num = self->span_num = -1;
	self->flag = 0;
}

static void
month_view_task_item_get_arg (GtkObject *o, GtkArg *arg, guint arg_id)
{
	MonthViewTaskItem *self;

	self = MONTH_VIEW_TASK_ITEM (o);

	switch (arg_id) {
	case ARG_ARROWS:
		GTK_VALUE_INT (*arg) = self->flag;
		break;
	default:
		g_assert_not_reached ();
		break;
	}
}

static void
month_view_task_item_set_arg (GtkObject *o, GtkArg *arg, guint arg_id)
{
	GnomeCanvasItem *item;
	MonthViewTaskItem *self;

	item = GNOME_CANVAS_ITEM (o);
	self = MONTH_VIEW_TASK_ITEM (o);
	
	switch (arg_id){
	case ARG_MONTH_VIEW:
		self->month_view = GTK_VALUE_POINTER (*arg);
		break;
	case ARG_ARROWS:
		self->flag = GTK_VALUE_INT (*arg);
		break;
	case ARG_SPAN_NUM:
		self->span_num = GTK_VALUE_INT (*arg);
		break;
	case ARG_TASK_NUM:
		self->task_num = GTK_VALUE_INT (*arg);
		break;
	default:
		g_assert_not_reached ();
	}
}


static void
month_view_task_item_update (GnomeCanvasItem *item,
			     double          *affine,
			     ArtSVP          *clip_path,
			     int              flags)
{
	MonthViewTaskItem *self;
	MonthView *month_view;
	gint span_x, span_y, span_w;

	d(puts(__FUNCTION__));

	g_return_if_fail (item != NULL);
	g_return_if_fail (IS_MONTH_VIEW_TASK_ITEM (item));

	self = MONTH_VIEW_TASK_ITEM (item);
	month_view = MONTH_VIEW (GTK_WIDGET (item->canvas)->parent);

	g_return_if_fail (IS_MONTH_VIEW (month_view));

	if (GNOME_CANVAS_ITEM_CLASS (parent_class)->update) {
		(* GNOME_CANVAS_ITEM_CLASS (parent_class)->update) (item, 
								    affine, 
								    clip_path, 
								    flags);
	}

	month_view_get_span_position (month_view,
				      self->task_num,
				      self->span_num,
				      &span_x, &span_y, 
				      &span_w);
	
	item->x1 = span_x;
	item->y1 = span_y;
	item->x2 = span_x + span_w - 1;
	item->y2 = span_y + month_view->row_height - 1;
	/*g_print ("%d,%d -> %d, %d\n", (int)item->x1, (int)item->y1, (int)item->x2, (int)item->y2);*/
}


/*
 * DRAWING ROUTINES - functions to paint the canvas item.
 */

static void
month_view_task_item_draw (GnomeCanvasItem  *canvas_item,
			   GdkDrawable      *drawable,
			   int               x,
			   int	             y,
			   int	             width,
			   int	             height)
{
	MonthViewTaskItem *self;
	MonthView *month_view;
	GtkStyle *style;
	GdkGC *fg_gc, *gc;
	gint x1, y1, x2, y2, /*time_x,*/ time_y;
	gint icon_x, icon_y, time_width; /*, min_end_time_x, max_icon_x; */
	gint rect_x, rect_w, rect_x2;
	/*	gboolean one_day_event, editing_span = FALSE; */
	/*	gint start_hour, start_minute, end_hour, end_minute; */
	/*	gboolean draw_start, draw_end; */
	gboolean draw_start_triangle = FALSE, draw_end_triangle = FALSE;
	gchar    *tmp_string, *eel_string;
	
	d(puts(__FUNCTION__));

	g_return_if_fail (canvas_item != NULL);
	g_return_if_fail (IS_MONTH_VIEW_TASK_ITEM (canvas_item));

	self = MONTH_VIEW_TASK_ITEM (canvas_item);
	month_view = MONTH_VIEW (GTK_WIDGET (canvas_item->canvas)->parent);

	g_return_if_fail (IS_MONTH_VIEW (month_view));

	/*	if (self->task_num == -1 || self->span_num == -1)
		return; */

#if 0
#warning "CHANGE ME HERE"
	event = &g_array_index (week_view->events, EWeekViewEvent,
				wveitem->event_num);
	span = &g_array_index (week_view->spans, EWeekViewEventSpan,
			       event->spans_index + wveitem->span_num);
#endif
	style = GTK_WIDGET (month_view)->style;
	fg_gc = style->fg_gc[GTK_STATE_NORMAL];
	gc = month_view->main_gc;

	x1 = canvas_item->x1 - x;
	y1 = canvas_item->y1 - y;
	x2 = canvas_item->x2 - x;
	y2 = canvas_item->y2 - y;

	if (x1 == x2 || y1 == y2)
		return;

	icon_x = 0;
	icon_y = y1 + MONTH_VIEW_EVENT_BORDER_HEIGHT + MONTH_VIEW_ICON_Y_PAD;
#if 0
	/* Get the start & end times in 24-hour format. */
	start_hour = event->start_minute / 60;
	start_minute = event->start_minute % 60;
	end_hour = event->end_minute / 60;
	end_minute = event->end_minute % 60;
#endif
	time_y = y1 + MONTH_VIEW_EVENT_BORDER_HEIGHT
		+ MONTH_VIEW_EVENT_TEXT_Y_PAD;

	time_width = month_view_get_time_string_width (month_view);

	rect_x = x1 + MONTH_VIEW_EVENT_L_PAD;
	rect_w = x2 - x1 - MONTH_VIEW_EVENT_L_PAD
		- MONTH_VIEW_EVENT_R_PAD + 1;
	
	/* Draw the triangles at the start & end, if needed.
	   They also use the first few pixels at the edge of the
	   event so we update rect_x & rect_w so we don't draw over
	   them. */
	if (self->flag & MONTH_VIEW_TASK_ITEM_ARROW_LEFT) {
		draw_start_triangle = TRUE;
		rect_x += 2;
		rect_w -= 2;
	}

	if (self->flag & MONTH_VIEW_TASK_ITEM_ARROW_RIGHT) {
		draw_end_triangle = TRUE;
		rect_w -= 2;
	}

	gdk_gc_set_foreground (gc, &month_view->colors[MONTH_VIEW_COLOR_EVENT_BACKGROUND]);

	gdk_draw_rectangle (drawable, gc, TRUE,
			    rect_x, y1 + 1, rect_w, y2 - y1 - 1);
	
	gdk_gc_set_foreground (gc, &month_view->colors[MONTH_VIEW_COLOR_EVENT_BORDER]);
	rect_x2 = rect_x + rect_w - 1;
	gdk_draw_line (drawable, gc, rect_x,  y1, rect_x2, y1);
	gdk_draw_line (drawable, gc, rect_x,  y2, rect_x2, y2);
	
	if (draw_start_triangle) {
		month_view_task_item_draw_triangle (self, drawable, 
						    x1 + MONTH_VIEW_EVENT_L_PAD + 2, 
						    y1, -3, y2 - y1 + 1);
	} else {
		gdk_draw_line (drawable, gc, rect_x,  y1, rect_x, y2);
	}
	
	if (draw_end_triangle) {
		month_view_task_item_draw_triangle (self, drawable, 
						    x2 - MONTH_VIEW_EVENT_R_PAD - 2, 
						    y1, 3, y2 - y1 + 1);
	} else {
		gdk_draw_line (drawable, gc, rect_x2, y1, rect_x2, y2);
	}

	tmp_string = e_utf8_to_gtk_string (
		GTK_WIDGET (month_view),
		month_view_get_task_title (month_view, self->task_num));

	eel_string = eel_string_ellipsize_end (tmp_string, style->font, 
					       rect_w - 2);
	
	gdk_gc_set_foreground (
		gc, &month_view->colors[MONTH_VIEW_COLOR_EVENT_TEXT]);

	gdk_draw_string (drawable, style->font, gc, 
			 rect_x + 2, 
			 y2 - 3,
			 eel_string);
	
	g_free (tmp_string);
	g_free (eel_string);
	
#if 0	
	/* Draw the start & end times, if they are not on day
	   boundaries. The start time would always be shown if it was
	   needed, though it may be clipped as the window shrinks.
	   The end time is only displayed if there is enough room.
	   We calculate the minimum position for the end time, which
	   depends on whether the start time is displayed. If the end
	   time doesn't fit, then we don't draw it. */
	min_end_time_x = x1 + MONTH_VIEW_EVENT_L_PAD
		+ MONTH_VIEW_EVENT_BORDER_WIDTH
		+ MONTH_VIEW_EVENT_EDGE_X_PAD;
	if (event->start > month_view->day_starts[span->start_day]) {
		time_x = x1 + MONTH_VIEW_EVENT_L_PAD
			+ MONTH_VIEW_EVENT_BORDER_WIDTH
			+ MONTH_VIEW_EVENT_EDGE_X_PAD;
		
		clip_rect.x = x1;
		clip_rect.y = y1;
		clip_rect.width = x2 - x1 - MONTH_VIEW_EVENT_R_PAD
			- MONTH_VIEW_EVENT_BORDER_WIDTH + 1;
		clip_rect.height = y2 - y1 + 1;
		gdk_gc_set_clip_rectangle (gc, &clip_rect);
		
		gdk_gc_set_foreground (gc, &month_view->colors[MONTH_VIEW_COLOR_EVENT_TEXT]);
		
		month_view_draw_time (month_view, drawable,
				       time_x, time_y,
				       start_hour, start_minute);
		
		gdk_gc_set_clip_rectangle (gc, NULL);
		
		/* We don't want the end time to be drawn over the
		   start time, so we increase the minimum position. */
		min_end_time_x += time_width
			+ E_WEEK_VIEW_EVENT_TIME_X_PAD;
	}
	
	max_icon_x = x2 + 1 - E_WEEK_VIEW_EVENT_R_PAD
		- E_WEEK_VIEW_EVENT_BORDER_WIDTH
		- E_WEEK_VIEW_EVENT_EDGE_X_PAD;
	
	if (!editing_span
	    && event->end < week_view->day_starts[span->start_day
						 + span->num_days]) {
		/* Calculate where the end time should be displayed. */
		time_x = x2 + 1 - E_WEEK_VIEW_EVENT_R_PAD
			- E_WEEK_VIEW_EVENT_BORDER_WIDTH
			- E_WEEK_VIEW_EVENT_EDGE_X_PAD
			- time_width;
		
		/* Draw the end time, if the position is greater than
		   the minimum calculated above. */
		if (time_x >= min_end_time_x) {
			e_week_view_draw_time (week_view, drawable,
					       time_x, time_y,
					       end_hour, end_minute);
			max_icon_x -= time_width
				+ E_WEEK_VIEW_EVENT_TIME_X_PAD;
		}
	}
	
	/* Draw the icons. */
	if (span->text_item
	    && (week_view->editing_event_num != wveitem->event_num
		|| week_view->editing_span_num != wveitem->span_num)) {
		icon_x = span->text_item->x1 - x;
		e_week_view_event_item_draw_icons (wveitem, drawable,
						   icon_x, icon_y,
						   max_icon_x, TRUE);
	}
#endif
}

#if 0
static void
month_view_draw_time	(EWeekView	*week_view,
			 GdkDrawable	*drawable,
			 gint		 time_x,
			 gint		 time_y,
			 gint		 hour,
			 gint		 minute)
{
	GtkStyle *style;
	GdkGC *gc;
	GdkFont *font, *small_font;
	gint hour_to_display, suffix_width;
	gint time_y_normal_font, time_y_small_font;
	gchar buffer[128], *suffix;

	style = GTK_WIDGET (week_view)->style;
	font = style->font;
	small_font = week_view->small_font;
	gc = week_view->main_gc;


	time_y_normal_font = time_y_small_font = time_y + font->ascent;
	if (small_font)
		time_y_small_font = time_y + small_font->ascent;

	e_week_view_convert_time_to_display (week_view, hour, &hour_to_display,
					     &suffix, &suffix_width);

	if (week_view->use_small_font && week_view->small_font) {
		g_snprintf (buffer, sizeof (buffer), "%2i:%02i",
			    hour_to_display, minute);

		/* Draw the hour. */
		if (hour_to_display < 10)
			gdk_draw_text (drawable, font, gc,
				       time_x + week_view->digit_width,
				       time_y_normal_font, buffer + 1, 1);
		else
			gdk_draw_text (drawable, font, gc,
				       time_x, time_y_normal_font, buffer, 2);

		time_x += week_view->digit_width * 2;

		/* Draw the start minute, in the small font. */
		gdk_draw_text (drawable, week_view->small_font, gc,
			       time_x, time_y_small_font, buffer + 3, 2);

		time_x += week_view->small_digit_width * 2;

		/* Draw the 'am'/'pm' suffix, if 12-hour format. */
		if (!week_view->use_24_hour_format) {
			gdk_draw_string (drawable, font, gc,
					 time_x, time_y_normal_font, suffix);
		}
	} else {
		/* Draw the start time in one go. */
		g_snprintf (buffer, sizeof (buffer), "%2i:%02i%s",
			    hour_to_display, minute, suffix);
		if (hour_to_display < 10)
			gdk_draw_string (drawable, font, gc,
					 time_x + week_view->digit_width,
					 time_y_normal_font, buffer + 1);
		else
			gdk_draw_string (drawable, font, gc,
					 time_x, time_y_normal_font,
					 buffer);

	}
}
#endif

/* This draws a little triangle to indicate that an event extends past
   the days visible on screen. */
static void
month_view_task_item_draw_triangle (MonthViewTaskItem *self,
				    GdkDrawable	      *drawable,
				    gint	       x,
				    gint	       y,
				    gint	       w,
				    gint	       h)
{
	MonthView *month_view;
	GdkGC *gc;
	GdkPoint points[3];
	gint c1, c2;
	GM_Task *task;
	
	/* should never happen - we are cruel now, internal function! */
	g_assert (self != NULL);
	g_assert (IS_MONTH_VIEW_TASK_ITEM (self));
	g_assert (IS_MONTH_VIEW (self->month_view));

	month_view = MONTH_VIEW (GTK_WIDGET (GNOME_CANVAS_ITEM (self)->canvas)->parent);
	
	gc = self->month_view->main_gc;

	points[0].x = x;
	points[0].y = y;
	points[1].x = x + w;
	points[1].y = y + (h / 2) - 1;
	points[2].x = x;
	points[2].y = y + h - 1;

	task = month_view_get_task (month_view, self->task_num);

	if (task->type == GNOME_MrProject_TASK_SUMMARY) {
		gdk_gc_set_foreground (gc, &self->month_view->colors[MONTH_VIEW_COLOR_SUMMARY_EVENT_BACKGROUND]);
	} else {
		gdk_gc_set_foreground (gc, &self->month_view->colors[MONTH_VIEW_COLOR_EVENT_BACKGROUND]);
	}
	
	gdk_draw_polygon (drawable, gc, TRUE, points, 3);

	gdk_gc_set_foreground (gc, &self->month_view->colors[MONTH_VIEW_COLOR_EVENT_BORDER]);

	/* If the height is odd we can use the same central point for both
	   lines. If it is even we use different end-points. */
	c1 = c2 = y + (h / 2);
	if (h % 2 == 0)
		c1--;

	gdk_draw_line (drawable, gc, x, y, x + w, c1);
	gdk_draw_line (drawable, gc, x, y + h - 1, x + w, c2);
}










