/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * Author : 
 *  Damon Chaplin <damon@ximian.com>
 *
 * Copyright 1999, Ximian, Inc.
 * Copyright 2001, Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */
/*
 * This code was taken from Evolution and modified/changed
 * by Thomas Nyberg <thomas@codefactory.se>
 */
#include <glib.h>
#include <stdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gal/widgets/e-unicode.h>
#include <libgnomeui/gnome-canvas.h>
#include <libgnomeui/gnome-canvas-util.h>
#include "util/type-utils.h"
#include "util/eel-gdk-font-extensions.h"
#include "month-view.h"
#include "month-view-summary-task-item.h"

#define debug 1
#include "util/debug.h"

static void month_view_summary_task_item_class_init	(MonthViewSummaryTaskItemClass *klass);
static void month_view_summary_task_item_init	        (MonthViewSummaryTaskItem *self);

static void month_view_summary_task_item_draw           (GnomeCanvasItem   *canvas_item,
							 GdkDrawable       *drawable,
							 int                x,
							 int                y,
							 int                width,
							 int                height);

static void month_view_summary_task_item_draw_bracket   (GdkDrawable       *drawable,
						         gint               y1,
						         gint               x1,
						         gint               x2,
						         gboolean           left,
						         gboolean           right);

static const char *left_bracket_xpm[] = {
"4 6 2 1",
" 	c None",
".	c #000000",
"....",
"....",
"....",
"... ",
"..  ",
".   "};

static const char *right_bracket_xpm[] = {
"4 6 2 1",
" 	c None",
".	c #000000",
"....",
"....",
"....",
" ...",
"  ..",
"   ."};

static GdkPixbuf *left_bracket_pixbuf = NULL, *right_bracket_pixbuf = NULL;

GNOME_CLASS_BOILERPLATE (MonthViewSummaryTaskItem, month_view_summary_task_item,
			 MonthViewTaskItem,    month_view_task_item);



static void
month_view_summary_task_item_realize (GnomeCanvasItem *item)
{
	if (left_bracket_pixbuf == NULL) {
		left_bracket_pixbuf = gdk_pixbuf_new_from_xpm_data (left_bracket_xpm);
	}
	
	if (right_bracket_pixbuf == NULL) {
		right_bracket_pixbuf = gdk_pixbuf_new_from_xpm_data (right_bracket_xpm);
	
	}	
}

static void
month_view_summary_task_item_class_init (MonthViewSummaryTaskItemClass *klass)
{
	GtkObjectClass  *object_class;
	GnomeCanvasItemClass *item_class;

	parent_class = gtk_type_class (month_view_task_item_get_type ());

	object_class = (GtkObjectClass *)klass;
	item_class = (GnomeCanvasItemClass *)klass;

	item_class->draw = month_view_summary_task_item_draw;
	item_class->realize = month_view_summary_task_item_realize;
}


static void
month_view_summary_task_item_init (MonthViewSummaryTaskItem *self)
{
	g_assert (self != NULL);
	g_assert (IS_MONTH_VIEW_SUMMARY_TASK_ITEM (self));
}

/*
 * DRAWING ROUTINES - functions to paint the canvas item.
 */

static void
month_view_summary_task_item_draw (GnomeCanvasItem  *canvas_item,
				   GdkDrawable      *drawable,
				   int               x,
				   int	             y,
				   int	             width,
				   int	             height)
{
	MonthViewTaskItem *self;
	MonthView *month_view;
	GtkStyle *style;
	GdkGC *fg_gc, *gc;
	gint x1, y1, x2, y2;
	gint rect_x, rect_w, rect_x2;
	gboolean draw_start_triangle = FALSE, draw_end_triangle = FALSE;
	gchar    *tmp_string, *eel_string;
	
	d(puts(__FUNCTION__));

	g_return_if_fail (canvas_item != NULL);
	g_return_if_fail (IS_MONTH_VIEW_TASK_ITEM (canvas_item));

	self = MONTH_VIEW_TASK_ITEM (canvas_item);
	month_view = MONTH_VIEW (GTK_WIDGET (canvas_item->canvas)->parent);

	g_return_if_fail (IS_MONTH_VIEW (month_view));

	style = GTK_WIDGET (month_view)->style;
	fg_gc = style->fg_gc[GTK_STATE_NORMAL];
	gc = month_view->main_gc;

	x1 = canvas_item->x1 - x;
	y1 = canvas_item->y1 - y;
	x2 = canvas_item->x2 - x;
	y2 = canvas_item->y2 - y;

	if (x1 == x2 || y1 == y2)
		return;

	rect_x = x1 + MONTH_VIEW_EVENT_L_PAD;
	rect_w = x2 - x1 - MONTH_VIEW_EVENT_L_PAD
		- MONTH_VIEW_EVENT_R_PAD + 1;
	
	if (self->flag & MONTH_VIEW_TASK_ITEM_ARROW_LEFT) {
		draw_start_triangle = TRUE;
	}

	if (self->flag & MONTH_VIEW_TASK_ITEM_ARROW_RIGHT) {
		draw_end_triangle = TRUE;
	}
	
	gdk_gc_set_foreground (gc, &month_view->colors[MONTH_VIEW_COLOR_EVENT_BORDER]);
	gdk_draw_rectangle (drawable, gc, TRUE,
			    rect_x, y1 + 1, rect_w - 1, 3);

	rect_x2 = rect_x + rect_w - 1;

	month_view_summary_task_item_draw_bracket (drawable, y1, 
						   rect_x, rect_x2,
						   !draw_start_triangle, 
						   !draw_end_triangle);

	tmp_string = e_utf8_to_gtk_string (
		GTK_WIDGET (month_view),
		month_view_get_task_title (month_view, self->task_num));

	eel_string = eel_string_ellipsize_end (tmp_string, style->font, 
					       rect_w - 2);
	
	gdk_gc_set_foreground (
		       gc, &month_view->colors[MONTH_VIEW_COLOR_EVENT_TEXT]);

	gdk_draw_string (drawable, style->font, gc, 
			 rect_x + 2, 
			 y2 - 3,
			 eel_string);
	
	g_free (tmp_string);
	g_free (eel_string);
	
}

static void
month_view_summary_task_item_draw_bracket (GdkDrawable *drawable,
					   gint         y1,
					   gint         x1,
					   gint         x2,
					   gboolean     left,
					   gboolean     right)
{
	gint top;
	gint left_width, left_height, right_width, right_height;

	top = y1;

	if (left) {
		left_width = gdk_pixbuf_get_width (left_bracket_pixbuf);
		left_height = gdk_pixbuf_get_height (left_bracket_pixbuf);
		gdk_pixbuf_render_to_drawable_alpha (
			left_bracket_pixbuf,
			drawable,
			0, 0,
			x1,
			top + 1,
			left_width,
			left_height,
			GDK_PIXBUF_ALPHA_BILEVEL,
			127,
			GDK_RGB_DITHER_NORMAL,
			left_width,
			left_height);
	}

	if (right) {
		right_width = gdk_pixbuf_get_width (right_bracket_pixbuf);
		right_height = gdk_pixbuf_get_height (right_bracket_pixbuf);
		gdk_pixbuf_render_to_drawable_alpha (
			right_bracket_pixbuf,
			drawable,
			0, 0,
			x2 - right_width,
			top + 1,
			right_width,
			right_height,
			GDK_PIXBUF_ALPHA_BILEVEL,
			127,
			GDK_RGB_DITHER_NORMAL,
			right_width,
			right_height);
	}
}




