
/*
 * %Z%%M% %I% %E%
 *
 * Copyright (c) Rich Burridge. All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mptool.h"
#include <string.h>


void
buf_arg(char *buf, char *arg)
{				/* Add arg to output buffer. */
	STRCAT(buf, " ");
	STRCAT(buf, arg);
}


/* Add arg plus integer to output buffer. */

void
buf_int(char *buf, char *arg, int value)
{
	char            intval[MAXLINE];

	STRCAT(buf, " ");
	STRCAT(buf, arg);
	STRCAT(buf, " ");
	SPRINTF(intval, "%d", value);
	STRCAT(buf, intval);
}


/* Quote and add string value to output buffer. */

void
buf_str(char *buf, char *value)
{
	STRCAT(buf, " \"");
	STRCAT(buf, value);
	STRCAT(buf, "\"");
}


void
read_str(char **str, char *value)
{
	if (*str != NULL)
		FREE(*str);
	if (value != NULL) {
		*str = (char *) malloc((unsigned) (strlen(value) + 1));
		STRCPY(*str, value);
	} else
		*str = NULL;
}
