/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Defaults;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Ticker;
import com.google.common.collect.BiMap;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Constraint;
import com.google.common.collect.Constraints;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMapDifference;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@Beta
public final class ArbitraryInstances {
    private static final Comparable<Object> BY_TO_STRING = new Comparable<Object>(){

        @Override
        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return "BY_TO_STRING";
        }
    };
    private static final Ordering<Object> ALWAYS_EQUAL = new Ordering<Object>(){

        public int compare(Object o1, Object o2) {
            return 0;
        }

        public String toString() {
            return "ALWAYS_EQUAL";
        }
    };
    private static final ClassToInstanceMap<Object> DEFAULTS = ImmutableClassToInstanceMap.builder().put(Number.class, (Object)0).put(UnsignedInteger.class, (Object)UnsignedInteger.ZERO).put(UnsignedLong.class, (Object)UnsignedLong.ZERO).put(BigInteger.class, (Object)BigInteger.ZERO).put(BigDecimal.class, (Object)BigDecimal.ZERO).put(CharSequence.class, (Object)"").put(String.class, (Object)"").put(Pattern.class, (Object)Pattern.compile("")).put(MatchResult.class, (Object)Pattern.compile("").matcher("").toMatchResult()).put(TimeUnit.class, (Object)TimeUnit.SECONDS).put(Charset.class, (Object)Charsets.UTF_8).put(Currency.class, (Object)Currency.getInstance(Locale.US)).put(Locale.class, (Object)Locale.US).put(CharMatcher.class, (Object)CharMatcher.NONE).put(Joiner.class, (Object)Joiner.on((char)',')).put(Splitter.class, (Object)Splitter.on((char)',')).put(Optional.class, (Object)Optional.absent()).put(Predicate.class, (Object)Predicates.alwaysTrue()).put(Equivalence.class, (Object)Equivalence.equals()).put(Ticker.class, (Object)Ticker.systemTicker()).put(InputStream.class, (Object)new ByteArrayInputStream(new byte[0])).put(ByteArrayInputStream.class, (Object)new ByteArrayInputStream(new byte[0])).put(Readable.class, (Object)new StringReader("")).put(Reader.class, (Object)new StringReader("")).put(StringReader.class, (Object)new StringReader("")).put(Buffer.class, (Object)ByteBuffer.allocate(0)).put(CharBuffer.class, (Object)CharBuffer.allocate(0)).put(ByteBuffer.class, (Object)ByteBuffer.allocate(0)).put(ShortBuffer.class, (Object)ShortBuffer.allocate(0)).put(IntBuffer.class, (Object)IntBuffer.allocate(0)).put(LongBuffer.class, (Object)LongBuffer.allocate(0)).put(FloatBuffer.class, (Object)FloatBuffer.allocate(0)).put(DoubleBuffer.class, (Object)DoubleBuffer.allocate(0)).put(File.class, (Object)new File("")).put(Iterator.class, (Object)Iterators.emptyIterator()).put(PeekingIterator.class, (Object)Iterators.peekingIterator((Iterator)Iterators.emptyIterator())).put(ListIterator.class, (Object)ImmutableList.of().listIterator()).put(Iterable.class, (Object)ImmutableSet.of()).put(Collection.class, (Object)ImmutableList.of()).put(ImmutableCollection.class, (Object)ImmutableList.of()).put(List.class, (Object)ImmutableList.of()).put(ImmutableList.class, (Object)ImmutableList.of()).put(Set.class, (Object)ImmutableSet.of()).put(ImmutableSet.class, (Object)ImmutableSet.of()).put(SortedSet.class, (Object)ImmutableSortedSet.of()).put(ImmutableSortedSet.class, (Object)ImmutableSortedSet.of()).put(Map.class, (Object)ImmutableMap.of()).put(ImmutableMap.class, (Object)ImmutableMap.of()).put(SortedMap.class, (Object)ImmutableSortedMap.of()).put(ImmutableSortedMap.class, (Object)ImmutableSortedMap.of()).put(Multimap.class, (Object)ImmutableMultimap.of()).put(ImmutableMultimap.class, (Object)ImmutableMultimap.of()).put(ListMultimap.class, (Object)ImmutableListMultimap.of()).put(ImmutableListMultimap.class, (Object)ImmutableListMultimap.of()).put(SetMultimap.class, (Object)ImmutableSetMultimap.of()).put(ImmutableSetMultimap.class, (Object)ImmutableSetMultimap.of()).put(SortedSetMultimap.class, (Object)Multimaps.unmodifiableSortedSetMultimap((SortedSetMultimap)TreeMultimap.create())).put(Multiset.class, (Object)ImmutableMultiset.of()).put(ImmutableMultiset.class, (Object)ImmutableMultiset.of()).put(SortedMultiset.class, (Object)Multisets.unmodifiableSortedMultiset((SortedMultiset)TreeMultiset.create())).put(BiMap.class, (Object)ImmutableBiMap.of()).put(ImmutableBiMap.class, (Object)ImmutableBiMap.of()).put(Table.class, (Object)ImmutableTable.of()).put(ImmutableTable.class, (Object)ImmutableTable.of()).put(RowSortedTable.class, (Object)Tables.unmodifiableRowSortedTable((RowSortedTable)TreeBasedTable.create())).put(ClassToInstanceMap.class, (Object)ImmutableClassToInstanceMap.builder().build()).put(ImmutableClassToInstanceMap.class, (Object)ImmutableClassToInstanceMap.builder().build()).put(Comparable.class, BY_TO_STRING).put(Comparator.class, ALWAYS_EQUAL).put(Ordering.class, ALWAYS_EQUAL).put(Range.class, (Object)Ranges.all()).put(Constraint.class, (Object)Constraints.notNull()).put(MapConstraint.class, (Object)MapConstraints.notNull()).put(MapDifference.class, (Object)Maps.difference((Map)ImmutableMap.of(), (Map)ImmutableMap.of())).put(SortedMapDifference.class, (Object)Maps.difference((SortedMap)ImmutableSortedMap.of(), (Map)ImmutableSortedMap.of())).put(AnnotatedElement.class, Object.class).put(GenericDeclaration.class, Object.class).put(Type.class, Object.class).put(Runnable.class, (Object)new Runnable(){

        @Override
        public void run() {
        }
    }).put(ThreadFactory.class, (Object)new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    }).put(Executor.class, (Object)new Executor(){

        @Override
        public void execute(Runnable command) {
        }
    }).build();
    private static final ConcurrentMap<Class<?>, Class<?>> implementations = Maps.newConcurrentMap();
    private static final Logger logger;

    private static <T> void setImplementation(Class<T> type, Class<? extends T> implementation) {
        Preconditions.checkArgument((type != implementation ? 1 : 0) != 0, (String)"Don't register %s to itself!", (Object[])new Object[]{type});
        Preconditions.checkArgument((!DEFAULTS.containsKey(type) ? 1 : 0) != 0, (String)"A default value was already registered for %s", (Object[])new Object[]{type});
        Preconditions.checkArgument((implementations.put(type, implementation) == null ? 1 : 0) != 0, (String)"Implementation for %s was already registered", (Object[])new Object[]{type});
    }

    @Nullable
    private static <T> Class<? extends T> getImplementation(Class<T> type) {
        return (Class)implementations.get(type);
    }

    @Nullable
    public static <T> T get(Class<T> type) {
        Constructor<T> constructor;
        Object defaultValue = DEFAULTS.getInstance(type);
        if (defaultValue != null) {
            return (T)defaultValue;
        }
        Class<T> implementation = ArbitraryInstances.getImplementation(type);
        if (implementation != null) {
            return ArbitraryInstances.get(implementation);
        }
        if (type.isEnum()) {
            T[] enumConstants = type.getEnumConstants();
            return enumConstants.length == 0 ? null : (T)enumConstants[0];
        }
        if (type.isArray()) {
            return ArbitraryInstances.createEmptyArray(type);
        }
        Object jvmDefault = Defaults.defaultValue((Class)Primitives.unwrap(type));
        if (jvmDefault != null) {
            return (T)jvmDefault;
        }
        if (Modifier.isAbstract(type.getModifiers()) || !Modifier.isPublic(type.getModifiers())) {
            return null;
        }
        try {
            constructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, "Exception while invoking default constructor.", e.getCause());
            return null;
        }
    }

    private static <T> T createEmptyArray(Class<T> arrayType) {
        return (T)Array.newInstance(arrayType.getComponentType(), 0);
    }

    private ArbitraryInstances() {
    }

    static {
        ArbitraryInstances.setImplementation(Appendable.class, StringBuilder.class);
        ArbitraryInstances.setImplementation(Queue.class, LinkedList.class);
        ArbitraryInstances.setImplementation(BlockingQueue.class, LinkedBlockingQueue.class);
        ArbitraryInstances.setImplementation(ConcurrentMap.class, ConcurrentHashMap.class);
        ArbitraryInstances.setImplementation(OutputStream.class, ByteArrayOutputStream.class);
        ArbitraryInstances.setImplementation(Writer.class, StringWriter.class);
        ArbitraryInstances.setImplementation(PrintStream.class, Mutable.InMemoryPrintStream.class);
        ArbitraryInstances.setImplementation(PrintWriter.class, Mutable.InMemoryPrintWriter.class);
        ArbitraryInstances.setImplementation(Random.class, Mutable.DeterministicRandom.class);
        logger = Logger.getLogger(ArbitraryInstances.class.getName());
    }

    private static final class Mutable {
        private Mutable() {
        }

        public static final class DeterministicRandom
        extends Random {
            public DeterministicRandom() {
                super(0L);
            }
        }

        public static final class InMemoryPrintWriter
        extends PrintWriter {
            public InMemoryPrintWriter() {
                super(new StringWriter());
            }
        }

        public static final class InMemoryPrintStream
        extends PrintStream {
            public InMemoryPrintStream() {
                super(new ByteArrayOutputStream());
            }
        }
    }
}

