%
% Authors:
%   Andreas Simon (2000)
%
% Copyright:
%   Andreas Simon (2000)
%
% Last change:
%   $Date: 2000/12/13 00:38:50 $
%   $Revision: 1.19 $
%
% This file is part of Mozart, an implementation
% of Oz 3:
%   http://www.mozart-oz.org
%
% See the file "LICENSE" or
%   http://www.mozart-oz.org/LICENSE.html
% for information on usage and redistribution
% of this file, and for a DISCLAIMER OF ALL
% WARRANTIES.
%

functor

import
   Native at 'GTK.so{native}'
   System
   GTKSimpleBuilder(make:Make)

export
   Dispatcher

   % Registry stuff
   GetObject
   RegisterObject
   RegisterNativeObject
   UnregisterObject
   UnregisterNativeObject

   % Non-autogenerated GTK classes
   Object

   % Misc
   Exit
   Main
   MainQuit
   Make
   GetNativeOrUnit

   \insert 'gtkexports.oz'

define

% -----------------------------------------------------------------------------
% Object Registry
% -----------------------------------------------------------------------------

   % stores GTK object --> OZ object corrospondence
   ObjectRegistry = {Dictionary.new $}

   % store a GTK object --> Oz object corrospondence
   proc {RegisterObject Object}
      NativeObj = {Object getNative($)}
   in
      {Dictionary.put ObjectRegistry {ForeignPointer.toInt NativeObj} Object}
   end

   % store a GTK object --> Oz object corrospondence
   proc {RegisterNativeObject Object NativeObj}
      {Dictionary.put ObjectRegistry {ForeignPointer.toInt NativeObj} Object}
   end

   proc {UnregisterNativeObject NativeObj}
      {Dictionary.remove ObjectRegistry {ForeignPointer.toInt NativeObj}}
   end

   proc {UnregisterObject Object}
      {UnregisterNativeObject {Object getNative($)}}
   end
   
   % Get the corrosponding Oz object from a GTK object
   proc {GetObject MyForeignPointer ?MyObject}
      if MyForeignPointer == 0 then
	 MyObject = nil
      else
	 {Dictionary.get
	  ObjectRegistry
	  {ForeignPointer.toInt MyForeignPointer}
	  MyObject}
      end
   end

% -----------------------------------------------------------------------------
% Object
% -----------------------------------------------------------------------------

   class Object
      attr nativeObject

      % For building Oz object from native objects
      % Only for internal use!
      meth newWrapper(NativeObj)
	 nativeObject <- NativeObj
      end
      meth getNative($) % get native GTK object from an Oz object
	 @nativeObject
      end
      meth ref
	 {Native.ref @nativeObject}
      end
      meth unref
	 {Native.unref @nativeObject}
      end
      
% Signals (made part of Object)
      
      meth signalConnect(Name Handler ?Id)
	 % TODO: support user data (maybe superfluous)
	 {Dispatcher registerHandler(Handler Id)}
	 {Native.signalConnect @nativeObject Name Id _}
      end
      meth signalDisconnect(Id)
	 {Dispatcher unregisterSignal(Id)}
	 {Native.signalDisconnect @nativeObject Id}
      end
      meth signalHandlerBlock(HandlerId)
	 {Native.signalBlock @nativeObject HandlerId}
      end
      meth signalHandlerUnblock(HandlerId)
	 {Native.signalUnblock @nativeObject HandlerId}
      end
      meth signalEmitByName(Name)
	 {Native.signalEmitByName @nativeObject Name}
      end
   end

% -----------------------------------------------------------------------------
% Dispatcher 
% -----------------------------------------------------------------------------

   local
      PollingIntervall  = 50
      GetUniqueSignalID = {NewName}
      FillStream        = {NewName}
   in
      class DispatcherClass
	 attr
	    signalID : 0
	    registry % A dictionary with id <--> handler corrospondences
	    port
	    stream
	    fillerThread
	 meth init
	    registry <- {Dictionary.new}
	    port     <- {Port.new @stream}
	    {Native.initializeSignalPort @port} % Tell the 'C side' about the signal port
	    thread
	       fillerThread <- {Thread.this $}
	       DispatcherClass, FillStream
	    end
	 end
	 meth !FillStream
	    {Native.handlePendingEvents} % Sends all pending GTK events to the Oz port
	    {Time.delay PollingIntervall}
	    DispatcherClass, FillStream
	 end
	 meth !GetUniqueSignalID($)
	    signalID <- @signalID + 1
	    @signalID
	 end
	 meth registerHandler(Handler ?Id)
	    {self GetUniqueSignalID(Id)}
	    {Dictionary.put @registry Id Handler}
	 end
	 meth unregisterHandler(Id)
	    {Dictionary.remove @registry Id}
	 end
	 meth dispatch
	    case @stream
	    of Event|Tail then
	       {{Dictionary.get @registry Event}} % Execute handler
               % TODO: suspend marshaller with sending a new variable to a second port
	       % TODO: terminate marshaller with bounding this variable
	       stream <- Tail
	       DispatcherClass, dispatch
	    end
	 end
	 meth exit
	    {Thread.terminate @fillerThread}
	    {Thread.terminate {Thread.this $}}
	    {System.print 'Dispatcher stoped'}
	 end
      end
   end

% -----------------------------------------------------------------------------
% The abandoned and homeless
% -----------------------------------------------------------------------------

   proc {Main}
      {Native.main}
   end

   proc {MainQuit}
      {Dispatcher exit}
      {Native.mainQuit}
   end

   proc {Exit}
      {Native.exit 0}
      {Dispatcher exit}
   end

% -----------------------------------------------------------------------------
% Autogenerated stuff 
% -----------------------------------------------------------------------------

   local
      NULL = {Native.getNull}
   in
      fun {GetNativeOrUnit X}
	 if X==unit then NULL else {X getNative($)} end
      end
   end
   
   \insert 'gtkclasses.oz'

% -----------------------------------------------------------------------------
% Finale 
% -----------------------------------------------------------------------------

   % Start the dispatcher
   Dispatcher = {New DispatcherClass init}
   thread {Dispatcher dispatch} end
   {System.show 'Dispatcher started'}

end % functor
