/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef APPCONFIG_H
#define APPCONFIG_H

#include <qobject.h>

#include <usb.h>

class QSettings;

/**
@author Dmitry Nezhevenko
*/
class appConfig : public QObject
{
	Q_OBJECT
public:
	appConfig(QObject *parent = 0, const char *name = 0);

	~appConfig();

	char cfgACMdevice[256];
	unsigned int cfgATvendor;
	unsigned int cfgATproduct;
	unsigned int cfgP2Kvendor;
	unsigned int cfgP2Kproduct;
	char cfgAutoConnect;
	char cfgAutoUpdateFileList;
	char cfgAutoExpandDirTree;
	char cfgGoLastFolder;
	char cfgLoadList;
#ifdef LIBUSB_HAS_DETACH_KERNEL_DRIVER_NP
	char cfgDetachDriver;
#endif
	void loadConfig();
	void saveConfig();	
private:
	QSettings * cfg;

};

#endif
