.\" Copyright (c) 2000, 2001, Amnon BARAK (amnon@cs.huji.ac.il).
.\" All rights reserved.
.\"
.\"	MOSIX $Id: setpe.man,v 1.10 2001/12/24 21:55:19 amnons Exp $
.\"
.\" THIS MANUAL IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
.\" WHATSOEVER. NO LIABILITY OF ANY KIND FOR DAMAGES WHATSOEVER RESULTING
.\" FROM THE USE OF THIS MANUAL WILL BE ACCEPTED.
.\"
.Dd August 5, 1999
.Dt SETPE 1
.ds vT MOSIX Reference Manual
.Os MOSIX
.Sh NAME
.Nm \&setpe
.Nd MOSIX node configuration
.Sh SYNOPSIS
.Nm \&setpe
.Fl [w|W]
.Op Fl n Ar inet
.Op Fl c
.Op Fl p Ar MOSIX-ID
.Op Fl g Ar {0|1|2}
.Op Fl f Ar {filename|-}
.Nm \&setpe
.Fl r
.Op Fl f Ar {filename|-}
.Nm \&setpe
.Fl off
.Sh DESCRIPTION
.Nm \&setpe
with the 
.Fl w
(or
.Fl W )
argument configures which nodes belong to a MOSIX cluster by mapping
their IP addresses into MOSIX-ID numbers (1-65535). 
.Nm \&setpe
takes its input from the standard input or, if 
.Fl f
is used, from the specified file (use "-" for the standard intput).
.Pp
.Nm \&setpe
.Fl r
reads the current configuration. If 
.Fl f
is used, the output is written to the specified file (use "-" for
standard output).
.Pp
.Nm \&setpe
.Fl off
shuts down MOSIX by removing the configuration.
.Pp
To configure, a simple conversion table is given as input from either
.Pa filename
or the standard-input.  Each line in the table has the following three,
space-separated, fields:
.Pp
.Pa first-MOSIX-ID \ \ \ \  hostname \ \ \ \  number-of-consecutive-nodes
.sp
The hostnames may be specified as either IP addresses or host-names that
appear in
.Pa /etc/hosts .
.Pp
When a participating node is also used as a gateway between groups of
MOSIX nodes, thus having multiple IP addresses, it could be indentifying
itself in outgoing IP packets using one of the other addresses, which may
cause MOSIX to fail to recognize the sender.  Table entries of the following
form are used to clear the confusion:
.Pp
.Pa Gateways's-MOSIX-ID \ \ \ \  Alternate-IP \ \ \ \  ALIAS
.sp
The table may also contain empty lines or comment lines (beginning with a '#').
The number of entry-lines in the table is limited to 256.
.Pp
The node's own IP address, hence its corresponding MOSIX-ID, is usually
determined by
.Pa gethostname(3) ,
unless the
.Fl p
.Pa MOSIX-ID
argument specifies otherwise (this is required in case the MOSIX network
is other than the node's standard network, hence uses a different IP address).
In either case, the node's own IP address must be included within the supplied
table.
.Pp
The
.Fl c
argument, causes
.Nm \&setpe
to only check the table's consistency, without making any actual changes.
.Pp
The
.Fl g
argument specifies the maximum number of gateways interposed between the
current MOSIX node and any other MOSIX node (but no more than 2).  This has the
effect of increasing the time-out when requesting information about other
nodes - however, it slows down programs such as
.Pa mon(1)
when too many of the configured nodes are not responding.
.br
When not using the
.Fl g
option, the value from any previous calls is maintained (or the default of 0).
.Pp
The MOSIX configuration may be modified at any time, but
when MOSIX is already configured and the new table would cause a change
to either the node's own MOSIX-ID or IP address, MOSIX would need to first
be shutdown, bringing all processes back home.
Because of this drastic side-effect, the
.Fl W
argument must be specified, while using the
.Fl w
argument will produce an error message and not modify the configuration.
.Sh FILES
.Bl -tag -width abcdefghijklmnopqrstuvw -compact
.It Pa /etc/hosts
recognised nodes.
.It Pa /etc/rc.d/init.d/mosix
script from which
.Pa setpe
is normally called.
.El
.Sh SEE ALSO
.Xr mosix 7 ,
.Xr mon 1 .
.Sh HISTORY
.Pa setpe
is a MOSIX utility.
