/*
 * Copyright (c) 2000, 2001, Amnon BARAK (amnon@cs.huji.ac.il).
 * All rights reserved.
 *
 *       MOSIX $Id: libmosix.h,v 1.13 2001/12/24 21:55:19 amnons Exp $
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Ariel Rosenblatt, Amnon Shiloh
 * Code derived from previous work by Amnon Shiloh and Oren Laadan.
 */
#ifndef __libmosix__
#define __libmosix__

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <sys/socket.h>
#include <linux/mosctl.h>
#include <linux/mosix.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/utsname.h>

typedef enum msx_queries msx_query_t;

struct decay_params
{
	int interval; 
	int slow; 
	int fast;
};

struct process_info {
	pid_t pid;
	int where;
};

enum msx_cmd { 
	D_STAY,      /* Disable automatic migration from here */
	D_NOSTAY,    /* Allow automatic migrations from here */
	D_LSTAY,     /* Disable automatic mig. of local processes */
	D_NOLSTAY,   /* Allow automatic mig.  of local processes */
	D_BLOCK,     /* Block automatic migration to here */
	D_NOBLOCK,   /* Enable automatic migration to here */
	D_EXPEL,     /* Expel all processes to remote processors */
	D_BRING,     /* Bring back all processes */
	D_GETLOAD,   /* Get current load */
	D_QUIET,     /* Stop internal load-balancing activity */
	D_NOQUIET,   /* Resume internal load-balancing activity */
	D_TUNE,      /* Enter tuning mode */
	D_NOTUNE,    /* Exit tuning mode */
	D_NOMFS,     /* Disallow MFS access to this node */
	D_MFS,       /* Reallow MFS access to this node */
	D_SETSSPEED,/* Set the standard speed, affecting D_GETLOAD */
	D_GETSSPEED, /* Get the standard speed (default=1000) */
	D_GETSPEED,  /* Get machine's speed */
	D_SETSPEED,  /* Set machine's speed */
	D_MOSIX_TO_IP,    /* Convert MOSIX to IP address */
	D_IP_TO_MOSIX,    /* Convert IP to MOSIX address */
	D_GETNTUNE,       /* get number of kernel tuning parameters */
	D_GETTUNE,        /* get kernel tuning parameters */
	D_GETSTAT,        /* get MOSIX status */
	D_GETMEM,         /* get current memory (free and total) */
	D_GETDECAY,       /* get decay parameters */
	D_SETDECAY,       /* set decay parameters */
	D_GETRMEM,        /* get OS's idea of memory (free and total) */
	D_GETUTIL,        /* get CPU utilizability % */
	D_SETWHERETO,     /* send a process somewhere */
	D_GETPE,	 /* get node number */
	D_GETCPUS,	/* get number of CPUs */
};

#define D_GOBACKHOME    0       /* just go back home */
#define D_BALANCE       (-1)    /* perform load balancing */
#define D_LEAVE         (-2)    /* leave the process where it is */

#define D_UNLOCK        0
#define D_LOCK          1
#define D_NOCHANGE      2
#define D_MIGNOLOCK     3
	
typedef enum msx_cmd msx_cmd_t;
int msxctl(msx_cmd_t cmd, int arg, void *resp, int len);
#define msxctl1(x) (msxctl((x), 0, NULL, 0))
#define msxctl2(x,y) (msxctl((x), (y), NULL, 0))
#define msxctl3(x,y,z) (msxctl((x), (y), (z), sizeof(*(z))))

int msx_readval(char *path, int *val);
int msx_readval2(char *path, int *val1, int *val2);
int msx_write(char *path, int val);
int msx_write2(char *path, int val1, int val2);
int msx_readnode(int node, char *item);
int msx_readproc(int pid, char *item);
int msx_read(char *path);
int msx_writeproc(int pid, char *item, int val);
int msx_readdata(char *fn, void *into, int max, int size);
int msx_writedata(char *fn, char *from, int size);
int msx_replace(char *fn, int val);
int msx_count_ints(char *fn);
int msx_fill_ints(char *fn, int *, int);

#endif
