# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Florian Boucault <florian@fluendo.com>


from elisa.plugins.pigment.graph.image import Image
from elisa.plugins.pigment.widgets.size_enforcer import RatioConstrainer
from elisa.plugins.pigment.widgets.panel import PiecePanel


class ArtworkBox(RatioConstrainer):
    """
    DOCME
    """

    def __init__(self):
        super(ArtworkBox, self).__init__()
        self._create_widgets()
        self.update_style_properties(self.style.get_items())

    def _create_widgets(self):
        background = Image()
        background.visible = True
        self.add(background, forward_signals=False)
        self.background = background

        overlay = PiecePanel()
        overlay.set_name("artwork_overlay")
        overlay.visible = True
        self.add(overlay, forward_signals=False)
        self.overlay = overlay

        icon = Image()
        icon.visible = True
        self.add(icon, forward_signals=False)
        self.icon = icon

        thumbnail = Image()
        thumbnail.visible = True
        self.add(thumbnail, forward_signals=False)
        self.thumbnail = thumbnail

    def _set_overlay_name(self, name):
        if name != self.overlay.name:
            self.overlay.set_name(name)

    def _get_overlay_name(self):
        return self.overlay.name

    overlay_name = property(fget=_get_overlay_name, fset=_set_overlay_name)
