/*        mondo-restore.c               Hugo Rabson                  02/23/2002	

02/23
- before unmounting, I'll run sync() and wait until buffer() isn't running

02/21
- misc clean-ups
- squelch errors from pacct-touching if there are any (errors, that is)
- run post-nuke script if it exists

02/20
- added cdstream-related stuff

02/19
- touch /mnt/RESTORING/var/log/pacct after restoring
- touch /mnt/RESTORING/var/account/pacct after restoring

02/14
- changed doubles to floats, in the auto-resizer subroutine
- moved resize_drive_proportionately_to_suit_new_drives and
  resize_mountlist_proportionately_to_suit_new_drives to mondo-prep.c
- always resize mountlist to match new hard drives, whether Interactive
  or Nuke; that way, (a) weird bugs in the resizer are more likely to
  show up, and (b) Interactive Mode users benefit from the subroutine, too

02/11
- if Nuke Mode then expand/contract all partitions proportionately to suit
  new drives
- save temp afio files (when rest'g from tape) to /tmp/tmpfs/afio.tmp.dat
- fixed silly bug in selective restore user interaction subroutine

02/10
- show progress of restoration of biggiefiles, slice by slice
- fixed cosmetic bugs
- don't use '-c 1024' in call when restoring from tape

02/07
- call make-me-bootable after run_lilo / run_grub

02/06
- log MONDO_VERSION to logfile
- fixed silly bug that makes 'current filelist #' progress form inaccurate
- fix typo in '10 seconds to abort' line; also, made 20 seconds

02/04
- cd to /mnt/RESTORING right before restoring from tape
- make doubly sure that the zip_exe, zip_suffix, etc. stuff is set
  before restoring to tape
- when restoring biggiefiles, illustrate slice-by-slice progress

02/03
- create softlink /tmp/mondo-restore.log -> /var/log/mondo-archive.log
  at start of main()

02/02
- use /tmp/mondo-restore.cfg instead of all kinds of silly /tmp files
  at boot-time; slowly migrating to a proper /tmp/mondo-restore.cfg file
- changed 'retval+=load_raidtab()' to 'load_raidtab()'
- patch to make it easier to install Mondo almost anywhere (Ian Mortimer)
- proper, one-char switches replace the long-winded multi-char switches
  of 1.4x and earlier
- migrating from lots of /tmp files in ramdisk to a single configuration
  file on ramdisk, at /tmp/mondo-restore.cfg
- 1.5x branch commenced unofficially on 01/27/2002
- estimates the number of media required by this backup session
- changed 'retval+=load_raidtab()' to 'load_raidtab()'

01/01 - 01/31/02
- restore big files' chown+chmod settings
- don't allow duplicates in filelist.potential
- handles files >2GB in size
- selective restore now uses tmpfs when possible, to avoid cluttering up
  the regular ramdisk
- improved error-related feedback [tarballs] (3 tries & then warning)
- adding edit_filelist(); replacing w-ldcards with _real_ selective restoration
- added 'system("mkdir -p /mnt/RESTORING/tmp");' to start of CD restore process
  ...was part of tape restore process but missing from CD; obscure flaw...
- cosmetic clean-ups
- changed 16m to 8m (afio buffer)
- fixed silly 'first slice of first biggiefile not found' bug
- use 'buffer' to speed up tape access
- replaced g_tape_position with g_tape_posK
- added '-c 1024 -M 16m' to each call to afio
- added error-checks to fopen() commands
- bkinfo->tmpdir is now /tmp
- make sure verify_tape_archives() picks up the number of filelists properly
- changed 'tarball' labels to say, 'fileset'
- cleaned up the random() line in success_message()
- don't check biggiefiles' checksums: tape has checksums coming out
  of its ears as it is
- adding NFS support
- improve compare_mode a little bit
- fixed bug in kill_petris()
- moved slice feedback up one line
- copy mondo-restore.log to user's /tmp dir after restoring
- run chmod -R 1777 /mnt/RESTORING/tmp before unmounting
- renamed compare_everything() as compare_to_CD()
- changed /mnt/cdrom/LAST-FILELIST-NUMBER to /tmp/...
- removed reference to g_tape_size
- fixed silly bug in restore_all_tarballs_from_tape()'s call to
  open_progress_form()
- used to restore entire afioball before restoring its contents & deleting
  afioball; now, pipes afioball to afio, restores contents, does some
  fancy footwork with a child process & it's all much cleaner&faster
- mount -t (space was missing in mount_isodir())
- all afio's now use -b TAPE_BLOCK_SIZE -M 8m
- if petris exists then tell user about it :)
- rewritten tape support from ground up

12/01 - 12/31/01
- used to refer to /usr/share/mondo/something; now it's /usr/local/mondo/...
- if post-nuke exists & can be /me is backing up his (/dev/hda) PC to tape, restoring to /dev/hdb ... without rebooting.found by 'whicih' then run it after nuking
- g_text_mode is always false :)
- when restoring/comparing tape, skip first 32MB
- changed &> /dev/null to 2> /dev/null (and >/dev/null if appropriate)
- cleaned up unmount_all_devices() a little bit
- if all files match then say so! :-)
- cd / before unmounting all devices
- pause for 10s before wiping drives in Interactive Mode (or Nuke Mode)
- if errors during compare/restore (tape) then report them separately;
  don't mix them with the verbose output of the tape itself
- don't compare bigfile after restoring: unnecessary _and_ mucks up the
  restoration of bigfiles which are spread across CD's
- don't try to mount 'images' (partitions which are backed up as images)
- don't do run_program_and_log_output for restore_biggiefile()'s mkdir,rmdir
- tell user which slice we're restoring (of bigfile N)
- complain _quietly_ if bigfile has no checksum
- chdir / when getting CD's #
- only mount CD once (not 3 times)
- if a partition fails to be unmounted then return an error & log it too
- try to mount CD-ROM 3 times (w/5s pause in between attempts) before failing
- don't worry about /dev/ *'s checksums if images/bigfiles
- when unmounting CD-ROM, verify that it's mounted first
- lots of bugfixes, re: LZO-compressed biggiefiles
- if biggiefile spans CD's then say, "Restoring from CD #..." after swapping
  CD's
- let user only back up freakin' big files (i.e. no afio 'tarballs') if
  they want to
- don't try to mount 'image' partitions
- fixed the call to grub
- run_boot_loader() now returns result
- don't try to format devices if partitioning failed
- don't try to mount RAID partitions (components of RAID disks)
- if no raid devs then delete raidtab
- ask user, 're-edit the mountlist?' if partitioning/formatting fails
- improve logging of mount/unmount
- replace several system() calls with run_program_and_log_output() calls
- if boot loader runs OK then say so on screen & in log file
- replace call to /mnt/RESTORING/lilo with call to chroot /mnt/RESTORING lilo
- streamline_changes_file() turns changed.txt into changed.files, the latter
  containing only 'important' non-matching files; it excludes /etc/mtab,
  /etc/adjtime, /var/, and so on
- improved compare_everything()'s logging
- restore_all_tarballs() will try 3 times to restore a given tarball (if it
  fails once or twice), giving up after the 3rd attempt
- rejigged the mounting/unmounting code; if swap is already mounted, don't
  abort: just say it's mounted; when unmounting, don't try to unmount something
  that is not even mounted: if it's not even mounted, say so; that sort of
  thing :-)
- if nuked or interactively restored successfully then generate a random msg
- detect if I should call run_grub, run_lilo or what, to set up the MBR
- what_number_cd_is_this() now uses 'mount_cdrom()' to mount the CD-ROM; it
  used to use 'mount /dev/cdrom -t iso9660 -o ro /mnt/cdrom'
- implementing ISO Mode, to let the user restore from ISO files in a directory
- compare_all_tarballs() and restore_all_tarballs() now initialize the progress
  string ('comparing/restoring tarball #n') before they pass its pointer to
  open/update_progress_form()
- don't offer to manually edit lilo.conf and fstab unless stablilo-me fails
- make sure modify_rclocal_one_time() is disabled
- separated the partitioning, partition-type-setting code into separate
  subroutines; one takes place, then the other; this avoids a bizarre problem
  with fdisk, where a 20MB partition would be created instead of a 20GB part'n
- turned on '-Wall'; cleaned up some cruft
- report changed archives as 'differences', not as 'errors'
- cleaned up compare_a_tarball's logging
- fixed some silly pointer-related bugs I included by mistake when reformatting
  the code & sorting the functions & stuff
- adding/creating subroutines to load and save /etc/raidtab from and to the
  new data structure, struct raidlist_itself{}
- if changed.txt is composed of /var/\* and /etc/mtab and nothing else then
  tell the user that their archives are GOOD despite the warnings

11/01 - 11/30
- code clean-up
- put RAID, LVM, partitioning, formatting stuff in mondo-prep.c
- run_lilo() now tries to use /mnt/RESTORING/sbin/before the lilo
  included in the boot-time ramdisk
- if in Interactive Mode & the formatting/partitioning fails then go back
  to mountlist editor & let user try again
- if Nuke Mode fails then fall back to Interactive Mode
- when trying to decompress, always check for presence of decompressor; abort
  if it cannot be found
- do clever one-time change to /etc/rc.local, to make sure that /tmp has the
  right permissions at boot-time
- when 'find'ing slices as part of the restore/compare loop, don't list them
  to the screen: that's just plain ugly
- only run stablilo-me if in Interactive Mode (and if user wants to)
- in Interactive Mode:-
  - edit lilo.conf
  - edit fstab
  - keep editing them until LILO runs okay
- mkdir and set permissions for /mnt/RESTORING/tmp at the start _and_ at the
  end of restoring (i.e. just after mounting and just before unmounting)
- before running stablilo-me, ask the user if they modified the mountlist; if
  they have them run stablilo-me; if they haven't, just run lilo :-)
- umount /mnt/cdrom, not /dev/cdrom; I have found that /mnt/cdrom works better
  with busybox's umount command
- use mkfs -t vfat if the vfat kludge script fails on a given partition
- in compare_all_tarballs(), added an else{} after the if{}, just because it
  looks cleaner that way; also, insist on CD #n at the start of every loop
  iteration, just in case there are 'sillies' on a given CD / archive
- if Compare Mode finds differences then ask user to see /tmp/changed.txt for
  a list of changed files

10/01 - 10/31
- when comparing tape archives, only log to screen the lines containing errors
- delete various log files at start of cycle, just in case they were left there
  by a previous run
- if I fail to mount all devices, I'll unmount whatever I mounted before I rtn
- if suffix is .lzo then use lzop, not bzip2
- big files are always bunzip2'd, never lzop'd
- set each restored biggiefile to '+x'
- chdir /mnt/RESTORING before comparing/restoring to tape
- count afio's number of output lines when comparing; _that_ is the true
  number of diffs/errors, not the value returned by afio
- when restoring from or comparing to tape, don't update progress form unless
  some files have just been restored, or you'll screw up the time estimate
- gauge the comparison/restoration's progress by the filelist# we're on, not
  the file#; the former gives a much better indication of progress
- do a 'cd /mnt/RESTORING' before comparing tape's contents to the filesystem
- when mounting all devices, don't forget to mount and unmount swap
- improving fdisk- and mkfs-logging
- if 'fdisk -v' fails then abort without trying to do anything at all
- do not try to format partitions if the act of partitioning them failed
- added 'sync' before final umount and eject of CD-ROM; also only bother
  umounting if _not_ tape
- changed 'errors occurred during compare phase' to 'differences found...'
- if no biggiefiles in biggielist then do not even try to restore biggiefiles

09/30
- tape streamers are now supported
- blank drives using 'fputc(fout,'\0')' instead of the 'dd' command

[...]

07/10 --- first incarnation
*/


#include "my-stuff.h"
#define BIGGIELIST "/mnt/cdrom/archives/biggielist.txt"
#define ARCHIVES_PATH "/mnt/cdrom/archives"


/* global vase - er, vars */
extern long g_maximum_progress, g_current_progress, g_start_time;
extern int g_currentY, g_current_media_number;
/* g_current_media_number is initialized as 1 in mondo-tools.c's var declaration */
/* for tape users */

FILE *g_tape_stream;
long long g_tape_posK;

char g_tape_device[MAX_STR_LEN];
bool g_ISO_mode=FALSE; /* are we in Iso Mode? */
char g_isodir_device[MAX_STR_LEN], g_isodir_format[MAX_STR_LEN], g_isodir_path[MAX_STR_LEN];

bool I_have_just_nuked=FALSE, g_text_mode=FALSE;



/* externs */
extern int ask_me_yes_or_no(char*);
extern char* calc_checksum_of_file(char*);
extern int closein_tape(struct s_bkpinfo*);
extern void close_evalcall_form(void);
extern char *call_program_and_get_last_line_of_output(char*);
extern void close_progress_form(void);
extern long count_lines_in_file(char*);
extern bool does_file_exist(char*);
extern int does_partition_exist(char*device,int partno);
extern int do_my_funky_lvm_stuff(struct mountlist_itself*);
extern int edit_filelist(struct s_node *);
extern int edit_mountlist(struct mountlist_itself*, struct raidlist_itself*);
extern int format_everything(struct mountlist_itself*, bool);
extern int format_device(char*,char*);
extern void finish(int);
extern void free_filelist(struct s_node*);
extern long get_time(void);
extern bool get_isodir_info(char*,char*,char*);
extern void fatal_error(char*);
extern void initialize_raid_record(struct raid_device_record*);
extern int is_this_device_mounted(char*);
extern void insist_on_this_cd_number(int);
extern long long length_of_file(char*);
extern char *last_line_of_file(char*);
extern struct s_node *load_filelist(char*);
extern void log_tape_pos(void);
extern void initialize_raidrec(struct raid_device_record*);
extern void log_it(char*);
extern void log_file_end_to_screen(char*,char*);
extern void log_to_screen(char*);
extern void mvaddstr_and_log_it(int, int, char *);
extern int make_dummy_partitions(char*,int);
extern int make_hole_for_file(char*);
extern int make_list_of_drives(struct mountlist_itself*, char drivelist[ARBITRARY_MAXIMUM][MAX_STR_LEN]);
extern bool mountlist_contains_raid_devices(struct mountlist_itself*);
extern void open_evalcall_form(char*);
extern void open_progress_form(char*,char*,char*,char*,long);
extern int openin_cdstream(struct s_bkpinfo *);
extern int openin_tape(struct s_bkpinfo *);
extern int partition_device(char*,int,int,char*,long);
extern int partition_drive(struct mountlist_itself*, char*);
extern int partition_everything(struct mountlist_itself*);
extern void popup_and_OK(char*);
extern int  popup_and_get_string(char*,char*,char*);
extern void setup_newt_stuff(void);
extern void reset_bkpinfo(struct s_bkpinfo*);
extern int read_cfg_var(char*, char*, char*);
extern int read_file_from_tape_to_file(struct s_bkpinfo*, char*, long long);
extern int read_file_from_tape_to_stream(struct s_bkpinfo*, FILE*, long long);
extern int read_file_from_tape_FULL(struct s_bkpinfo*, char*, FILE*, long long);
extern int read_header_block_from_tape(long long *, char*, int *);
extern int run_program_and_log_output(char*);
extern void save_filelist(struct s_node*, char*);
extern void strip_spaces(char*);
extern int strcmp_inc_numbers(char*,char*);
extern char *slice_fname(long,long,char*,char*);
extern int stop_raid_device(char*);
extern int stop_all_raid_devices(struct mountlist_itself*);
extern void update_evalcall_form(int);
extern void update_progress_form(char*);
extern int verify_tape_backups(struct s_bkpinfo*);
extern char which_restore_mode(void);
extern int which_format_command_do_i_need(char*,char*);
extern int write_cfg_var(char*,char*,char*);
extern void wrong_marker(int,int);
extern void resize_drive_proportionately_to_suit_new_drives(struct mountlist_itself *mountlist, char*drive_name);
extern void resize_mountlist_proportionately_to_suit_new_drives(struct mountlist_itself *mountlist);


/* ---------------- procs and funcs ---------------------- */
void ask_about_these_imagedevs(char*,char*);
int catchall_mode(struct s_bkpinfo *, struct mountlist_itself *, struct raidlist_itself*);
int compare_to_CD(struct s_bkpinfo*);
int compare_to_cdstream(struct s_bkpinfo*);
int compare_to_tape(struct s_bkpinfo*);
void sort_mountlist_by_device(struct mountlist_itself*);
void find_pathname_of_executable_preferably_in_RESTORING(char *, char*);
int interactive_mode(struct s_bkpinfo *, struct mountlist_itself *, struct raidlist_itself *);
bool is_file_in_list(char*, char*); /* needle, haystack */
int nuke_mode(struct s_bkpinfo *, struct mountlist_itself *, struct raidlist_itself *);
int restore_mode(struct s_bkpinfo *, struct mountlist_itself *, struct raidlist_itself *);
int compare_mode(struct s_bkpinfo *, struct mountlist_itself *, struct raidlist_itself *);
int load_mountlist(struct mountlist_itself*,char*);
int load_raidtab_into_raidlist(struct raidlist_itself*,char*);
struct s_node *process_filelist_and_biggielist(struct s_bkpinfo *);
int save_raidlist_to_raidtab(struct raidlist_itself*,char*);
int mount_device(char*,char*,char*);
void process_raidtab_line(FILE*, struct raid_device_record *, char*, char*);
int restore_a_biggiefile_from_CD(long, char*);
int restore_a_biggiefile_from_tape(struct s_bkpinfo*, char*, long , char*, long long, char*);
int restore_a_tarball_from_CD(char *, int, char*);
int restore_a_tarball_from_tape(struct s_bkpinfo*, char *, int, char*, long long);
int restore_all_biggiefiles_from_CD(struct s_bkpinfo*, char *);
int restore_all_biggiefiles_from_tape(struct s_bkpinfo*, char *);
int restore_all_tarballs_from_CD(struct s_bkpinfo*, char*);
int restore_all_tarballs_from_tape(struct s_bkpinfo*, char*);
int restore_everything(struct s_bkpinfo*,char *,char *);
int run_boot_loader(bool);
int run_grub(bool);
int run_lilo(bool);
void swap_mountlist_entries(struct mountlist_itself*,int,int);
void sort_mountlist_by_mountpoint(struct mountlist_itself*,bool);
void sort_mountlist_by_device(struct mountlist_itself*);
void streamline_changes_file(char*,char*);
void success_message(void);
void twenty_seconds_til_yikes(void);
int mount_all_devices(struct mountlist_itself*);
int unmount_all_devices(struct mountlist_itself*);
int what_number_cd_is_this(void);
int save_mountlist_to_disk(struct mountlist_itself*, char*);





/* ----------------------------------------------------------------------- */







void ask_about_these_imagedevs(char*infname, char*outfname)
{
  FILE*fin,*fout;
  char incoming[MAX_STR_LEN], question[MAX_STR_LEN];
  if (!(fin=fopen(infname,"r")))  {fatal_error("Cannot openin infname");}
  if (!(fout=fopen(outfname,"w"))){fatal_error("Cannot openin outfname");}
  for(fgets(incoming,MAX_STR_LEN,fin); !feof(fin); fgets(incoming,MAX_STR_LEN,fin))
    {
      strip_spaces(incoming);
      if (incoming[0]=='\0') { continue; }
      sprintf(question,"Should I restore the image of %s ?",incoming);
      if (ask_me_yes_or_no(question))
        {
          fprintf(fout,"%s\n",incoming);
        }
    }
  fclose(fout);
  fclose(fin);
}



void kill_petris(void)
{
  char command[MAX_STR_LEN];
  sprintf(command,"kill `ps ax | grep petris | grep -v grep | cut -d' ' -f2` 2> /dev/null");
  system(command);
}



int catchall_mode(struct s_bkpinfo *bkpinfo, struct mountlist_itself *mountlist, struct raidlist_itself*raidlist)
{
  char c;
  int retval=0;
  c=which_restore_mode();
  if (c=='I') { retval+=interactive_mode(bkpinfo,mountlist,raidlist); }
  else if (c=='N') { retval+=nuke_mode(bkpinfo,mountlist,raidlist); }
  else if (c=='C') { retval+=compare_mode(bkpinfo,mountlist,raidlist); }
  else
    {
      popup_and_OK("No restoring or comparing will take place today.");
      if (is_this_device_mounted("/mnt/cdrom")) { run_program_and_log_output("umount /mnt/cdrom"); }
      if (g_ISO_mode) { run_program_and_log_output("umount /mnt/isodir 2> /dev/null"); }
      finish(0);
    }
  return(retval);
}



int compare_a_biggiefile(long bigfileno)
{
  FILE*fin,*fout;
  char checksum[MAX_STR_LEN],original_cksum[MAX_STR_LEN],bigfile_fname[MAX_STR_LEN],tmp[MAX_STR_LEN],command[MAX_STR_LEN],*p;
  int i,retval=0;
  if (!does_file_exist(slice_fname(bigfileno,0,ARCHIVES_PATH,"")))
    {
      if (does_file_exist("/mnt/cdrom/archives/NOT-THE-LAST"))
	  {
          insist_on_this_cd_number((++g_current_media_number));
        }
      else
	  {
	    sprintf(tmp,"No CD's left. No biggiefiles left. No prob, Bob.");
	    log_it(tmp);
	    return(0);
        }
    }
  if (!(fin=fopen(slice_fname(bigfileno,0,ARCHIVES_PATH,""),"r")))
    {
      sprintf(tmp,"Cannot open bigfile %ld's info file",bigfileno);
      log_to_screen(tmp);
      return(1);
    }
  fgets(checksum,MAX_STR_LEN-1,fin);
  fclose(fin);
  for(i=strlen(checksum); i>0 && checksum[i-1]<32; i--);
  checksum[i]='\0';
  p=strchr(checksum,'\t');
  if (!p) {log_to_screen("No fname present in checksum data file");finish(1);}
  *(p++)='\0';
  strcpy(bigfile_fname,p);
  /*
  sprintf(tmp,"fname(%ld)='%s'",bigfileno,bigfile_fname);
  log_it(tmp);
  sprintf(tmp,"Archived checksum='%s'",checksum);
  log_it(tmp);
  */
  if (!strncmp(bigfile_fname,"/dev/",5))
    {
      strcpy(original_cksum,"IGNORE");
    }
  else
    {
      sprintf(command,"md5sum \"/mnt/RESTORING%s\" > /tmp/md5sum.txt 2> /tmp/errors.txt",bigfile_fname);
    }
  log_it(command);
  system("cat /tmp/errors >> /tmp/mondo-restore.log 2> /dev/null");
  if (system(command))
    {
      log_it("Warning - command failed");
      original_cksum[0]='\0';
      return(1);
    }
  else
    {
      if (!(fin=fopen("/tmp/md5sum.txt","r")))
	{
	  log_it("Unable to open /tmp/md5sum.txt; can't get live checksum");
	  original_cksum[0]='\0';
	  return(1);
	}
      else
	{
	  fgets(original_cksum,MAX_STR_LEN-1,fin);
	  fclose(fin);
	  for(i=strlen(original_cksum); i>0 && original_cksum[i-1]<32; i--);
	  original_cksum[i]='\0';
	  p=(char*)strchr(original_cksum,' ');
	  if (p) { *p='\0'; }
	}
    }
  sprintf(tmp,"bigfile #%ld ('%s') ",bigfileno,bigfile_fname);
  if (!strcmp(checksum,original_cksum)!=0)
    { strcat(tmp," ... OK"); }
  else
    { strcat(tmp,"... changed"); retval++; }
  log_it(tmp);
  if (retval)
    {
      if (!(fout=fopen("/tmp/changed.txt","a"))) {fatal_error("Cannot openout changed.txt");}
      fprintf(fout,"%s\n",bigfile_fname);
      fclose(fout);
    }
  return(retval);
}



int compare_all_biggiefiles()
{
  int retval=0,res;
  long noof_biggiefiles,bigfileno=0;
  char tmp[MAX_STR_LEN];

  log_it("Comparing biggiefiles");

  if (length_of_file(BIGGIELIST)<6)
    { log_it("OK, really teeny-tiny biggielist; not comparing biggiefiles"); return(0); }
  noof_biggiefiles=count_lines_in_file(BIGGIELIST);
  if (noof_biggiefiles<=0)
    {log_it("OK, no biggiefiles; not comparing biggiefiles");return(0);}
  mvaddstr_and_log_it(g_currentY,0,"Comparing large files                                                  ");
  open_progress_form("Comparing large files","I am now comparing the large files" , "against the filesystem. Please wait.","",noof_biggiefiles);
  for(bigfileno=0;bigfileno<noof_biggiefiles;bigfileno++)
    {
      sprintf(tmp,"Comparing big file #%ld",bigfileno);
      log_it(tmp);
      update_progress_form(tmp);
      res=compare_a_biggiefile(bigfileno);
      retval+=res;
      g_current_progress++;
    }
  close_progress_form();
  return(0);
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}



int compare_a_tarball(char *tarball_fname, int current_tarball_number)
{
  int retval=0,res;
  long noof_lines, afio_errors;
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN], filelist_name[MAX_STR_LEN], logfile[MAX_STR_LEN], executable[MAX_STR_LEN];

  sprintf(logfile,"/tmp/afio.log.%d",current_tarball_number);
  sprintf(filelist_name,"/mnt/cdrom/archives/filelist.%d",current_tarball_number);
  noof_lines=count_lines_in_file(filelist_name);
 if (strstr(tarball_fname,".bz2"))
    { strcpy(executable,"bzip2"); }
  else
    { strcpy(executable,"lzop"); }
  sprintf(tmp,"which %s > /dev/null 2> /dev/null",executable);
  if (system(tmp))
    { log_to_screen("compression program not found - oh no!"); finish(1); }
  sprintf(command,"afio -r -b %d -M 16m -c 1024 -P %s -Z %s > %s 2> %s",TAPE_BLOCK_SIZE,executable,tarball_fname,logfile,logfile);
  res=system(command);
  retval+=res;
  if (res)
    {
      log_it(tmp);
      sprintf(tmp,"Warning - afio returned error=%d",res);
      log_it(tmp);
    }
  sprintf(command,"cat %s | sed s/': \\\"'/\\|/ | sed s/'\\\": '/\\|/ | cut -d'|' -f2 | sort | uniq >> /tmp/changed.txt",logfile);
  if (system(command)) { log_it("Failed to generate changed.txt"); }
  if (length_of_file(logfile)>5)
    { afio_errors=count_lines_in_file(logfile); }
  else
    { afio_errors=0; }
  sprintf(tmp,"%ld differences in fileset #%d          ",afio_errors,current_tarball_number);
  if (afio_errors)
    {
      sprintf(tmp,"Differences found while processing fileset #%d       ",current_tarball_number);
      log_it(tmp);
    }
  unlink(logfile);
  return(retval);
}




int compare_all_tarballs()
{
  int retval=0,res;
  int current_tarball_number=0;
  char tarball_fname[MAX_STR_LEN], progress_str[MAX_STR_LEN], tmp[MAX_STR_LEN];
  long max_val;
  mvaddstr_and_log_it(g_currentY,0,"Comparing archives");
  read_cfg_var(MONDO_CFG_FILE, "last-filelist-number", tmp);
  max_val=atol(tmp);
  sprintf(progress_str,"Comparing with CD #%d ",g_current_media_number);
  open_progress_form("Comparing files","Comparing tarballs against filesystem.","Please wait. This may take some time.",progress_str,max_val);
  log_to_screen(progress_str);
  for(;;)
    {
      insist_on_this_cd_number(g_current_media_number);
      update_progress_form(progress_str);
      sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.bz2",current_tarball_number);
      if (!does_file_exist(tarball_fname)) {sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.lzo",current_tarball_number);}
      if (!does_file_exist(tarball_fname))
	{
	  if (!does_file_exist("/mnt/cdrom/archives/NOT-THE-LAST") || system("find /mnt/cdrom/archives/slice* > /dev/null 2> /dev/null")==0)
	    {
	      log_it("OK, I think I'm done with tarballs...");
	      break;
	    }
	  log_it("OK, I think it's time for another CD...");
	  g_current_media_number++;
	  sprintf(progress_str,"Comparing with CD #%d ",g_current_media_number);
	  log_to_screen(progress_str);
	}
      else
	{
	  res=compare_a_tarball(tarball_fname,current_tarball_number);
	  /*	  retval+=res; */
	  g_current_progress++;
	  current_tarball_number++;
	}
    }
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}




int compare_to_CD(struct s_bkpinfo*bkpinfo)
{
  char tmp[MAX_STR_LEN],cwd[MAX_STR_LEN],new[MAX_STR_LEN],command[MAX_STR_LEN];
  int resA=0,resB=0;
  long noof_changed_files;

  getcwd(cwd,MAX_STR_LEN-1);
  chdir("/mnt/RESTORING");
  getcwd(new,MAX_STR_LEN-1);
  sprintf(tmp,"new path is %s",new);
  g_current_media_number=1;
  insist_on_this_cd_number(g_current_media_number);
  unlink("/tmp/changed.txt");
  resA=compare_all_tarballs();
  resB=compare_all_biggiefiles();
  chdir(cwd);
  noof_changed_files=count_lines_in_file("/tmp/changed.txt");
  if (noof_changed_files)
    {
      sprintf(tmp,"%ld files do not match the backup            ",noof_changed_files);
      mvaddstr_and_log_it(g_currentY++,0,tmp);
      sprintf(command,"cat /tmp/changed.txt >> %s",MONDO_LOGFILE);
      system(command);
    }
  else
    {
      sprintf(tmp,"All files match the backup                     ");
      mvaddstr_and_log_it(g_currentY++,0,tmp);
      log_to_screen(tmp);
    }
  if (count_lines_in_file("/tmp/changed.txt") > 0)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Differences found while files were being compared.");
      streamline_changes_file("/tmp/changed.files","/tmp/changed.txt");
      if (count_lines_in_file("/tmp/changed.files") <= 0)
        { mvaddstr_and_log_it(g_currentY++,0,"...but they were logfiles and temporary files. Your archives are fine."); }
      else
        {
	  strcpy(tmp,"Type 'less /tmp/changed.files' for a list of non-matching files");
	  mvaddstr_and_log_it(g_currentY++,0,tmp);
	  log_to_screen(tmp);
	}
    }
  else
    {
      log_to_screen("No differences were found. Your backup is perfect.");
    }
  return(resA+resB);
}




int compare_mode(struct s_bkpinfo *bkpinfo,struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
  int retval=0;
  char tmp[MAX_STR_LEN];

  mvaddstr_and_log_it(1,30,"Comparing Automatically");
  sort_mountlist_by_mountpoint(mountlist,0);
  retval=mount_all_devices(mountlist);
  if (retval)
    { unmount_all_devices(mountlist); return(retval); }
/*
  read_cfg_var(MONDO_CFG_FILE, "tapedev", tmp);
  if (tmp[0]!='\0')
*/
  if (bkpinfo->using_tape)
    { retval+=compare_to_tape(bkpinfo); }
  else if (bkpinfo->using_cdstream)
    { retval+=compare_to_cdstream(bkpinfo); }
  else
    { retval+=compare_to_CD(bkpinfo); }
  if (retval)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Warning - differences found during the compare phase");
    }
  retval+=unmount_all_devices(mountlist);
  kill_petris();
  return(retval);
}




int compare_to_cdstream(struct s_bkpinfo *bkpinfo)
{
  int res;
  char dir[MAX_STR_LEN];
  getcwd(dir,MAX_STR_LEN);
  chdir("/mnt/RESTORING");
  system("cp -f /tmp/LAST-FILELIST-NUMBER /mnt/RESTORING/tmp");
  mvaddstr_and_log_it(g_currentY,0,"Verifying archives against filesystem");
  strcpy(bkpinfo->media_device, "/dev/cdrom");
  res=verify_tape_backups(bkpinfo);
  chdir(dir);
  if (res) {
    mvaddstr_and_log_it(g_currentY++,74,"Failed.");
    }
  else
    {
      mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  return(res);
}



int compare_to_tape(struct s_bkpinfo *bkpinfo)
{
  int res;
  char dir[MAX_STR_LEN];
  getcwd(dir,MAX_STR_LEN);
  chdir("/mnt/RESTORING");
  system("cp -f /tmp/LAST-FILELIST-NUMBER /mnt/RESTORING/tmp");
  mvaddstr_and_log_it(g_currentY,0,"Verifying archives against filesystem");
  res=verify_tape_backups(bkpinfo);
  chdir(dir);
  if (res) {
    mvaddstr_and_log_it(g_currentY++,74,"Failed.");
    }
  else
    {
      mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  return(res);
}




void find_pathname_of_executable_preferably_in_RESTORING(char *out_path, char*fname)
{
  sprintf(out_path,"/mnt/RESTORING/sbin/%s",fname);
  if (does_file_exist(out_path))
    {
      sprintf(out_path,"/mnt/RESTORING/sbin/%s",fname);
      if (does_file_exist(out_path))
        {
          sprintf(out_path,"/mnt/RESTORING/sbin/%s",fname);
          if (does_file_exist(out_path))
            {
              sprintf(out_path,"/mnt/RESTORING/sbin/%s",fname);
              if (does_file_exist(out_path))
                {
                  strcpy(out_path,fname);
                }
            }
        }
    }
}





int interactive_mode(struct s_bkpinfo *bkpinfo, struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
  int retval=0, res, ptn_errs=0, fmt_errs=0;
  bool done, /*restore_some,*/ restore_all;
  char tmp[MAX_STR_LEN];
  struct s_node *filelist;

/* try to partition and format */
  resize_mountlist_proportionately_to_suit_new_drives(mountlist);
  for(done=FALSE;!done;)
    {
      res=edit_mountlist(mountlist,raidlist);
      if (res) { finish(1); }
      save_mountlist_to_disk(mountlist,MOUNTLIST_FNAME);
      save_raidlist_to_raidtab(raidlist,RAIDTAB_FNAME);
      mvaddstr_and_log_it(1,30,"Restoring Interactively");
      if (ask_me_yes_or_no("Do you want to erase and partition your hard drives?"))
	{
	  twenty_seconds_til_yikes();
	  ptn_errs=partition_everything(mountlist);
	  if (!ptn_errs) { fmt_errs=format_everything(mountlist,FALSE); }
	  else { log_to_screen("Because partitioning failed, I shall not attempt to format devices."); }
	  if (!ptn_errs && !fmt_errs) { done=TRUE; }
	}
      else
	{
	  mvaddstr_and_log_it(g_currentY++,0,"User opted not to partition the devices");
	  if (ask_me_yes_or_no("Do you want to format your hard drives?"))
	    {
	      fmt_errs=format_everything(mountlist,TRUE);
	      if (!fmt_errs) { done=TRUE; }
	    }
	  else
	    {
/*	      mvaddstr_and_log_it(g_currentY++,0,"User opted not to partition or format devices");*/
	      ptn_errs=fmt_errs=0;
	      done=TRUE;
	    }
	}
      if (fmt_errs)
	{
	  mvaddstr_and_log_it(g_currentY++,0,"Errors occurred. Please repartition and format drives manually.");
	  done=FALSE;
	}
      if (ptn_errs & !fmt_errs)
	{
	  mvaddstr_and_log_it(g_currentY++,0,"Errors occurred during partitioning. Formatting, however, went OK.");
	  done=TRUE;
	}
      if (!done)
	{
	  if (!ask_me_yes_or_no("Re-edit the mountlist?")) {return(1);}
	}
    }

/* mount */
  sort_mountlist_by_mountpoint(mountlist,0);
  if (mount_all_devices(mountlist))
    { unmount_all_devices(mountlist); return(1); }
  system("mkdir -p -m 1777 /mnt/RESTORING/tmp");

/* restore */
  if ((restore_all=ask_me_yes_or_no("Do you want me to restore all of your data?")))
    {
      retval+=restore_everything(bkpinfo,"","");
    }
  else if ((restore_all=ask_me_yes_or_no("Do you want me to restore _some_ of your data?")))
    {
      for(done=FALSE; !done; )
        {
          filelist=process_filelist_and_biggielist(bkpinfo);
/* Now you have /tmp/tmpfs/filelist.restore-these and /tmp/tmpfs/biggielist.restore-these;
   the former is a list of regular files; the latter, biggiefiles and imagedevs.
*/        if (filelist)
            {
              free_filelist(filelist);
	      retval+=restore_everything(bkpinfo, FILELIST_RESTTHESE, BIGGIELIST_RESTTHESE);
              if (!ask_me_yes_or_no("Restore another subset of your backup?")) { done=TRUE; }
            }
          else
            {
/*              popup_and_OK("Either you clicked 'Cancel' or an error occurred."); */
              done=TRUE;
            }
	}
    }
  else
    {
      mvaddstr_and_log_it(g_currentY++,0,"User opted not to restore any data.                                  ");
    }
  if (retval)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Errors occurred during the restore phase.            ");
    }
  if (ask_me_yes_or_no("Initialize the boot loader?"))
    {
      run_boot_loader(TRUE);
    }
  else
    {
      mvaddstr_and_log_it(g_currentY++,0,"User opted not to initialize the boot loader.");
    }
  /*  modify_rclocal_one_time("/mnt/RESTORING/etc"); */
  run_program_and_log_output("touch /mnt/RESTORING/var/log/pacct");
  run_program_and_log_output("touch /mnt/RESTORING/var/account/pacct");
  retval+=unmount_all_devices(mountlist);
  /*  if (restore_some || restore_all || */
  if (ask_me_yes_or_no("Label your ext2 and ext3 partitions if necessary?"))
    {
      mvaddstr_and_log_it(g_currentY,0,"Using e2label to label your ext2,3 partitions");
      sprintf(tmp,"label-partitions-as-necessary %s < /tmp/fstab",MOUNTLIST_FNAME);
      res=system(tmp);
      if (res) 
	{
	  log_to_screen("label-partitions-as-necessary returned an error"); 
	  mvaddstr_and_log_it(g_currentY++,74,"Failed.");
	}
      else
	{
	  mvaddstr_and_log_it(g_currentY++,74,"Done.");
	}
      retval+=res;
    }
  if (retval)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Warning - errors occurred during the restore phase.");
    }
  return(retval);
}




bool is_file_in_list(char*file,char*list_fname)
{
  char command[MAX_STR_LEN];
  sprintf(command,"cat %s | grep -x \"%s\"", list_fname, file);
  if (run_program_and_log_output(command))
    { return(FALSE); }
  else
    { return(TRUE); }
}





int mount_cdrom()
{
  char mount_cmd[MAX_STR_LEN];
  int i,res;

  if (g_ISO_mode)
    { sprintf(mount_cmd,"mount /mnt/isodir/%s/%d.iso -t iso9660 -o loop,ro /mnt/cdrom", g_isodir_path, g_current_media_number); }
  else
    { sprintf(mount_cmd,"mount /dev/cdrom -t iso9660 -o ro /mnt/cdrom"); }
  for(i=0;i<3;i++)
    {
      res=run_program_and_log_output(mount_cmd);
      if (!res)
	{
	  break;
	}
      else
	{
	  log_it("Failed to mount CD-ROM drive.");
	  sleep(5);
	  system("sync");
	}
    }
  if (res) { log_it("Failed, despite 3 attempts"); }
  else { log_it("Mounted CD-ROM drive OK"); }
  return(res);
}





int iso_mode(struct s_bkpinfo *bkpinfo, struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
  char mount_isodir_command[MAX_STR_LEN], tmp[MAX_STR_LEN];
  int retval=0, i;
  bool already_mounted=FALSE;

  g_ISO_mode=TRUE;
  if (!get_isodir_info(g_isodir_device, g_isodir_format, g_isodir_path)) {return(1);}
  system("umount /mnt/cdrom 2> /dev/null"); /* just in case */
  system("mkdir -p /mnt/isodir");
  if (is_this_device_mounted(g_isodir_device))
    {
      log_to_screen("WARNING - isodir is already mounted");
      already_mounted=TRUE;
    }
  else
    {
      sprintf(mount_isodir_command,"mount %s", g_isodir_device);
      if (strlen(g_isodir_format)>1)
        { sprintf(mount_isodir_command+strlen(mount_isodir_command)," -t %s", g_isodir_format); }
      strcat(mount_isodir_command," -o ro /mnt/isodir");
      if (run_program_and_log_output(mount_isodir_command))
        { popup_and_OK("Cannot mount the device where the ISO files are stored."); return(1); }
      log_to_screen("I have mounted the device where the ISO files are stored.");
    }
  i=what_number_cd_is_this(); /* has the side-effect of calling mount_cdrom() */
  sprintf(tmp,"CD #%d has been mounted via loopback mount",i);
  log_it(tmp);
  if (i<0)
    { popup_and_OK("Cannot find ISO images in the directory you specified."); retval=1; }
  else
    { retval=catchall_mode(bkpinfo,mountlist,raidlist); }
  if (is_this_device_mounted("/mnt/cdrom")) { system("umount /mnt/cdrom"); }
  if (! already_mounted)
    {
      if (system("umount /mnt/isodir 2> /dev/null")) { log_to_screen("WARNING - unable to unmount device where the ISO files are stored."); }
    }
  return(retval);
}



/*            MONDO - saving your a$$ since Feb 18th, 2000            */



int load_mountlist(struct mountlist_itself *mountlist, char *fname)
{
  FILE*fin;
  char incoming[MAX_STR_LEN], siz[128], tmp[MAX_STR_LEN];
  int items,j;
  if (!(fin=fopen(fname,"r")))
    {
      log_to_screen("Cannot open mountlist");
      return(1);
    }
  items=0;
  fgets(incoming,MAX_STR_LEN-1,fin);
  log_it("Loading mountlist...");
  while(!feof(fin))
    {
      sscanf(incoming,"%s %s %s %s",mountlist->el[items].device, mountlist->el[items].mountpoint, mountlist->el[items].format, siz);
      /*      if (!isalpha(siz[0])) {strcpy(siz,"1111");} */
      mountlist->el[items].size = atol(siz);
      if (mountlist->el[items].device[0]!='\0' && mountlist->el[items].device[0]!='#')
	{
	  if (items >= ARBITRARY_MAXIMUM)
	    {
	      log_to_screen("Too many lines in mountlist.. ABORTING");
	      finish(1);
	    }
	  for(j=0; j<items && strcmp(mountlist->el[j].device, mountlist->el[items].device); j++);
	  if (j<items)
	    {
	      strcat(mountlist->el[items].device, "_dup");
	      sprintf(tmp,"Duplicate entry in mountlist - renaming to %s",mountlist->el[items].device);
	      log_it(tmp);
	    }
	  sprintf(tmp,"%s %s %s %ld",mountlist->el[items].device, mountlist->el[items].mountpoint, mountlist->el[items].format, mountlist->el[items].size);
	  log_it(tmp);
	  items++;
	}
      fgets(incoming,MAX_STR_LEN-1,fin);
    }
  fclose(fin);
  mountlist->entries=items;
  /*  mvaddstr_and_log_it(g_currentY++,74,"Done."); */
  log_it("Mountlist loaded successfully.");
  sprintf(tmp,"%d entries in mountlist",items);
  log_it(tmp);
  sort_mountlist_by_device(mountlist);
  return(0);
}


int get_next_raidtab_line(FILE*fin,char*label,char*value)
{
  char incoming[MAX_STR_LEN];
  char *p;
  label[0]=value[0]='\0';
  if (feof(fin)) { return(1); }
  for(fgets(incoming,MAX_STR_LEN-1,fin); !feof(fin); fgets(incoming,MAX_STR_LEN-1,fin))
    {
      strip_spaces(incoming);
      p=strchr(incoming,' ');
      if (strlen(incoming)<3 || incoming[0]=='#' || !p) {continue;}
      *(p++)='\0';
      strcpy(label,incoming);
      strcpy(value,p);
      return(0);
    }
  return(1);
}



void add_disk_to_raid_device(struct list_of_disks *disklist, char*device_to_add, int index)
{
  int items;
  items = disklist->entries;
  strcpy(disklist->el[items].device, device_to_add);
  disklist->el[items].index = index;
  items++;
  disklist->entries = items;
}





int load_raidtab_into_raidlist(struct raidlist_itself *raidlist, char*fname)
{
  FILE*fin;
  char tmp[MAX_STR_LEN], label[MAX_STR_LEN], value[MAX_STR_LEN];
  int items, v;
  if (length_of_file(fname)<5)
    {
      log_it("Raidtab is very small or non-existent. Ignoring it.");
      raidlist->entries=0;
      return(0);
    }
  if (!(fin=fopen(fname,"r")))
    {
      log_it("Cannot open raidtab");
      return(1);
    }
  items=0;
  log_it("Loading raidtab...");
  get_next_raidtab_line(fin,label,value);
  while(!feof(fin))
    {
      /* find the 'raiddev' entry, indicating the start of the block of info */
      initialize_raidrec(&raidlist->el[items]);
      v=0;
      while(!feof(fin) && strcmp(label,"raiddev"))
	{
	  strcpy(raidlist->el[items].additional_vars.el[v].label, label);
	  strcpy(raidlist->el[items].additional_vars.el[v].value, value);
	  v++;
	  get_next_raidtab_line(fin,label,value);
	  log_it(tmp);
	}
      raidlist->el[items].additional_vars.entries = v;
      if (feof(fin)) {continue;}
      strcpy(raidlist->el[items].raid_device, value);
      for(get_next_raidtab_line(fin,label,value); !feof(fin) && strcmp(label,"raiddev"); get_next_raidtab_line(fin,label,value))
	{ process_raidtab_line(fin,&raidlist->el[items],label,value); }
      items++;
    }
  fclose(fin);
  raidlist->entries=items;
  log_it("Raidtab loaded successfully.");
  sprintf(tmp,"%d RAID devices in raidtab",items);
  log_it(tmp);
  return(0);
}



int modify_rclocal_one_time(char*path)
{
  char rclocal_fname[MAX_STR_LEN], newfile_fname[MAX_STR_LEN],
    tmp[MAX_STR_LEN];
  sprintf(rclocal_fname,"%s/rc.local",path);
  system("chmod -R 1777 /mnt/RESTORING/tmp");
  return(0); /* remove this line to open the floodgates... */
  if (! does_file_exist(rclocal_fname))
    {
      sprintf(rclocal_fname,"%s/rc.d/rc.local",path);
    }
  if (! does_file_exist(rclocal_fname))
    {
      return(1);
    }
  sprintf(newfile_fname,"%s/rc.local.mondorescue",path);
  sprintf(tmp,"cat %s | grep mondorescue > /dev/null 2> /dev/null",rclocal_fname);
  if (system(tmp))
    {
      sprintf(tmp,"echo \"[ -e %s ] && %s\n\" >> %s",newfile_fname,newfile_fname,rclocal_fname);
      system(tmp);
    }
  sprintf(tmp,"echo -en \"#!/bin/sh\
\\n\
\\n\
cat %s | grep -v mondorescue > %s\\n\
chmod -R 1777 /tmp\\n\
yes | rm -f %s\\n\
\" > %s",rclocal_fname,rclocal_fname,newfile_fname,newfile_fname);
  sprintf(tmp,"chmod +x \"%s\"",newfile_fname);
  system(tmp);
  return(0);
}



int mount_all_devices(struct mountlist_itself *mountlist)
{
  int retval=0,lino,res;
  char tmp[MAX_STR_LEN], these_failed[MAX_STR_LEN];

  these_failed[0]='\0';
  mvaddstr_and_log_it(g_currentY,0,"Mounting devices         ");
  open_progress_form("Mounting devices","I am now mounting all the drives.","This should not take long.","",mountlist->entries);
  for(lino=0; lino < mountlist->entries; lino++)
    {
      if (is_this_device_mounted(mountlist->el[lino].device))
	{
	  sprintf(tmp,"%s is already mounted",mountlist->el[lino].device);
	  log_to_screen(tmp);
	}
      else if (strcmp(mountlist->el[lino].mountpoint,"lvm") && strcmp(mountlist->el[lino].mountpoint,"raid") && strcmp(mountlist->el[lino].mountpoint,"image"))
	{
	  sprintf(tmp,"Mounting %s",mountlist->el[lino].device);
	  update_progress_form(tmp);
	  res=mount_device(mountlist->el[lino].device, mountlist->el[lino].mountpoint, mountlist->el[lino].format);
	  retval+=res;
          if (res) { strcat(these_failed,mountlist->el[lino].device); strcat(these_failed," "); }
	}
      g_current_progress++;
    }
  close_progress_form();
  run_program_and_log_output("df -m");
  if (retval)
    {
      sprintf(tmp,"Could not mount devices %s- shall I abort?",these_failed);
      if (!ask_me_yes_or_no(tmp)) 
	{
	  retval=0;
	  log_to_screen("Continuing, although some devices failed to be mounted");
	  mvaddstr_and_log_it(g_currentY++,74,"Done.");
	}
      else
	{
	  mvaddstr_and_log_it(g_currentY++,74,"Failed.");
	  log_to_screen("Unable to mount some or all of your partitions.");
	}
    }
  else
    {
      log_to_screen("All partitions were mounted OK.");
      mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  run_program_and_log_output("df -m");
  return(retval);
}



int mount_device(char*device, char*mountpoint, char*format)
{
  int res=0;
  char tmp[MAX_STR_LEN],command[MAX_STR_LEN],mountdir[MAX_STR_LEN];
  if (!strcmp(mountpoint,"lvm")) { return(0); }
  if (!strcmp(mountpoint,"image")) { return(0); }
  sprintf(tmp,"Mounting device %s   ",device);
  log_it(tmp);
  if (!strcmp(mountpoint,"swap"))
    {
      sprintf(command,"swapon %s",device);
    }
  else
    {
      if (!strcmp(mountpoint,"/"))
        { strcpy(mountdir,"/mnt/RESTORING"); }
      else
        { sprintf(mountdir,"/mnt/RESTORING%s",mountpoint); }
      sprintf(command,"mkdir -p %s 2>> %s",mountdir,MONDO_LOGFILE);
      system(command);
      sprintf(command,"mount %s -t %s %s 2>> %s",device,format,mountdir,MONDO_LOGFILE);
    }
  res=system(command);
  if (res)
    {
      sprintf(tmp,"Unable to mount device %s (type %s) at %s",device,format,mountdir);
      log_it(tmp);
      if (!strcmp(mountpoint,"swap"))
        { log_to_screen(tmp); }
      else
	{
	  log_it("Retrying w/o the '-t' switch");
	  sprintf(command,"mount %s %s 2>> %s",device,mountdir,MONDO_LOGFILE);
	  res=system(command);
	  if (res==0)
	    { log_it("That's OK. I called mount w/o a filesystem type and it worked fine in the end."); }
	  else
	    { log_to_screen(tmp); }
        }
    }
  return(res);
}






void twenty_seconds_til_yikes()
{
  int i;
  char tmp[MAX_STR_LEN];
  open_progress_form("CAUTION","Be advised: I am about to ERASE your hard disk(s)!","You may press Ctrl+Alt+Del to abort safely.","",20);
  for(i=0;i<20;i++)
    {
      g_current_progress=i;
      sprintf(tmp,"You have %d seconds left to abort.",20-i);
      update_progress_form(tmp);
      sleep(1);
    }
  close_progress_form();
}





int nuke_mode(struct s_bkpinfo *bkpinfo, struct mountlist_itself *mountlist, struct raidlist_itself *raidlist)
{
  int retval=0,res;
  char tmp[MAX_STR_LEN];

  resize_mountlist_proportionately_to_suit_new_drives(mountlist);
  save_mountlist_to_disk(mountlist,MOUNTLIST_FNAME);
  twenty_seconds_til_yikes();
  mvaddstr_and_log_it(1,30,"Restoring Automatically");
  res=partition_everything(mountlist);
  retval+=res;
  if (!res)
    {
      res+=format_everything(mountlist,FALSE);
    }
  retval+=res;
  if (res)
    {
      mvaddstr_and_log_it(g_currentY++,0,"Failed to partition and/or format your hard drives.");
      if (ask_me_yes_or_no("Try in interactive mode instead?"))
	{ retval=interactive_mode(bkpinfo,mountlist,raidlist); }
      return(retval);
    }
  sort_mountlist_by_mountpoint(mountlist,0);
  retval+=mount_all_devices(mountlist);
  system("mkdir -p -m 1777 /mnt/RESTORING/tmp");
  if (retval) { unmount_all_devices(mountlist); return(retval);}
  retval+=restore_everything(bkpinfo,"","");
  retval+=run_boot_loader(FALSE);
  /*  modify_rclocal_one_time("/mnt/RESTORING/etc"); */
  run_program_and_log_output("touch /mnt/RESTORING/var/log/pacct");
  run_program_and_log_output("touch /mnt/RESTORING/var/account/pacct");
  retval+=unmount_all_devices(mountlist);
  mvaddstr_and_log_it(g_currentY,0,"Using e2label to label your ext2,3 partitions");
  sprintf(tmp,"label-partitions-as-necessary %s < /tmp/fstab",MOUNTLIST_FNAME);
  res=run_program_and_log_output(tmp);
  if (res)
    {
      log_to_screen("label-partitions-as-necessary returned an error");
      mvaddstr_and_log_it(g_currentY++,74,"Failed.");
    }
  else
    {
      mvaddstr_and_log_it(g_currentY++,74,"Done.");
    }
  retval+=res;
  if (retval) {log_to_screen("Errors occurred during the nuke phase.");}
  else {success_message();}
  I_have_just_nuked=TRUE;
  return(retval);
}





struct s_node *process_filelist_and_biggielist(struct s_bkpinfo *bkpinfo)
{
  struct s_node *filelist;
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN];
  pid_t pid;

  if (!does_file_exist(FILELIST_FULL) || !does_file_exist(BIGGIELIST_TXT))
    {
      if (bkpinfo->using_tape) { fatal_error("filelist.full and/or biggielist.txt missing from /tmp"); }
      log_to_screen("Extracting filelist and biggielist from first CD...");
      insist_on_this_cd_number(1);
      getcwd(tmp,MAX_STR_LEN);
      chdir("/");
      run_program_and_log_output("tar -zxvf /mnt/cdrom/images/all.tar.gz tmp/biggielist.txt tmp/filelist.full");
      if (!does_file_exist("/tmp/biggielist.txt"))
        { fatal_error("all.tar.gz did not include tmp/biggielist.txt"); }
      if (!does_file_exist("/tmp/filelist.full"))
        { fatal_error("all.tar.gz did not include tmp/filelist.full"); }
      chdir(tmp);
/*
      sprintf(tmp, "mv %s %s", "/tmp/biggielist.txt", BIGGIELIST_TXT);
      run_program_and_log_output(tmp);
      sprintf(tmp, "mv %s %s", "/tmp/filelist.full", FILELIST_FULL);
      run_program_and_log_output(tmp);
*/
    }
  if (!does_file_exist(BIGGIELIST_TXT)) { fatal_error("/tmp/biggielist.txt not found"); }
  if (!does_file_exist(FILELIST_FULL)) { fatal_error("filelist.full does not exist"); }

  log_it("Forking");
  pid=fork();
  switch(pid)
    {
      case -1: fatal_error("Forking error"); break;
      case 0:
        log_to_screen("Pre-processing filelist");
        if (!does_file_exist(BIGGIELIST_TXT))
          {
            sprintf(command,"> %s",BIGGIELIST_TXT);
            system(command);
          }

        sprintf(command,"cat %s | grep -vx \"/dev/.*\" > %s", BIGGIELIST_TXT, BIGGIELIST_POT);
        system(command);
        sprintf(command,"cat %s | grep  -x \"/dev/.*\" > %s", BIGGIELIST_TXT, FILELIST_IMAGEDEVS);
	system(command);
        sprintf(command,"cat %s %s | sort | uniq > %s", FILELIST_FULL, BIGGIELIST_POT, FILELIST_POTENTIAL);
	system(command);
        exit(0);
        break;
      default:
        open_evalcall_form("Pre-processing filelist");
        while(!waitpid(pid, (int*)0, WNOHANG))
          {
            usleep(100000);
            update_evalcall_form(0);
          }
    }
  close_evalcall_form();
  log_it("Continuing after fork");
  if (!does_file_exist(FILELIST_POTENTIAL)) { log_it("filelist.potential does not exist"); }
/* filelist.potential contains filelist.full and biggielist.txt (but not the imagedevs) */
  filelist=load_filelist(FILELIST_POTENTIAL);
  if (edit_filelist(filelist))
    {
      log_it("User hit 'cancel'. Freeing filelist and aborting.");
      free_filelist(filelist);
      return(NULL);
    }
  save_filelist(filelist,FILELIST_RESTTHESE);
  unlink(FILELIST_POTENTIAL);
  log_it("Forking");
  pid=fork();
  switch(pid)
    {
      case -1: fatal_error("Forking error"); break;
      case 0: 
        log_to_screen("Post-processing filelist");
        sprintf(command,"mv -f %s /tmp/tmpfs/FLRT", FILELIST_RESTTHESE);
        system(command);
        sprintf(command,"cat /tmp/tmpfs/FLRT %s | sort | uniq -d > %s", BIGGIELIST_POT, BIGGIELIST_RESTTHESE);
        system(command);
        sprintf(command,"cat /tmp/tmpfs/FLRT %s | sort | uniq -u > %s", BIGGIELIST_RESTTHESE, FILELIST_RESTTHESE);
        system(command);
        unlink("/tmp/tmpf/FLRT");
        log_it("Child process has finished");
        exit(0);
        break;
      default:
        open_evalcall_form("Post-processing filelist");
        while(!waitpid(pid, (int*)0, WNOHANG))
          {
/*            usleep(100000); */
            sleep(1);
            update_evalcall_form(0);
          }
    }
  log_it("Continuing after fork");
  ask_about_these_imagedevs(FILELIST_IMAGEDEVS,IMAGEDEVS_RESTTHESE);
  close_evalcall_form();
  if (length_of_file(IMAGEDEVS_RESTTHESE) > 2)
    { 
      sprintf(command,"cat %s >> %s", IMAGEDEVS_RESTTHESE, BIGGIELIST_RESTTHESE);
      system(command);
    }
/* so, in the end, you have /tmp/tmpfs/filelist.restore-these and /tmp/tmpfs/biggielist.restore-these */
  return(filelist);
}






void process_raidtab_line(FILE*fin, struct raid_device_record *raidrec, char*label, char*value)
{
  char tmp[MAX_STR_LEN], labelB[MAX_STR_LEN], valueB[MAX_STR_LEN];
  struct list_of_disks *disklist;
  int index, v;
  if (!strcmp(label,"raid-level"))
    {
      if (!strcmp(value,"linear"))
	{ raidrec->raid_level = -1; }
      else
	{ raidrec->raid_level = atoi(value); }
    }
  else if (!strcmp(label,"nr-raid-disks"))
    { /* ignore it */ }
  else if (!strcmp(label,"nr-spare-disks"))
    { /* ignore it */ }
  else if (!strcmp(label,"nr-parity-disks"))
    { /* ignore it */ }
  else if (!strcmp(label,"nr-failed-disks"))
    { /* ignore it */ }
  else if (!strcmp(label,"persistent-superblock"))
    { raidrec->persistent_superblock = atoi(value); }
  else if (!strcmp(label,"chunk-size"))
    { raidrec->chunk_size = atoi(value); }
  else if (!strcmp(label,"device"))
    {
      get_next_raidtab_line(fin,labelB,valueB);
      if (!strcmp(labelB,"raid-disk")) {disklist=&raidrec->data_disks; }
      else if (!strcmp(labelB,"spare-disk")) {disklist=&raidrec->spare_disks; }
      else if (!strcmp(labelB,"parity-disk")){disklist=&raidrec->parity_disks;}
      else if (!strcmp(labelB,"failed-disk")){disklist=&raidrec->failed_disks;}
      else
	{ disklist=NULL; }
      if (!disklist)
	{ sprintf(tmp,"Ignoring '%s %s' pair of disk %s",labelB,valueB,label); log_it(tmp); }
      else
	{ index=atoi(valueB); add_disk_to_raid_device(disklist,value,index); }
    }
  else
    {
      v = raidrec->additional_vars.entries;
      strcpy(raidrec->additional_vars.el[v].label, label);
      strcpy(raidrec->additional_vars.el[v].value, value);
      raidrec->additional_vars.entries = ++v;
    }
}






int restore_a_biggiefile_from_CD(long bigfileno, char*biggielist_subset_fname)
{
  FILE*fin,*fout,*fbzip2;
  char checksum[MAX_STR_LEN], outfile_fname[MAX_STR_LEN], tmp[MAX_STR_LEN], command[MAX_STR_LEN], *p, bigblk[16384], suffix[MAX_STR_LEN];
  int i,retval=0,finished=FALSE;
  long sliceno, siz;
  struct stat buf;

  if (!(fin=fopen(slice_fname(bigfileno,0,ARCHIVES_PATH,""),"r")))
    { log_to_screen("Cannot even open bigfile's info file");return(1); }
  fgets(checksum,MAX_STR_LEN-1,fin);
  fread((char*)(&buf), 1, sizeof(struct stat), fin);
  fclose(fin);
  p=(char*)strchr(checksum,'\t');
  if (!p)
    {sprintf(tmp,"Warning - bigfile %ld does not have a checksum",bigfileno);log_it(tmp); p=checksum;}
  *p='\0';
  sprintf(outfile_fname,"/mnt/RESTORING/%s",p+1);
  p=(char*)strchr(outfile_fname,'\t');
  if (p) {*p='\0';}
  for(i=strlen(outfile_fname); i>0 && outfile_fname[i-1]<32; i--);
  outfile_fname[i]='\0';
  /* skip file if we have a selective restore subset & it doesn't match */
  if (biggielist_subset_fname[0]!='\0' && !is_file_in_list(outfile_fname,biggielist_subset_fname))
    {
      sprintf(tmp,"Skipping %s (name isn't in biggielist subset)",outfile_fname);
      log_it(tmp);
      return(0);
    }
  /* otherwise, continue */
  sprintf(tmp,"Reassembling big file %ld (%s)",bigfileno+1,outfile_fname);
  log_it(tmp);
  if (does_file_exist(outfile_fname))
    {
      if (strstr(outfile_fname,"/dev/"))
        { sprintf(tmp,"%s already exists; that's cool: it's a /dev entry, which means this bigfile is an image of a disk partition", outfile_fname); }
      else
        { sprintf(tmp,"%s already exists; that's weird; I'll overwrite but I shan't delete it", outfile_fname); }
      log_it(tmp);
    }
  else
    {
      make_hole_for_file(outfile_fname);
    }

  /*
    last slice is zero-length and uncompressed; when we find it, we stop
    We DON'T wait until there are no more slices; if we did that,
    We might stop at end of CD, not at last slice (which is 0-len and uncompd)
  */

  if (!(fout=fopen(outfile_fname,"w"))) {fatal_error("RABFCD - Cannot openout outfile_fname");}
  for(sliceno=1,finished=FALSE; !finished; )
    {
      if (!does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"")) && !does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"lzo")) && !does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"bz2")))
	{
	  g_current_media_number++;
	  sprintf(tmp,"Asking for CD #%d so that I may read slice #%ld\n",g_current_media_number,sliceno);
	  log_it(tmp);
	  insist_on_this_cd_number(g_current_media_number);
	  sprintf(tmp,"Restoring from CD #%d",g_current_media_number);
	  log_to_screen(tmp);
	}
      else if (does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"")))
        {
	  sprintf(tmp,"End of bigfile # %ld\n",bigfileno); log_it(tmp);
	  finished=TRUE;
	}
      else
	{
	  if (does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"lzo")))
	    { strcpy(command,"lzop"); strcpy(suffix,"lzo"); }
	  else if (does_file_exist(slice_fname(bigfileno,sliceno,ARCHIVES_PATH,"bz2")))
	    { strcpy(command,"bzip2"); strcpy(suffix,"bz2"); }
	  else
	    { log_to_screen("OK, that's pretty fsck0red..."); return(1); }
          sprintf(command+strlen(command)," -dc %s",slice_fname(bigfileno,sliceno,ARCHIVES_PATH,suffix));
	  sprintf(tmp,"Working on file #%ld, slice #%ld    ",bigfileno+1,sliceno);
	  log_it(tmp);
	  newtDrawRootText(0,22,tmp); newtRefresh();
          strip_spaces(tmp);
	  update_progress_form(tmp);
	  fbzip2=popen(command,"r");
	  while(!feof(fbzip2))
	    {
	      siz=fread(bigblk,1,16384,fbzip2);
	      if (siz>0) { fwrite(bigblk,siz,1,fout); }
	    }
	  pclose(fbzip2);
          sliceno++;
          g_current_progress++;
        }
    }
  fclose(fout);
  chmod(outfile_fname, buf.st_mode);
  chown(outfile_fname, buf.st_uid, buf.st_gid);
  return(retval);
}





int restore_a_biggiefile_from_tape(struct s_bkpinfo *bkpinfo, char*orig_bf_fname, long biggiefile_number, char*orig_checksum, long long biggiefile_size, char*biggielist_subset_fname)
{
  FILE*pout,*fin;
  char tmp[MAX_STR_LEN],
    command[MAX_STR_LEN],
    biggiefile_fname[MAX_STR_LEN];
  long current_slice_number=0;
  int retval=0,res=0,ctrl_chr='\0';
  long long slice_siz;
  bool dummy_restore=FALSE;
  struct stat buf;

/* open out to biggiefile to be restored (or /dev/null if biggiefile is not to be restored) */
  if (biggielist_subset_fname[0]!='\0' && !is_file_in_list(orig_bf_fname,biggielist_subset_fname))
    {
      dummy_restore=TRUE;
      sprintf(biggiefile_fname,"/dev/null");
      sprintf(tmp,"Skipping big file %ld (%s) - not in biggielist subset",biggiefile_number+1,orig_bf_fname);
      log_it(tmp);
    }
  else
    {
      sprintf(biggiefile_fname,"/mnt/RESTORING/%s",orig_bf_fname);
      sprintf(tmp,"Reassembling big file %ld (%s)",biggiefile_number+1,orig_bf_fname);
      log_it(tmp);
      if (does_file_exist(biggiefile_fname))
        {
          if (strstr(biggiefile_fname,"/dev/"))
            { sprintf(tmp,"%s already exists; that's cool: it's a /dev entry, which means this bigfile is an image of a disk partition", biggiefile_fname); }
          else
            { sprintf(tmp,"%s already exists; that's weird; I'll overwrite but I shan't delete it", biggiefile_fname); }
          log_it(tmp);
        }
      else
        {
          make_hole_for_file(biggiefile_fname);
        }
    }
  sprintf(command,"%s -dc >> \"%s\"",bkpinfo->zip_exe, biggiefile_fname);
  sprintf(tmp,"Pipe command = '%s'",command);
  log_it(tmp);

/* restore biggiefile, one slice at a time */
  for(res=read_header_block_from_tape(&slice_siz, tmp, &ctrl_chr); ctrl_chr!=BLK_STOP_A_BIGGIE; res=read_header_block_from_tape(&slice_siz, tmp, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE) { wrong_marker(BLK_START_AN_AFIO_OR_SLICE,ctrl_chr); }
      sprintf(tmp,"Working on file #%ld, slice #%ld    ",biggiefile_number+1,current_slice_number);
      log_it(tmp);
      newtDrawRootText(0,21,tmp); newtRefresh();
      strip_spaces(tmp);
      update_progress_form(tmp);
      if (current_slice_number==0)
        {
          res=read_file_from_tape_to_file(bkpinfo,"/tmp/biggie-blah.txt",slice_siz);
          fin=fopen("/tmp/biggie-blah.txt","r");
          fgets(tmp,MAX_STR_LEN,fin);
          fread(&buf,1,sizeof(struct stat),fin);
          fclose(fin);
        }
      else
        {
          if (slice_siz) {if (!(pout=popen(command,"w"))) {fatal_error("Cannot pipe out");};}
          res=read_file_from_tape_to_stream(bkpinfo,pout,slice_siz);
	  if (slice_siz) {pclose(pout);}
        }
      retval+=res;
      res=read_header_block_from_tape(&slice_siz, tmp, &ctrl_chr);
      if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE) { wrong_marker(BLK_STOP_AN_AFIO_OR_SLICE,ctrl_chr); }
      current_slice_number++;
      g_current_progress++;
    }
  chmod(biggiefile_fname, buf.st_mode);
  chown(biggiefile_fname, buf.st_uid, buf.st_gid);
  return(retval);
}





int restore_a_tarball_from_CD(char *tarball_fname, int current_tarball_number, char*filelist_subset_fname)
{
  int retval=0,res;
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN], filelist_name[MAX_STR_LEN], executable[MAX_STR_LEN];

  system("mkdir -p /mnt/RESTORING/tmp");
  sprintf(filelist_name,"/mnt/cdrom/archives/filelist.%d",current_tarball_number);
  if (count_lines_in_file(filelist_name)<=0 || length_of_file(tarball_fname)<=0)
    {
      sprintf(tmp,"Unable to restore fileset #%d (CD I/O error)",current_tarball_number);
      log_to_screen(tmp);
      return(1);
    }
  if (strstr(tarball_fname,".bz2"))
    { strcpy(executable,"bzip2"); }
  else
    { strcpy(executable,"lzop"); }
  sprintf(tmp,"which %s > /dev/null 2> /dev/null",executable);
  if (system(tmp))
    { log_to_screen("compression program not found - oh no!"); finish(1); }
  if (filelist_subset_fname[0]!='\0')
    { sprintf(command,"afio -i -b %d -c 1024 -M 8m -P %s -Z -w %s %s",TAPE_BLOCK_SIZE, executable, filelist_subset_fname, tarball_fname); }
  else
    { sprintf(command,"afio -i -b %d -c 1024 -M 8m -P %s -Z %s",TAPE_BLOCK_SIZE, executable, tarball_fname); }
  res=run_program_and_log_output(command);
  retval+=res;
  if (retval)
    {
      sprintf(tmp,"Errors occurred while processing fileset #%d",current_tarball_number);
      log_it(tmp);
    }
  return(retval);
}




int restore_a_tarball_from_tape(struct s_bkpinfo*bkpinfo, char *tarball_fname, int current_tarball_number, char*filelist_subset_fname, long long size)
{
  int retval=0, res=0 /*, stat_val*/;
  /*FILE*pafio;*/
/*  pid_t pid, child_pid; */
  char tmp[MAX_STR_LEN], command[MAX_STR_LEN] , afio_fname[MAX_STR_LEN];

/* to do it with a file... */
  sprintf(tmp,"Restoring fileset #%d (%ld KB) from media #%d",current_tarball_number,(long) size>>10,g_current_media_number);
  log_it(tmp);
  system("mkdir -p /mnt/RESTORING/tmp");
/* Use RAMDISK's /tmp; saves time; oh wait, it's too small
   Well, pipe from tape to afio, then; oh wait, can't do that either: bug in 
   afio or someting; oh darn.. OK, use tmpfs :-) */
  sprintf(afio_fname, "/tmp/tmpfs/afio.tmp.%d", current_tarball_number);
  res=read_file_from_tape_to_file(bkpinfo,afio_fname,size);
  if (res) { log_it("Warning - error reading afioball from tape"); }
  if (filelist_subset_fname[0]!='\0')
    { sprintf(command,"afio -i -M 8m -b %d -P %s -Z -w %s %s 2>> %s",TAPE_BLOCK_SIZE,bkpinfo->zip_exe, filelist_subset_fname, afio_fname, MONDO_LOGFILE); }
  else
    { sprintf(command,"afio -i -M 8m -b %d -P %s -Z %s 2>> %s",TAPE_BLOCK_SIZE,bkpinfo->zip_exe, afio_fname, MONDO_LOGFILE); }
  log_it(command);
  res=system(command);
  if (res) { log_it("Warning - errors reported by afio"); }
  unlink(afio_fname);
  return(retval);

}






int restore_all_biggiefiles_from_CD(struct s_bkpinfo *bkpinfo, char *biggielist_subset_fname)
{
  int retval=0,res;
  long noof_biggiefiles, bigfileno=0, total_slices;
  char tmp[MAX_STR_LEN], finished;

  read_cfg_var(MONDO_CFG_FILE, "total-slices", tmp);
  total_slices = atol(tmp);
  sprintf(tmp,"Reassembling large files      ");
  mvaddstr_and_log_it(g_currentY,0,tmp);
  if (length_of_file(BIGGIELIST) < 6)
    {log_it("OK, no biggielist; not restoring biggiefiles");return(0);}
  noof_biggiefiles=count_lines_in_file(BIGGIELIST);
  if (noof_biggiefiles<=0)
    {log_it("OK, no biggiefiles in biggielist; not restoring biggiefiles");return(0);}
  sprintf(tmp,"OK, there are %ld biggiefiles in the archives",noof_biggiefiles);
  log_it(tmp);
  open_progress_form("Reassembling large files","I am now reassembling all the large files." , "Please wait. This may take some time.","", total_slices);
  for(bigfileno=0,finished=FALSE;!finished;)
    {
      sprintf(tmp,"About to think about restoring bigfile %ld",bigfileno);
      log_it(tmp);
      if (!does_file_exist(slice_fname(bigfileno,0,ARCHIVES_PATH,"")))
	{
	  log_it("...but its first slice isn't on this CD. Perhaps this was a selective restore?");
	  if (does_file_exist("/mnt/cdrom/archives/NOT-THE-LAST"))
	    {
	      insist_on_this_cd_number(++g_current_media_number);
	      sprintf(tmp,"Restoring from CD #%d",g_current_media_number);
	      log_to_screen(tmp);
	    }
	  else
	    {
	      sprintf(tmp,"There was no bigfile #%ld. That's OK.",bigfileno);
	      log_it(tmp);
	      log_it("I'm going to stop restoring bigfiles now.");
	      finished=TRUE;
	    }
	}
      else
	{
	  sprintf(tmp,"Restoring big file %ld",bigfileno+1);
	  update_progress_form(tmp);
	  res=restore_a_biggiefile_from_CD(bigfileno,biggielist_subset_fname);
	  retval+=res;
	  bigfileno++;
	}
    }
/*  if (bigfileno < noof_biggiefiles)
    { sprintf(tmp,"Warning - bigfileno=%ld but noof_biggiefiles=%ld\n",bigfileno,noof_biggiefiles); }
  else
    {
      sprintf(tmp,"%ld biggiefiles in biggielist.txt; %ld biggiefiles processed today.",noof_biggiefiles, bigfileno);
      log_it(tmp);
    }
*/
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}







int restore_all_tarballs_from_CD(struct s_bkpinfo *bkpinfo, char *filelist_subset_fname)
{
  int retval=0, res, attempts, current_tarball_number=0;
  long max_val;
  char tmp[MAX_STR_LEN], tarball_fname[MAX_STR_LEN], progress_str[MAX_STR_LEN];

  mvaddstr_and_log_it(g_currentY,0,"Restoring from archives");
  log_it("Insisting on 1st CD, so that I can have a look at LAST-FILELIST-NUMBER");
  if (g_current_media_number!=1) { log_it("OK, that's jacked up."); g_current_media_number=1;}
  insist_on_this_cd_number(g_current_media_number);
  read_cfg_var(MONDO_CFG_FILE, "last-filelist-number", tmp);
  max_val=atol(tmp)+1;
  sprintf(progress_str,"Restoring from CD #%d",g_current_media_number);
  log_to_screen(progress_str);
  open_progress_form("Restoring from archives","Restoring data from the archives." , "Please wait. This may take some time.",progress_str,max_val);
  for(;;)
    {
      insist_on_this_cd_number(g_current_media_number);
      update_progress_form(progress_str);
      sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.bz2",current_tarball_number);
      if (!does_file_exist(tarball_fname)) {sprintf(tarball_fname,"/mnt/cdrom/archives/%d.afio.lzo",current_tarball_number);}
      if (!does_file_exist(tarball_fname))
	{
	  if (current_tarball_number == 0)
	    {
	      log_to_screen("No tarballs. Strange. Maybe you only backed up freakin' big files?");
	      return(0);
	    }
	  if (!does_file_exist("/mnt/cdrom/archives/NOT-THE-LAST") || system("find /mnt/cdrom/archives/slice* > /dev/null 2> /dev/null")==0)
	    {
	      break;
	    }
	  g_current_media_number++;
	  sprintf(progress_str,"Restoring from CD #%d",g_current_media_number);
	  log_to_screen(progress_str);
	}
      else
        {
          sprintf(progress_str,"Restoring fileset #%d from CD #%d",current_tarball_number,g_current_media_number);
          for(res=999,attempts=0; attempts<3 && res!=0; attempts++)
            { res=restore_a_tarball_from_CD(tarball_fname,current_tarball_number,filelist_subset_fname); }
          sprintf(tmp,"CD #%d, fileset #%d - restore ", g_current_media_number, current_tarball_number);
          if (res) { strcat(tmp,"FAILED despite"); } else if (attempts>1) { strcat(tmp,"succeeded after"); } else { strcat(tmp,"succeeded"); }
          if (attempts>1) { sprintf(tmp+strlen(tmp)," %d attempts",attempts); }
          if (attempts>1) { log_to_screen(tmp); } else { log_it(tmp); }
          retval+=res;
          current_tarball_number++;
          g_current_progress++;
        }
    }
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}





int restore_all_biggiefiles_from_tape(struct s_bkpinfo *bkpinfo, char *biggielist_subset_fname)
{
  long noof_biggiefiles, current_bigfile_number=0, total_slices;
  int retval=0,res=0, ctrl_chr;
  char tmp[MAX_STR_LEN], biggie_fname[MAX_STR_LEN],
     biggie_cksum[MAX_STR_LEN], *p;
  long long biggie_size;

  read_cfg_var(MONDO_CFG_FILE, "total-slices", tmp);
  total_slices = atol(tmp);
  sprintf(tmp,"Reassembling large files      ");
  mvaddstr_and_log_it(g_currentY,0,tmp);
  res=read_header_block_from_tape(&biggie_size, biggie_fname, &ctrl_chr);
  if (bkpinfo->zip_exe[0]=='\0' || bkpinfo->zip_suffix[0]=='\0')
    { fatal_error("zip_exe and/or zip_suffix are undefined"); }
/*
  if (strstr(bkpinfo->zip_exe,"lzo")) {bkpinfo->use_lzo=TRUE;}
  if (strstr(bkpinfo->zip_exe,"bzip")) {bkpinfo->use_lzo=FALSE;}
*/
  if (ctrl_chr != BLK_START_BIGGIEFILES) { wrong_marker(BLK_START_BIGGIEFILES,ctrl_chr); }
  noof_biggiefiles=atol(biggie_fname);
  sprintf(tmp,"OK, there are %ld biggiefiles in the archives",noof_biggiefiles);
  log_it(tmp);
  open_progress_form("Reassembling large files","I am now reassembling all the large files." , "Please wait. This may take some time.","", total_slices);
  for(res=read_header_block_from_tape(&biggie_size, biggie_fname, &ctrl_chr); ctrl_chr!=BLK_STOP_BIGGIEFILES; res=read_header_block_from_tape(&biggie_size, biggie_fname, &ctrl_chr))
    {
      if (ctrl_chr != BLK_START_A_BIGGIE) { wrong_marker(BLK_START_A_BIGGIE,ctrl_chr); }
      p=strrchr(biggie_fname,'/');
      if (!p) {p=biggie_fname;} else {p++;}
      sprintf(tmp,"Restoring big file %ld (%lld K)",current_bigfile_number+1, biggie_size/1024);
      update_progress_form(tmp);
      res=restore_a_biggiefile_from_tape(bkpinfo,biggie_fname,current_bigfile_number,biggie_cksum,biggie_size,biggielist_subset_fname);
      retval+=res;
      current_bigfile_number++;
      g_current_progress++;
    }
  if (current_bigfile_number!=noof_biggiefiles && noof_biggiefiles!=0)
    { sprintf(tmp,"Warning - bigfileno=%ld but noof_biggiefiles=%ld\n",current_bigfile_number,noof_biggiefiles); }
  else
    { sprintf(tmp,"%ld biggiefiles in biggielist.txt; %ld biggiefiles processed today.",noof_biggiefiles, current_bigfile_number); }
  log_it(tmp);
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}








int restore_all_tarballs_from_tape(struct s_bkpinfo *bkpinfo, char *filelist_subset_fname)
{
  int retval=0, res, current_afioball_number=0, ctrl_chr;
  long max_val /*, total_noof_files */;
  char tmp[MAX_STR_LEN], progress_str[MAX_STR_LEN],
    tmp_fname[MAX_STR_LEN];
  long long tmp_size;

  mvaddstr_and_log_it(g_currentY,0,"Restoring from archives");
  read_cfg_var(MONDO_CFG_FILE, "last-filelist-number", tmp);
  max_val = atol(tmp)+1;
  chdir("/mnt/RESTORING"); /* I don't know why this is needed _here_ but it seems to be. -HR, 02/04/2002 */
  sprintf(progress_str,"Restoring from media #%d",g_current_media_number);
  log_to_screen(progress_str);
  open_progress_form("Restoring from archives","Restoring data from the archives." , "Please wait. This may take some time.",progress_str,max_val);

  log_it("hey");
  res=read_header_block_from_tape(&tmp_size, tmp_fname, &ctrl_chr);
  if (res) { log_it("Warning - error reading afioball from tape"); }
  retval+=res;
  if (ctrl_chr != BLK_START_AFIOBALLS) { wrong_marker(BLK_START_AFIOBALLS,ctrl_chr); }
  log_it("ho");
  for(res=read_header_block_from_tape(&tmp_size, tmp_fname, &ctrl_chr); ctrl_chr!=BLK_STOP_AFIOBALLS; res=read_header_block_from_tape(&tmp_size, tmp_fname, &ctrl_chr))
    {
      update_progress_form(progress_str);
      if (ctrl_chr != BLK_START_AN_AFIO_OR_SLICE) { wrong_marker(BLK_START_AN_AFIO_OR_SLICE,ctrl_chr); }
      sprintf(tmp,"Restoring fileset #%d (name=%s, size=%ld K)", current_afioball_number, tmp_fname, (long) tmp_size>>10);
      /*log_it(tmp);*/
      res=restore_a_tarball_from_tape(bkpinfo,tmp_fname,current_afioball_number,filelist_subset_fname,tmp_size);
      retval+=res;
      if (res)
        {
	  sprintf(tmp,"Fileset %d - errors occurred",current_afioball_number);
	  log_to_screen(tmp);
	}
      res=read_header_block_from_tape(&tmp_size, tmp_fname, &ctrl_chr);
      if (ctrl_chr != BLK_STOP_AN_AFIO_OR_SLICE) { wrong_marker(BLK_STOP_AN_AFIO_OR_SLICE,ctrl_chr); }
      current_afioball_number++;
      g_current_progress++;
      sprintf(progress_str,"Restoring fileset #%d from media #%d",current_afioball_number, g_current_media_number);
    }
  log_it("All done with afioballs");
  close_progress_form();
  if (retval)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}




int restore_everything(struct s_bkpinfo*bkpinfo, char *regular_files_to_restore, char*biggie_files_to_restore)
{
  int resA, resB;
  char cwd[MAX_STR_LEN], newpath[MAX_STR_LEN];

  g_current_media_number=1;
  getcwd(cwd,MAX_STR_LEN-1);
  chdir("/mnt/RESTORING");
  getcwd(newpath,MAX_STR_LEN-1);
  log_it("restoring everything");
  if (!system("which petris > /dev/null 2> /dev/null"))
    {
      newtDrawRootText(0,21,"Press ALT-<left cursor> twice to play Petris :-)"); newtRefresh();
    }
  if (bkpinfo->using_tape)
    {
      log_it("Restoring OS and data from tape");
      openin_tape(bkpinfo);
      resA=restore_all_tarballs_from_tape(bkpinfo,regular_files_to_restore);
      resB=restore_all_biggiefiles_from_tape(bkpinfo,biggie_files_to_restore);
      closein_tape(bkpinfo);
    }
  else if (bkpinfo->using_cdstream)
    {
      log_it("Restoring OS and data from cdstream");
      openin_cdstream(bkpinfo);
      resA=restore_all_tarballs_from_tape(bkpinfo,regular_files_to_restore);
      resB=restore_all_biggiefiles_from_tape(bkpinfo,biggie_files_to_restore);
      closein_cdstream(bkpinfo);
    }
  else
    {
      log_it("Restoring OS and data from CD");
      resA=restore_all_tarballs_from_CD(bkpinfo,regular_files_to_restore);
      resB=restore_all_biggiefiles_from_CD(bkpinfo,biggie_files_to_restore);
    }
  chdir(cwd);
  if (resA+resB)
    {
      log_to_screen("Errors occurred while data was being restored.");
    }
  if (length_of_file("/etc/raidtab") > 0)
    {
      log_it("Copying local raidtab to restored filesystem");
      run_program_and_log_output("cp -f /etc/raidtab /mnt/RESTORING/etc/raidtab");
    }
  kill_petris();
  return(resA+resB);
}








int run_boot_loader(bool offer_to_hack_scripts)
{
  int res, retval=0;
  char device[MAX_STR_LEN], tmp[MAX_STR_LEN], name[MAX_STR_LEN];

  read_cfg_var(MONDO_CFG_FILE, "bootloader.device", device);
  read_cfg_var(MONDO_CFG_FILE, "bootloader.name", name);
  sprintf(tmp,"run_boot_loader: device='%s', name='%s'",device,name);
  log_it(tmp);
  if (!strcmp(name,"LILO"))
    { res=run_lilo(offer_to_hack_scripts); }
  else if (!strcmp(name,"GRUB"))
    { res=run_grub(offer_to_hack_scripts); }
  else
    {
      log_to_screen("Unable to determine type of boot loader. Defaulting to LILO.");
      res=run_lilo(offer_to_hack_scripts);
    }
  retval+=res;
  if (res) { log_to_screen("Your boot loader returned an error"); }
  else { log_to_screen("Your boot loader ran OK"); }
  sprintf(tmp,"make-me-bootable /tmp/mountlist.txt");
  res=run_program_and_log_output(tmp);
  retval+=res;
  if (res) { log_to_screen("Errors occurred while making partition(s) bootable"); }
  else { log_to_screen("Partition(s) made bootable OK"); }
  return(retval);
}



int run_grub(bool offer_to_run_stabgrub)
{
  char command[MAX_STR_LEN], grub_executable[MAX_STR_LEN];
  int res,done;

  strcpy(command,"chroot /mnt/RESTORING grub-install '(hd0)'");
  find_pathname_of_executable_preferably_in_RESTORING(grub_executable,"grub");
  if (offer_to_run_stabgrub && ask_me_yes_or_no("Did you change the mountlist?"))

/* interactive mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Modifying fstab and grub.conf, and running GRUB...                             ");
      res=run_program_and_log_output("stabgrub-me");
      popup_and_OK("You will now edit fstab and grub.conf");
      for(done=FALSE;!done;)
	{
	  newtFinished();
	  system("vi /mnt/RESTORING/etc/fstab");
	  system("vi /mnt/RESTORING/etc/grub.conf");
	  newtInit();
	  newtCls();
	  if (ask_me_yes_or_no("Edit them again?")) {continue;}
	  res = run_program_and_log_output(command);
	  if (res)
	    {
	      done = ask_me_yes_or_no("GRUB failed. Re-edit system files?");
	    }
	  else
	    {
	      done = TRUE;
	    }
	}
    }
  else

/* nuke mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Running GRUB...                                                 ");
      res = run_program_and_log_output(command);
      if (res)
        {
          mvaddstr_and_log_it(g_currentY++,74,"Failed.");
          log_to_screen("GRUB ran w/error(s). Edit/run manually, please.");
        }
      else
       {  
          mvaddstr_and_log_it(g_currentY++,74,"Done.");
        }
    }
  return(res);
}



int run_lilo(bool offer_to_run_stablilo)
{
  char command[MAX_STR_LEN];
  int res,done;

  if (offer_to_run_stablilo && ask_me_yes_or_no("Did you change the mountlist?"))

/* interactive mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Modifying fstab and lilo.conf, and running LILO...                             ");
      sprintf(command,"stablilo-me");
      res=run_program_and_log_output(command);
      if (res)
        {
          popup_and_OK("You will now edit fstab and lilo.conf, to make sure they match your new mountlist.");
          for(done=FALSE;!done;)
            {
              newtFinished();
              system("vi /mnt/RESTORING/etc/fstab");
              system("vi /mnt/RESTORING/etc/lilo.conf");
              newtInit();
              newtCls();
              if (ask_me_yes_or_no("Edit them again?")) {continue;}
              res = run_program_and_log_output("chroot /mnt/RESTORING lilo -L");
              if (res) { res = run_program_and_log_output("chroot /mnt/RESTORING lilo"); }
              if (res)
                {
                  done = ask_me_yes_or_no("LILO failed. Re-edit system files?");
                }
              else
	        {
	          done = TRUE;
	        }
            }
	}
      else
	{
	  log_to_screen("lilo.conf and fstab were modified OK");
	}
    }
  else

/* nuke mode */
    {
      mvaddstr_and_log_it(g_currentY,0,"Running LILO...                                                 ");
      res = run_program_and_log_output("chroot /mnt/RESTORING lilo -L");
      if (res) { res = run_program_and_log_output("chroot /mnt/RESTORING lilo"); }
      if (res)
        {
          mvaddstr_and_log_it(g_currentY++,74,"Failed.");
          log_to_screen("Failed to re-jig fstab and/or lilo. Edit/run manually, please.");
        }
      else
       {  
          mvaddstr_and_log_it(g_currentY++,74,"Done.");
        }
    }
  return(res);
}

void save_disklist_to_file(char*listname, struct list_of_disks *disklist, FILE*fout)
{
  int i;
  for(i=0; i<disklist->entries; i++)
    {
      fprintf(fout,"    device                %s\n",disklist->el[i].device);
      fprintf(fout,"    %-21s %d\n",listname,disklist->el[i].index);
    }
}



void save_additional_vars_to_file(struct additional_raid_variables *vars, FILE*fout)
{
  int i;
  for(i=0; i<vars->entries; i++)
    {
      fprintf(fout,"    %-21s %s\n",vars->el[i].label, vars->el[i].value);
    }
}



void save_raidrec_to_file(struct raid_device_record *raidrec, FILE*fout)
{
  fprintf(fout,"raiddev %s\n",raidrec->raid_device);
  if (raidrec->raid_level==-1)
    { fprintf(fout,"    raid-level            linear\n"); }
  else
    { fprintf(fout,"    raid-level            %d\n",raidrec->raid_level); }
  fprintf(fout,"    chunk-size            %d\n",raidrec->chunk_size);
  fprintf(fout,"    nr-raid-disks         %d\n",raidrec->data_disks.entries); 
  fprintf(fout,"    nr-spare-disks        %d\n",raidrec->spare_disks.entries);
  if (raidrec->parity_disks.entries > 0)
    {fprintf(fout,"    nr-parity-disks       %d\n",raidrec->parity_disks.entries);}
  if (raidrec->failed_disks.entries > 0)
    {fprintf(fout,"    nr-failed-disks       %d\n",raidrec->failed_disks.entries);}
  fprintf(fout,"    persistent-superblock %d\n",raidrec->persistent_superblock);
  save_additional_vars_to_file(&raidrec->additional_vars,fout);
  fprintf(fout,"\n");
  save_disklist_to_file("raid-disk",&raidrec->data_disks, fout);
  save_disklist_to_file("spare-disk",&raidrec->spare_disks, fout);
  save_disklist_to_file("parity-disk",&raidrec->parity_disks, fout);
  save_disklist_to_file("failed-disk",&raidrec->failed_disks, fout);
  fprintf(fout,"\n");
}



int save_raidlist_to_raidtab(struct raidlist_itself *raidlist, char*fname)
{
  FILE*fout;
  int current_raid_device;
  if (raidlist->entries <= 0)
    {
      unlink(fname);
      log_it("Deleting raidtab (no RAID devs anyway)");
      return(0);
    }
  if (!(fout=fopen(fname,"w"))) {log_it("Failed to save raidlist");return(1);}
  for(current_raid_device=0; current_raid_device < raidlist->entries; current_raid_device++)
    {
      save_raidrec_to_file(&raidlist->el[current_raid_device],fout);
    }
  fclose(fout);
  return(0);
}



void sort_mountlist_by_device(struct mountlist_itself *mountlist)
{
  int diff,lino=-999;
  while (lino < mountlist->entries)
    {
      for(lino=1; lino < mountlist->entries; lino++)
	{
	  diff=strcmp_inc_numbers(mountlist->el[lino-1].device,mountlist->el[lino].device);
	  if (diff>0)
	    {
	      swap_mountlist_entries(mountlist,lino-1,lino);
	      break;
	    }
	}
    }
}




void sort_mountlist_by_mountpoint(struct mountlist_itself *mountlist, bool reverse)
{
  int diff,lino=-999;
  while(lino < mountlist->entries)
    {
      for(lino=1; lino < mountlist->entries; lino++)
	{
	  diff=strcmp(mountlist->el[lino-1].mountpoint,mountlist->el[lino].mountpoint);
	  if ((diff>0 && !reverse) || ((diff<0 && reverse)))
	    {
	      swap_mountlist_entries(mountlist,lino-1,lino);
	      break;
	    }
	}
    }
}



void streamline_changes_file(char*output_file,char*input_file)
{
  FILE*fin,*fout;
  char incoming[MAX_STR_LEN];
  if (!(fin=fopen(input_file,"r"))) {return;}
  if (!(fout=fopen(output_file,"w"))) {fatal_error("cannot open output_file");}
  for(fgets(incoming,MAX_STR_LEN-1,fin);!feof(fin);fgets(incoming,MAX_STR_LEN-1,fin))
    {
      if(strncmp(incoming,"etc/adjtime",11) \
      && strncmp(incoming,"etc/mtab",8) \
      && strncmp(incoming,"tmp/",4) \
      && strncmp(incoming,"boot/map",8) \
      && !strstr(incoming,"incheckentry") \
      && strncmp(incoming,"etc/mail/statistics",19) \
      && strncmp(incoming,"var/",4))
        {
          fprintf(fout,"%s",incoming); /* don't need \n here, for some reason.. */
        }      
    }
  fclose(fout);
  fclose(fin);
}




void success_message(void)
{
  int i;
  char tmp[MAX_STR_LEN];

  strcpy(tmp, call_program_and_get_last_line_of_output("date +%S"));
  i=atoi(tmp) % 32;
  if (i<26)
    {
      strcpy(tmp,"Mondo has restored your system. Please remove the backup media and reboot.");
    }
  else if (i==26)
    {
      strcpy(tmp,"M0nd0 h45 r3570r3d j00r 5y573m. P13453 r3m0v3 7h3 b4ckup m3d14 4nd r3b007.");
    }
  else
    {
      strcpy(tmp,"Visit http://www.microwerks.net/~hugo and click on PayPal to show some love! :-)");
    }
  popup_and_OK(tmp);
}




void swap_mountlist_entries(struct mountlist_itself *mountlist, int a, int b)
{
  char device[MAX_STR_LEN], mountpoint[MAX_STR_LEN], format[MAX_STR_LEN];
  long size;
  strcpy(device,                     mountlist->el[a].device);
  strcpy(mountpoint,                 mountlist->el[a].mountpoint);
  strcpy(format,                     mountlist->el[a].format);
  size=                              mountlist->el[a].size;
  strcpy(mountlist->el[a].device,    mountlist->el[b].device);
  strcpy(mountlist->el[a].mountpoint,mountlist->el[b].mountpoint);
  strcpy(mountlist->el[a].format,    mountlist->el[b].format);
  mountlist->el[a].size=             mountlist->el[b].size;
  strcpy(mountlist->el[b].device,    device);
  strcpy(mountlist->el[b].mountpoint,mountpoint);
  strcpy(mountlist->el[b].format,    format);
  mountlist->el[b].size=             size;
}



int unmount_all_devices(struct mountlist_itself *mountlist)
{
  int retval=0,lino,res=0,i;
  char command[MAX_STR_LEN],tmp[MAX_STR_LEN];
  run_program_and_log_output("df -m");
  system("chmod -R 1777 /mnt/RESTORING/tmp");
  mvaddstr_and_log_it(g_currentY,0,"Unmounting devices      ");
  open_progress_form("Unmounting devices","Unmounting all devices that were mounted," , "in preparation for the post-restoration reboot.","",mountlist->entries);
  chdir("/");
  for(i=0; i<10 && run_program_and_log_output("ps ax | grep buffer | grep -v \"grep buffer\"")==0; i++)
    {
      sleep(1);
      log_it("Waiting for buffer() to finish");
    }
  system("sync");
  if (system("cp -f /tmp/mondo-restore.log /mnt/RESTORING/tmp/ 2> /dev/null")) { log_it("Error. Failed to copy log to PC's /tmp dir."); }
  for(lino=mountlist->entries-1;lino>=0;lino--)
    {
      if (!strcmp(mountlist->el[lino].mountpoint,"lvm"))
        { continue; }
      sprintf(tmp,"Unmounting device %s  ",mountlist->el[lino].device);
      /*      log_it(tmp); */
      update_progress_form(tmp);
      if (is_this_device_mounted(mountlist->el[lino].device))
        {
          if (!strcmp(mountlist->el[lino].mountpoint,"swap"))
            { sprintf(command,"swapoff %s",mountlist->el[lino].device); }
          else
            { sprintf(command,"umount %s",mountlist->el[lino].device); }
	  /*	  strcat(command," 2> /dev/null"); */
	  res=run_program_and_log_output(command);
        }
      else
        {
          strcat(tmp,"...not mounted anyway :-) OK");
          res=0;
        }
      g_current_progress++;
      if (res)
	{
	  strcat(tmp,"...Failed");
	  retval++;
	  log_to_screen(tmp);
	}
      else
	{
	  log_it(tmp);
	}
    }
  close_progress_form();
  if (retval) { mvaddstr_and_log_it(g_currentY++,74,"Failed."); }
  else        { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  if (retval)
    {
      log_to_screen("Unable to unmount some of your partitions.");
    }
  else
    {
      log_to_screen("All partitions were unmounted OK.");
    }
  return(retval);
}




int what_number_cd_is_this()
{
  int cd_number=-1;

  if (! is_this_device_mounted("/mnt/cdrom"))
    { mount_cdrom(); }
  cd_number = atoi(last_line_of_file("/mnt/cdrom/archives/THIS-CD-NUMBER"));
  return(cd_number);
}






int save_mountlist_to_disk(struct mountlist_itself *mountlist, char*fname)
{
  FILE*fout;
  int i;
  if (!(fout=fopen(fname,"w"))) {log_it("WMTD - Cannot openout mountlist");return(1);}
  for(i=0; i< mountlist->entries; i++)
    {
      fprintf(fout,"%-15s %-15s %-15s %8ld\n",mountlist->el[i].device, mountlist->el[i].mountpoint, mountlist->el[i].format, mountlist->el[i].size);
    }
  fclose(fout);
  return(0);
}




int read_cfg_file_into_bkpinfo( char* cfg_file, struct s_bkpinfo *bkpinfo)
{
  char value[MAX_STR_LEN], tmp[MAX_STR_LEN];

  if (0==read_cfg_var(cfg_file, "using-cdstream", value))
    {
      bkpinfo->using_cdstream = TRUE;
      sprintf(bkpinfo->media_device, "/dev/cdrom");
      bkpinfo->media_size = 650; /* good guess */
    }
  if (0==read_cfg_var(cfg_file, "tapedev", value))
    {
      bkpinfo->using_tape = TRUE;
      strcpy(bkpinfo->media_device, value);
      read_cfg_var(cfg_file, "tapesize", value);
      bkpinfo->media_size = atol(value);
      sprintf(tmp,"Backup medium is TAPE --- dev=%s",bkpinfo->media_device);
      if (bkpinfo->media_size < 100)
	{ log_it("WARNING - really mind-numbingly stupid tape size"); }
      log_it(tmp);
    }
  else
    {
      bkpinfo->using_tape=FALSE;
      strcpy(bkpinfo->media_device,"/dev/cdrom"); /* we don't really need this var */
      bkpinfo->media_size=-1; /* 650, probably, but we don't need this var anyway */
      log_it("Backup medium is CD-R[W]");
    }
  read_cfg_var(cfg_file, "use-lzo", value);
  if (strstr(value,"yes"))
    {
      bkpinfo->use_lzo=TRUE;
      strcpy(bkpinfo->zip_exe, "lzop");
      strcpy(bkpinfo->zip_suffix, "lzo");
    }
  else
    {
      bkpinfo->use_lzo=FALSE;
      strcpy(bkpinfo->zip_exe, "bzip2");
      strcpy(bkpinfo->zip_suffix, "bz2");
    }

/* Also present in config file:-
	keymap-lives-here
	tapedev-has-data-disks
	bootloader.device
	bootloader.name
	nfs-server-mount
	nfs-server-path
	nfs-dev
	nfs-server-ipaddr
*/

  return(0);

}



/* ----------------------------------------------------------------------- */

int main(int argc, char*argv[])
{
  int c, retval=0, res;
  struct mountlist_itself the_mountlist;
  struct raidlist_itself the_raidlist;
  char tmp[MAX_STR_LEN];
  struct s_bkpinfo bkpinfo_orig, *bkpinfo;

/*
setup_newt_stuff();
popup_and_get_string("What fun", "Please enter some stuff", tmp);
newtFinished();
exit(0);
*/

  system("mkdir -p /var/log");
  system("umount /mnt/cdrom > /dev/null 2> /dev/null");
  system("mkdir -p /tmp/tmpfs"); /* just in case... */
  system("ln -sf /var/log/mondo-archive.log /tmp/mondo-restore.log");
  unlink(FILELIST_RESTTHESE);
  unlink(BIGGIELIST_RESTTHESE);

  sprintf(tmp,"-------------- Mondo Restore v%s -------------",MONDO_VERSION);
  log_it(tmp);
  bkpinfo=&bkpinfo_orig;
  reset_bkpinfo(bkpinfo);
  sprintf(bkpinfo->tmpdir, "/tmp");
  read_cfg_file_into_bkpinfo(MONDO_CFG_FILE, bkpinfo);
  setup_newt_stuff();
  retval=load_mountlist(&the_mountlist,MOUNTLIST_FNAME);
  load_raidtab_into_raidlist(&the_raidlist,RAIDTAB_FNAME);
  if (retval) { finish(1); }
  if (argc==2 && strcmp(argv[1],"--nuke")==0)
    { retval=nuke_mode(bkpinfo,&the_mountlist,&the_raidlist); }
  else if (argc==2 && strcmp(argv[1],"--interactive")==0)
    { retval=interactive_mode(bkpinfo,&the_mountlist,&the_raidlist); }
  else if (argc==2 && strcmp(argv[1],"--compare")==0)
    { retval=compare_mode(bkpinfo,&the_mountlist,&the_raidlist); }
  else if (argc==2 && strcmp(argv[1],"--iso")==0)
    { retval=iso_mode(bkpinfo,&the_mountlist,&the_raidlist); }
  else if (argc==2 && strcmp(argv[1],"--edit-mountlist")==0)
    {
      res=edit_mountlist(&the_mountlist, &the_raidlist);
      if (res) { finish(1); }
      save_mountlist_to_disk(&the_mountlist,MOUNTLIST_FNAME);
      save_raidlist_to_raidtab(&the_raidlist,RAIDTAB_FNAME);
      log_to_screen("I have finished editing the mountlist for you.");
      finish(0);
    }
  else if (argc!=1)
    {
      log_to_screen("Invalid paremeters");
      finish(1);
    }
  else
    { retval+=catchall_mode(bkpinfo,&the_mountlist,&the_raidlist); } /* user chooses mode & we go with that */

/* clean up at the end */
  if (retval)
    {
      if (c=='C') { mvaddstr_and_log_it(g_currentY++,0,"Run complete. See /tmp/changed.files for list of files that have changed."); }
      else { mvaddstr_and_log_it(g_currentY++,0,"Run complete. Errors were reported. Please run 'bug-me'."); }
    }
  else
    {
      if (bkpinfo->using_tape)
        { mvaddstr_and_log_it(g_currentY++,0,"Run complete. Please remove tape+floppy and reboot."); }
      else
	{
	  system("sync");
	  if (is_this_device_mounted("/mnt/cdrom")) { res=run_program_and_log_output("umount /mnt/cdrom"); }
	  else { res=0; }
	  /*	 if (res) { log_to_screen("WARNING - failed to unmount CD-ROM drive"); } */
          if (!g_ISO_mode)
            {
              res=run_program_and_log_output("eject /mnt/cdrom");
              if (res) { log_to_screen("WARNING - failed to eject CD-ROM disk"); }
            }
	  mvaddstr_and_log_it(g_currentY++,0,"Run complete. Please remove media and reboot.");
	}
    }
  sprintf(tmp,"Mondo-restore is exiting (retval=%d)                                      ",retval);
  log_to_screen(tmp);
  if (I_have_just_nuked)
    {
      if (!system("which post-nuke > /dev/null 2> /dev/null"))
        { run_program_and_log_output("post-nuke"); }
    }
  finish(retval);
  exit(retval);
}


/* end of mondo-restore.c */





