/* mondo-floppies.c                                                  03/04/2002


03/04
- if Mondo cannot figure out which boot loader the user is using,
  tell the user to read the manual and mention -l, -f switches

02/20
- added cdstream-related stuff

02/19
- allow user to exclude devices from mountlist with -E <stuff>

02/10
- replaced mojo-jojo-* tempfiles with proper names
- replaced &> with >,2>

02/02
- if Mindi fails then abort & ask user to check /var/log/mindi.log

01/31
- removed MINDI_HOME: it is unnecessary

01/29/2002
- moved functions here from mondo-archive.c
- handles files >2GB in size

*/


#include "my-stuff.h"

#define DEFAULT_1722MB_DISK "/dev/fd0u1722"
#define BACKUP_1722MB_DISK "/dev/fd0H1722"




extern long g_start_time, g_minimum_progress, g_maximum_progress,
  g_current_progress, g_currentY;     /* declared in mondo-tools.c */
extern char err_log_lines[NOOF_ERR_LINES][MAX_STR_LEN];

extern bool g_debugging, g_running_live, g_text_mode,
  g_cd_recovery, g_skip_floppies;



/* ---------------------- externs -------------------- */

extern bool ask_me_yes_or_no(char*);
extern int ask_me_OK_or_cancel(char*);
extern void close_evalcall_form(void);
extern void close_progress_form(void);
extern long count_lines_in_file(char*);
extern bool does_file_exist(char*);
extern void fatal_error(char*);
extern void finish(int);
extern long friendly_sizestr_to_sizelong(char*);
extern int grab_percentage_from_last_line_of_file(char*);
extern char *last_line_of_file(char*);
extern long long length_of_file(char*);
extern void log_file_end_to_screen(char*,char*);
extern void log_it(char*);
extern void log_tape_pos(void);
extern void log_to_screen(char*);
extern void mvaddstr_and_log_it(int, int, char *);
extern void open_evalcall_form(char*);
extern void open_progress_form(char*,char*,char*,char*,long);
extern void popup_and_OK(char*);
extern bool popup_and_get_string(char*,char*,char*);
extern int run_program_and_log_output(char*);
extern int run_program_and_log_to_screen(char*, char*);
extern long size_of_all_biggiefiles_K(struct s_bkpinfo *bkpinfo);
extern void strip_spaces(char*);
extern char *call_program_and_get_last_line_of_output(char*);
extern char *trim_empty_quotes(char*);
extern void update_evalcall_form(int);
extern void update_progress_form(char*);
extern char which_boot_loader(char*);
extern int write_one_liner_data_file(char*fname,char*contents);


/* --------------------- my routines ----------------- */



int call_mindi_to_supply_boot_disks(struct s_bkpinfo*);
bool does_device_exist(char*);
int format_disk_SUB(char*, char*);
int format_disk(char*);
int get_trackno_from_logfile(char*);
int offer_to_write_floppies(struct s_bkpinfo*, char*);
int write_image_to_floppy_SUB(char*, char*);
int write_image_to_floppy(char*, char*);




/* --------------------------------------------------- */

int call_mindi_to_supply_boot_disks(struct s_bkpinfo *bkpinfo)
{
  char tmp[MAX_STR_LEN], command[MAX_STR_LEN], use_lzo_sz[MAX_STR_LEN],
    bootldr_str[MAX_STR_LEN], ch,
    tape_device[MAX_STR_LEN], last_filelist_number[MAX_STR_LEN],
    broken_bios_sz[MAX_STR_LEN], cd_recovery_sz[MAX_STR_LEN],
    tape_size_sz[MAX_STR_LEN], devs_to_exclude[MAX_STR_LEN];
    long lines_in_filelist;
  int res;
  long estimated_total_noof_slices;

  sprintf(tmp,"echo \"%s\" | tr -s ' ' '\n' | grep -x \"/dev/.*\" | tr -s '\n' ' ' | awk '{print $0\"\\n\";}'", bkpinfo->exclude_paths);
  strcpy(devs_to_exclude, call_program_and_get_last_line_of_output(tmp));
  sprintf(tmp,"devs_to_exclude = '%s'",devs_to_exclude);
  log_it(tmp);
  mvaddstr_and_log_it(g_currentY,0,"Calling MINDI to create boot+data disks");
  sprintf(tmp,"%s/filelist.full",bkpinfo->tmpdir);
  lines_in_filelist = count_lines_in_file(tmp);
  sprintf(tmp,"%s/LAST-FILELIST-NUMBER",bkpinfo->tmpdir);
  strcpy(last_filelist_number, last_line_of_file(tmp));
  if (!bkpinfo->using_tape) {tape_size_sz[0]='\0'; tape_device[0]='\0';}
  else {sprintf(tape_size_sz,"%ld",bkpinfo->media_size); strcpy(tape_device,bkpinfo->media_device);}
  if (bkpinfo->use_lzo) { strcpy(use_lzo_sz,"yes"); }
  else { strcpy(use_lzo_sz,"no"); }
  strcpy(broken_bios_sz,"yes"); /* assume so */
  if (g_cd_recovery) { strcpy(cd_recovery_sz,"yes"); }
  else { strcpy(cd_recovery_sz,"no"); }
  ch=which_boot_loader(tmp);
  if (bkpinfo->boot_loader!='\0')
    {
      sprintf(tmp,"User specified boot loader. It is '%c'.",bkpinfo->boot_loader);
      log_it(tmp);
    }
  else
    {
      bkpinfo->boot_loader=ch;
    }
  if (bkpinfo->boot_device[0]!='\0')
    {
      sprintf(tmp,"User specified boot device. It is '%s'.",bkpinfo->boot_device);
      log_it(tmp);
    }
  else
    {
      strcpy(bkpinfo->boot_device, tmp);
    }
  if (bkpinfo->boot_loader!='L' && bkpinfo->boot_loader!='G')
    { fatal_error("Please specify your boot loader and device, e.g. -l GRUB -f /dev/hda. Type 'man mondoarchive' to read the manual."); }
  if (bkpinfo->boot_loader=='L') { strcpy(bootldr_str,"LILO"); }
  else if (bkpinfo->boot_loader=='G') { strcpy(bootldr_str,"GRUB"); }
  else { strcpy(bootldr_str,"unknown"); }
  sprintf(tmp,"Your boot loader is %s and it boots from %s",bootldr_str,bkpinfo->boot_device);
  log_to_screen(tmp);
  sprintf(tmp,"%s/BOOTLOADER.DEVICE",bkpinfo->tmpdir);
  write_one_liner_data_file(tmp,bkpinfo->boot_device);
  if (bkpinfo->using_cdstream)
    {
      sprintf(tmp,"%s/USING-CDSTREAM",bkpinfo->tmpdir);
      write_one_liner_data_file(tmp, "yes");
    }
  sprintf(tmp,"%s/BOOTLOADER.NAME",bkpinfo->tmpdir);
  write_one_liner_data_file(tmp,bootldr_str);
  estimated_total_noof_slices = size_of_all_biggiefiles_K(bkpinfo) / bkpinfo->optimal_set_size + 1;
/* add nfs stuff here? */
  sprintf(command,"mkdir -p %s/images",bkpinfo->scratchdir);
  system(command);
  sprintf(command,"mkdir -p %s/mnt/floppy",bkpinfo->scratchdir);
  system(command);
  sprintf(tmp, "BTW, I'm telling Mindi your kernel is '%s'", bkpinfo->kernel_path);
//  log_it(tmp);
  sprintf(command,"mindi --custom %s %s/images \"%s\" \"%s\" \"%s\" %ld \"%s\" %s \"%s\" %s %s %ld \"%s\"",
bkpinfo->tmpdir, bkpinfo->scratchdir, bkpinfo->kernel_path, tape_device, tape_size_sz, lines_in_filelist,
use_lzo_sz, cd_recovery_sz, bkpinfo->image_devs, broken_bios_sz, last_filelist_number,
estimated_total_noof_slices, devs_to_exclude);
  log_it(command);
/*  res=run_program_and_log_output(command); */
  res=run_program_and_log_to_screen(command,"Generating boot+data disks");
  if (!res) { log_to_screen("Boot+data disks were created OK"); }
  else { fatal_error("Mindi failed to create your boot+data disks. Please check /var/log/mindi.log to see exactly why."); }
  sprintf(command,"mv -f %s/images/mindi.iso /root/images/mindi",bkpinfo->scratchdir);
  log_it(command);
  system(command);
/*  popup_and_OK("Pause for effect"); */
  sprintf(tmp,"cp -f %s/images/all.tar.gz %s",bkpinfo->scratchdir,bkpinfo->tmpdir);
  if (system(tmp)) { fatal_error("Cannot find all.tar.gz in tmpdir"); }
  if (res)
    { mvaddstr_and_log_it(g_currentY++,74,"Errors."); }
  else
    { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(res);
}







bool does_device_exist(char*device)
{
  char tmp[MAX_STR_LEN];

  sprintf(tmp,"ls %s > /dev/null 2> /dev/null",device);
  if (system(tmp)) { return(FALSE); } else { return(TRUE); }
}



int format_disk_SUB(char*cmd, char*title)
{
  int res=0, percentage=0, maxtracks, trackno, last_trkno=0;
  char command[MAX_STR_LEN],
    tempfile[MAX_STR_LEN];
  FILE*pin;

/* if Debian then do bog-standard superformat; don't be pretty */
  if (strstr(cmd,"superformat"))
    { return(run_program_and_log_to_screen(cmd,title)); }
/* if not Debian then go ahead & use fdformat */
  strcpy(tempfile, call_program_and_get_last_line_of_output("mktemp -q /tmp/mondo.XXXXXXXX"));
  sprintf(command,"%s >> %s 2>> %s; rm -f %s",cmd,tempfile,tempfile,tempfile);
  log_it(command);
  open_evalcall_form(title);
  if (!(pin=popen(command,"r"))) { log_to_screen("fmt err"); return(1); }
  if (strstr(command,"1722")) { maxtracks=82; } else { maxtracks=80; }
  for(sleep(1); does_file_exist(tempfile); sleep(1))
    {
      trackno=get_trackno_from_logfile(tempfile);
      if (trackno<0 || trackno>80) {log_it("Weird track#");continue;}
      percentage=trackno*100/maxtracks;
      if (trackno<=5 && last_trkno>40)
	{
	  close_evalcall_form();
	  strcpy(title,"Verifying format");
	  open_evalcall_form(title);
	}
      last_trkno=trackno;
      update_evalcall_form(percentage);
    }
  close_evalcall_form();
  pclose(pin);
  unlink(tempfile);
  return(res);
}


int format_disk(char*device)
{
  int res;
  char command[MAX_STR_LEN], title[MAX_STR_LEN];
  if (!system("which superformat > /dev/null 2> /dev/null"))
    { sprintf(command,"superformat %s",device); }
  else
    { sprintf(command,"fdformat %s",device); }
  sprintf(title,"Formatting disk %s",device);
  while((res=format_disk_SUB(command,title)))
    {
      if (!ask_me_yes_or_no("Failed to format disk. Retry?"))
        {
          return(res);
        }
    }
  return(res);
}




int get_trackno_from_logfile(char*logfile)
{
  FILE*fin;
  int trackno, len;
  char datablock[32701]/*, tmp[MAX_STR_LEN]*/;

  fin=fopen(logfile,"r");
  len=fread(datablock,1,32700,fin);
  fclose(fin);
  if (len<=0) {return(0);}
  for(;len>0 && !isdigit(datablock[len-1]); len--);
  datablock[len--]='\0';
  for(;len>0 && isdigit(datablock[len-1]); len--);
  trackno=atoi(datablock+len);
  /*
  sprintf(tmp,"datablock=%s; trackno=%d",datablock+len, trackno);
  log_it(tmp);
  */
  return(trackno);
}






int offer_to_write_floppies(struct s_bkpinfo *bkpinfo, char*imagesdir)
{
  char tmp[MAX_STR_LEN], comment[MAX_STR_LEN],
    bootdisk_dev[MAX_STR_LEN], datadisk_dev[MAX_STR_LEN];
  int i,res=0;
  bool format_first;

  if (!ask_me_yes_or_no("Write boot and data disk images to 3.5\" floppy disks?"))
    { return(0); }
  if (does_device_exist(DEFAULT_1722MB_DISK)) { strcpy(bootdisk_dev,DEFAULT_1722MB_DISK); }
  else if (does_device_exist(BACKUP_1722MB_DISK)) { sprintf(bootdisk_dev,"/dev/fd0H1722"); }
  else { log_to_screen("Can't find a 1.72MB floppy device *sigh*"); return(1); }
  strcpy(datadisk_dev,"/dev/fd0");
  if (!does_device_exist(datadisk_dev)) { log_to_screen("Can't find a 1.44MB floppy device *sigh*"); return(1); }
  format_first=ask_me_yes_or_no("Do you want me to format the disks before I write to them?");
/* boot disk */
  if (ask_me_OK_or_cancel("About to write 1.72MB boot disk"))
    {
      log_to_screen("Writing boot floppy");
      if (format_first) {format_disk(bootdisk_dev);}
      sprintf(tmp,"%s/mindi-boot.1722.img",imagesdir);
      write_image_to_floppy(bootdisk_dev,tmp);
    }
  if (bkpinfo->using_tape || bkpinfo->using_cdstream)
    {
      log_to_screen("FYI, the data disks are stored on tape/CD for your convenience.");
      return(0);
    }
  for(i=1; i<99; i++)
    {
      sprintf(tmp,"%s/mindi-data-%d.img",imagesdir,i);
      log_it(tmp);
      if (!does_file_exist(tmp)) {log_it("...not found");break;}
      sprintf(comment,"About to write data disk #%d",i);
      if (ask_me_OK_or_cancel(comment))
        {
          sprintf(comment,"Writing data disk #%3d",i);
          log_to_screen(comment);
          if (format_first) {res+=format_disk(datadisk_dev);}
          res+=write_image_to_floppy(datadisk_dev,tmp);
        }
    }
  return(res);
}
 






int write_image_to_floppy(char*device, char*datafile)
{
  int res;
  while((res=write_image_to_floppy_SUB(device, datafile)))
    {
      if (!ask_me_yes_or_no("Failed to write image to floppy. Retry?"))
        {
          return(res);
        }
    }
  return(res);
}


int write_image_to_floppy_SUB(char*device, char*datafile)
{
  int res=0, percentage, blockno, maxblocks;
  char *p, tmp[MAX_STR_LEN], blk[1024], title[MAX_STR_LEN];
  FILE*fout,*fin;

  /* pretty stuff */
  if (!(p=strrchr(datafile,'/'))) {p=datafile;} else {p++;}
  sprintf(title,"Writing %s to floppy",p);
  open_evalcall_form(title);
  /* functional stuff */
  for(p=device+strlen(device);p!=device && isdigit(*(p-1));p--);
  maxblocks=atoi(p);
  sprintf(tmp,"maxblocks = %d; p=%s", maxblocks, p);
  log_it(tmp);
  /* copy data from image to floppy */
  if (!(fin=fopen(datafile,"r"))) {log_to_screen("Cannot open img");return(1);}
  if (!(fout=fopen(device,"w"))) {log_to_screen("Cannot open fdd"); return(1);}
  for(blockno=0; blockno<maxblocks; blockno++)
    {
      percentage=blockno*100/maxblocks;
      if (fread(blk,1,1024,fin)!=1024)  {res++;log_to_screen("img read err");}
      if (fwrite(blk,1,1024,fout)!=1024){res++;log_to_screen("fdd write err");}
      if (((blockno+1)%128)==0)
	{
	  system("sync"); /* fflush doesn't work; dunno why */
	  update_evalcall_form(percentage);
	}
    }
  fclose(fin);
  fclose(fout);
  close_evalcall_form();
  return(res);
}


























