/* mondo-archive.c                                                03/21/2002


03/21
- record hostname (Krzysztof Dubowik)

03/05
- if '-L' then test for lzop; abort if not present

03/01
- tell user to use 'su -' instead of 'su' if they are dumbasses

02/20
- added lots of cdstream-related code

02/18
- change tape-testing dd from 64K to 4K

02/14
- add tmp.mondo.NNNN to tempdir path, if tempdir is specified by user
- add mondo.scratch.NNN to scratchdir path, if scratchdir is specified by user
- fixed typo - should say "man mondarchive"

02/12
- if errors apparently occurred, don't just say, "Errors occurred": ask the
  user to check the logs as a precaution
- insist on cdrecord being installed if -c or -w
- replaced '&> /dev/null' with '> /dev/null 2> /dev/null'

02/10
- don't try to write floppies if images don't exist
- don't force user to specify tape size if verifying only

02/06
- NFS-related fixes

02/04
- don't log g_mondo_home
- estimate, log + print the number of CD's/tapes required if backing up
- find Mondo's homedir automatically
- don't try to use 'dd' to check the validity of device unless it is a tape

02/01
- added /tmp/mondo-restore.cfg file, with a view to replacing
  the various boot-time BLAH-BLAH and FOO-BAR files in /tmp and /

01/31
- minor improvements to parameter-related feedback/errors

01/29/2002
- ported remaining shell script to C
- handles files >2GB in size

*/


#include "my-stuff.h"





char g_startdir[MAX_STR_LEN];

long g_noof_sets=0;


FILE *g_tape_stream=NULL;
long long g_tape_posK=0;

/*int current_backup_media;*/



extern long g_start_time, g_minimum_progress, g_maximum_progress,
  g_current_progress, g_currentY;     /* declared in mondo-tools.c */
extern char err_log_lines[NOOF_ERR_LINES][MAX_STR_LEN];

newtComponent g_progressForm;

int g_current_media_number;


/*int current_backup_media;*/




bool g_debugging=FALSE, g_running_live=FALSE, g_text_mode=TRUE,
  g_cd_recovery=FALSE, g_skip_floppies=FALSE;

char g_mondo_home[MAX_STR_LEN];


/* ---------------------- externs -------------------- */


extern int add_files_to_cd(struct s_bkpinfo*, char list_of_files[ARBITRARY_MAXIMUM][MAX_STR_LEN],int);
extern int add_files_to_media(struct s_bkpinfo*, char list_of_files[ARBITRARY_MAXIMUM][MAX_STR_LEN],int);
extern int add_file_to_tape(struct s_bkpinfo*, char*);
extern int ask_me_yes_or_no(char*);
extern int ask_me_OK_or_cancel(char*);
extern char *calc_checksum_of_file(char*filename);
extern char *call_program_and_get_last_line_of_output(char *call);
extern void call_filelist_chopper(struct s_bkpinfo*);
extern int call_mindi_to_supply_boot_disks(struct s_bkpinfo*);
extern void center_string(char*,int);
extern int chop_filelist(char*, char*, long);
extern void close_evalcall_form(void);
extern void close_progress_form(void);
extern long count_lines_in_file(char*);
extern bool does_file_exist(char*);
extern int do_that_initial_stuff_dude(struct s_bkpinfo*);
extern int do_that_final_stuff_dude(struct s_bkpinfo*);
extern void exclude_nonexistent_files(char*);
extern void fatal_error(char*);
extern int find_and_mount_actual_cd(char*);
extern int find_cdrom_device(char*); /* /dev entry */
int find_cdrw_device(char*); /* SCSI NODE */
extern void finish(int);
extern long friendly_sizestr_to_sizelong(char*);
extern int get_last_filelist_number(struct s_bkpinfo*);
extern long get_time(void);
extern int grab_percentage_from_last_line_of_file(char*);
extern char *last_line_of_file(char*);
extern long long length_of_file(char*);
extern void log_file_end_to_screen(char*,char*);
extern void log_it(char*);
extern void log_tape_pos(void);
extern void log_to_screen(char*);
extern int make_afioballs_and_images(struct s_bkpinfo*);
extern int make_checksum_list_file(char*, char*, char*);
extern int make_iso_fs(struct s_bkpinfo*, char*);
extern int make_slices_and_images(struct s_bkpinfo*, char*);
extern int make_tape_archives(char *);
extern int make_those_afios_dude(struct s_bkpinfo*);
extern int make_those_slices_dude(struct s_bkpinfo*);
extern char *marker_to_string(int);
extern int mount_CDROM_here(char*,char*);
extern void mvaddstr_and_log_it(int, int, char *);
extern char *number_to_text(int);
extern int offer_to_write_floppies(struct s_bkpinfo*, char*);
extern int openin_tape(struct s_bkpinfo*);
extern int openout_tape(char*);
extern void open_evalcall_form(char*);
extern void open_progress_form(char*,char*,char*,char*,long);
extern void pause_and_ask_for_cdr(int);
extern void popup_and_OK(char*);
extern bool popup_and_get_string(char*,char*,char*);
extern int prepare_filelist(struct s_bkpinfo *);
extern void process_to_buffer_tape_IO(void);
extern int read_cfg_var(char*,char*,char*);
extern int read_file_from_tape_to_file(struct s_bkpinfo*, char*, long long);
extern int read_file_from_tape_to_stream(struct s_bkpinfo*, FILE*, long long);
extern int read_header_block_from_tape(long long *, char*, int *);
extern void reset_bkpinfo(struct s_bkpinfo*);
extern int run_program_and_log_output(char*);
extern int run_program_and_log_to_screen(char*, char*);
extern void setup_newt_stuff(void);
extern long size_of_all_biggiefiles_K(struct s_bkpinfo *);
extern char *slice_fname(long,long,char*,char*);
extern int slice_up_file_etc(struct s_bkpinfo*, char*, long, long);
extern long long space_occupied_by_cd(char *);
extern int strcmp_inc_numbers(char*,char*);
extern char *strip_afio_output_line(char*);
extern void strip_spaces(char*);
extern int tar_this_set(struct s_bkpinfo*, char*, char*, int);
extern char *trim_empty_quotes(char*);
extern void update_evalcall_form(int);
extern void update_progress_form(char*);
extern char which_boot_loader(char*);
extern int verify_cd_image(struct s_bkpinfo*);
extern int verify_tape_backups(struct s_bkpinfo*);
extern int write_cfg_var(char*,char*,char*);
extern int write_data_disks_to_tape(char*);
extern int write_file_to_tape_from_file(struct s_bkpinfo*, char*);
extern int write_header_block_to_tape(long long, char*, int);
extern void wrong_marker(int,int);
extern int write_one_liner_data_file(char*fname,char*contents);
extern int write_final_iso_if_necessary(struct s_bkpinfo*);
extern int write_iso_and_go_on(struct s_bkpinfo*,bool);


/* --------------------- my routines ----------------- */
int eval_call(struct s_bkpinfo*, char*,char*,int,char*,char*);
int handle_incoming_parameters(int argc, char*argv[], struct s_bkpinfo *bkpinfo);
int process_switches(struct s_bkpinfo *bkpinfo, char flag_val[128][MAX_STR_LEN], bool flag_set[128]);
void resolve_naff_tokens(char*,char*,char*,char*);
int retrieve_switches_from_command_line(int argc, char*argv[], char flag_val[128][MAX_STR_LEN], bool flag_set[128]);
void store_nfs_config(struct s_bkpinfo*);

/*------------------------------ dummies ------------------------------*/

int what_number_cd_is_this(void) {log_it("FOO1");exit(100);}
int load_mountlist(struct mountlist_itself*a,char*b) {log_it("FOO2");exit(100);}
int load_raidtab_into_raidlist(struct raidlist_itself*a, char*b) {log_it("FOO101");exit(101);}
//int make_list_of_drives(struct mountlist_itself*a, char **b) {log_it("FOO3");exit(100);}
//drivelist[ARBITRARY_MAXIMUM][MAX_STR_LEN]) {exit(100;}
void sort_mountlist_by_device(struct mountlist_itself*a,bool b) {log_it("FOO4");exit(100);}
void sort_mountlist_entries(struct mountlist_itself*a,bool b) {log_it("FOO5");exit(100);}
void swap_mountlist_entries(struct mountlist_itself*a,int b,int c){log_it("FOO6");exit(100);}
bool g_ISO_mode=FALSE;
void wipe_temp_and_scratch_dirs(struct s_bkpinfo *bkpinfo);


/*---------------------------------------------------------------------*/


void copy_mondo_and_mindi_stuff_to_scratchdir(struct s_bkpinfo *bkpinfo)
{
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN];

  mvaddstr_and_log_it(g_currentY,0,"Copying Mondo's core files to the scratch directory");
  sprintf(command,"cp --parents -pRdf %s %s",g_mondo_home,bkpinfo->scratchdir);
  if (run_program_and_log_output(command)) { fatal_error("Failed to copy Mondo's stuff to scratchdir"); }
  sprintf(command,"cp -f %s/LAST-FILELIST-NUMBER %s",bkpinfo->tmpdir,bkpinfo->scratchdir);
  if (run_program_and_log_output(command)) { fatal_error("Failed to copy LAST-FILELIST-NUMBER to scratchdir"); }
  strcpy(tmp, call_program_and_get_last_line_of_output("which mondorestore"));
  sprintf(command,"cp -f %s %s", tmp, bkpinfo->tmpdir);
  if (run_program_and_log_output(command)) { fatal_error("Failed to copy mondorestore to tmpdir"); }
  sprintf(command,"hostname > %s/HOSTNAME",bkpinfo->scratchdir);
  system(command);  mvaddstr_and_log_it(g_currentY++,74,"Done.");
}



int eval_call(struct s_bkpinfo*bkpinfo, char*basic_call, char*isofile, int cd_no, char*logstub, char*what_i_am_doing)
{
  int retval=0,res=0,blanklines=0,jj,i;
  FILE*fin;
  char midway_call[MAX_STR_LEN],ultimate_call[MAX_STR_LEN],tmp[MAX_STR_LEN],command[MAX_STR_LEN],incoming[MAX_STR_LEN],old_stderr[MAX_STR_LEN],stderr_fname[MAX_STR_LEN], lockfile[MAX_STR_LEN], cd_number_str[MAX_STR_LEN];
  old_stderr[0]='\0';
  sprintf(cd_number_str,"%d",cd_no);
  resolve_naff_tokens(midway_call,basic_call,isofile,"_ISO_");
  resolve_naff_tokens(tmp,midway_call,cd_number_str,"_CD#_");
  sprintf(stderr_fname,"%s/stderr.txt",bkpinfo->tmpdir);
  resolve_naff_tokens(ultimate_call,tmp,stderr_fname,"_ERR_");
  sprintf(lockfile, call_program_and_get_last_line_of_output("mktemp -q /tmp/mondo.XXXXXXXX"));
  sprintf(command,"echo hi > %s ; %s 2> %s; res=$?; rm -f %s; exit $res",lockfile,ultimate_call,stderr_fname,lockfile);
  open_evalcall_form(what_i_am_doing);
  sprintf(tmp,"%s",command);
  log_it(tmp);
  fin=popen(command,"r");
  if (!fin)
    {
      sprintf(tmp,"Failed utterly to call '%s'",command);
      log_to_screen(tmp);
      return(1);
    }
  for(i=0; i<5 && !does_file_exist(lockfile); sleep(1),i++);
  for(; does_file_exist(lockfile); sleep(1))
    {
      log_file_end_to_screen(stderr_fname,"");
      jj=grab_percentage_from_last_line_of_file(stderr_fname);
      update_evalcall_form(jj);
    }
  for(fgets(incoming,MAX_STR_LEN,fin); !feof(fin); fgets(incoming,MAX_STR_LEN,fin))
    {
      incoming[78]='\0';
      while (incoming[strlen(incoming)-1]<32)
	{ incoming[strlen(incoming)-1]='\0'; }
      if (strlen(incoming)==0)
	{
	blanklines++;
	/*	if (blanklines>5) {break;}     */
	}
      log_to_screen(incoming);
    }
  if (pclose(fin)) {res=1;}
  retval+=res;
  close_evalcall_form();
  sprintf(tmp,"cat %s >> %s",stderr_fname,MONDO_LOGFILE);
  system(tmp);
  unlink(stderr_fname);
  return(retval);
}







int handle_incoming_parameters(int argc, char*argv[], struct s_bkpinfo *bkpinfo)
{
  int res=0, retval=0, i;
  char command[MAX_STR_LEN], tmp[MAX_STR_LEN];
  char flag_val[128][MAX_STR_LEN];
  bool flag_set[128];

  for(i=0; i<128; i++) { flag_val[i][0]='\0'; flag_set[i]=FALSE; }
  strcpy(bkpinfo->tmpdir, "/root/images/mondo");
  strcpy(bkpinfo->scratchdir, "/home");
  bkpinfo->compression_level = 3;
  bkpinfo->optimal_set_size=5*1024;
  getcwd(g_startdir,MAX_STR_LEN);
  strcpy(bkpinfo->isodir, "/root/images/mondo");
  sprintf(command,"mkdir -p %s 2> /dev/null",bkpinfo->isodir);
  system(command);
  strcpy(bkpinfo->include_paths,"/");
  bkpinfo->media_size=650; /* default */
  res = retrieve_switches_from_command_line(argc, argv, flag_val, flag_set);
  retval+=res;
  if (!retval)
    {
      res = process_switches(bkpinfo, flag_val, flag_set);
      retval += res;
    }
  if (!retval)
    {
      log_it("Switches:-");
       for(i=0; i<128; i++)
        {
          if (flag_set[i])
            {
              sprintf(tmp, "-%c %s",i, flag_val[i]);
              log_it(tmp);
            }
        }
    }
  sprintf(tmp, "rm -Rf %s/tmp.mondo.*", bkpinfo->tmpdir); system(tmp);
  sprintf(tmp, "rm -Rf %s/mondo.scratch.*", bkpinfo->scratchdir); system(tmp);
  sprintf(bkpinfo->tmpdir + strlen(bkpinfo->tmpdir), "/tmp.mondo.%ld",random()%32767);
  sprintf(bkpinfo->scratchdir + strlen(bkpinfo->scratchdir), "/mondo.scratch.%ld",random()%32767);
  sprintf(tmp,"mkdir -p %s/tmpfs", bkpinfo->tmpdir); system(tmp);
  sprintf(tmp,"mkdir -p %s",bkpinfo->scratchdir); system(tmp);
  if (bkpinfo->nfs_mount[0]!='\0') { store_nfs_config(bkpinfo); }
  return(retval);
}








int process_switches(struct s_bkpinfo *bkpinfo, char flag_val[128][MAX_STR_LEN], bool flag_set[128])
{
  int i, retval=0;
  char extra_cdrom_params[MAX_STR_LEN], tmp[MAX_STR_LEN];

/* compulsory */
  i = flag_set['c']+flag_set['i']+flag_set['n']+flag_set['t']+flag_set['w']+flag_set['C'];
  if (i==0) { retval++; fprintf(stderr,"You must specify the media type\n"); }
  if (i>1)  { retval++; fprintf(stderr,"Please specify only one media type\n"); }
  i = flag_set['O']+flag_set['V'];
  if (i==0) { retval++; fprintf(stderr,"Specify backup (-O), verify (-V) or both.\n"); }
  bkpinfo->backup_data = flag_set['O'];
  bkpinfo->verify_data = flag_set['V'];
  if (flag_set['I'] && !bkpinfo->backup_data) { log_to_screen("-I switch is ignored if just verifying"); }
  if (flag_set['E'] && !bkpinfo->backup_data) { log_to_screen("-E switch is ignored if just verifying"); }
  if (flag_set['I'])
    {
      strcpy(bkpinfo->include_paths, flag_val['I']);
      if (bkpinfo->include_paths[0]=='-' || bkpinfo->include_paths[0]=='\0')
        { retval++; fprintf(stderr, "Please supply a sensible value with '-I'\n"); }
    }
  if (flag_set['c'] || flag_set['w'] || flag_set['C'])
    {
      if (system("which cdrecord > /dev/null 2> /dev/null"))
        { fatal_error("Please install cdrecord and try again."); }
      if (flag_set['C'])
        {
          bkpinfo->using_cdstream=TRUE;
          bkpinfo->cdrw_speed=2;
          if (!flag_set['L']) { retval++; fprintf(stderr,"Please use -L with -C. It is mandatory.\n"); }
        }
      else
        {
          bkpinfo->cdrw_speed = atoi((flag_set['c']) ? flag_val['c'] : flag_val['w']);
          if (bkpinfo->cdrw_speed<2)
            { fatal_error("You specified a silly speed for a CD-R[W] drive"); }
        }
    }
  if (flag_set['t'])
    {    /* tape size */
      bkpinfo->using_tape = TRUE;
      if (flag_set['O'])
        {
          if (flag_set['s']) { bkpinfo->media_size = friendly_sizestr_to_sizelong(flag_val['s']); }
          else { retval++; fprintf(stderr, "Tape size not specified.\n"); }
        }
    }
  else
    {     /* CD size */
      bkpinfo->using_tape = FALSE;
      if (flag_set['s']) { bkpinfo->media_size = friendly_sizestr_to_sizelong(flag_val['s']); }
      if (flag_set['w']) { bkpinfo->wipe_media_first = TRUE; } /* CD-RW */
    }
  if (flag_set['n']) 
    {
      strcpy(bkpinfo->nfs_mount, flag_val['n']); 
      if (!flag_set['d']) { strcpy(bkpinfo->nfs_remote_dir, "/"); }
      sprintf(tmp,"mount | grep -x \"%s .*\" | cut -d' ' -f3", bkpinfo->nfs_mount);
      strcpy(bkpinfo->isodir, call_program_and_get_last_line_of_output(tmp));
      if (strlen(bkpinfo->isodir)<3)
        { retval++; fprintf(stderr, "NFS share is not mounted. Please mount it.\n"); }
      sprintf(tmp,"mount = %s", bkpinfo->nfs_mount);
      //      log_it(tmp);
      sprintf(tmp,"isodir= %s", bkpinfo->isodir);
      //      log_it(tmp);
      sprintf(tmp,"ls %s/%s", bkpinfo->isodir, bkpinfo->nfs_remote_dir);
      if (run_program_and_log_output(tmp))
        { retval++; fprintf(stderr, "Are you sure directory '%s' exists in remote dir '%s'?\n", bkpinfo->nfs_remote_dir, bkpinfo->nfs_mount); }
    }

/* optional, popular */
  if (flag_set['E']) { strcpy(bkpinfo->exclude_paths, flag_val['E']); }
  if (flag_set['g']) { g_text_mode=FALSE; }
  if (flag_set['D']) { bkpinfo->differential=TRUE; }
  if (flag_set['x']) { strcpy(bkpinfo->image_devs, flag_val['x']); }
  if (flag_set['k'])
    {
      strcpy(bkpinfo->kernel_path, flag_val['k']);
      if (!strcmp(bkpinfo->kernel_path, "failsafe"))
        { strcpy(bkpinfo->kernel_path,"FAILSAFE"); }
      if (strcmp(bkpinfo->kernel_path, "FAILSAFE") && !does_file_exist(bkpinfo->kernel_path))
        { retval++; fprintf(stderr,"You specified kernel '%s', which does not exist\n", bkpinfo->kernel_path); }
    }
  if (flag_set['d'])
    { /* backup directory (if ISO/NFS) */
      if (flag_set['i'])
        { strcpy(bkpinfo->isodir, flag_val['d']); }
      else if (flag_set['n'])
        { strcpy(bkpinfo->nfs_remote_dir, flag_val['d']); }
      else/* backup device (if tape/CD-R/CD-RW) */
        {
          strcpy(bkpinfo->media_device,flag_val['d']);
/*
          if (flag_set['t'])
            {
              sprintf(tmp, "dd if=%s of=/dev/null bs=1024 count=4", bkpinfo->media_device);
              if (run_program_and_log_output(tmp))
                { retval++; fprintf(stderr,"Tape drive '%s' does not exist or tape not in drive.\n", bkpinfo->media_device); }
            }
*/
        }
    }
  if (!flag_set['d'] && (flag_set['c'] || flag_set['w'] || flag_set['C']))
    {
      if (find_cdrw_device(bkpinfo->media_device))
        { retval++; fprintf(stderr,"Tried and failed to find CD-R[W] drive automatically.\n"); }
      else
        { flag_set['d'] = TRUE; strcpy(flag_val['d'], bkpinfo->media_device); }
    }
  if (!flag_set['d'] && !flag_set['n'] && !flag_set['C'])
    { retval++; fprintf(stderr,"Please specify the backup device/directory.\n"); }

/* optional, obscure */
  for(i='1'; i<='9'; i++)
    {
      if (flag_set[i]){bkpinfo->compression_level = i-'0';} /* not '\0' but '0' */
    }
  if (flag_set['S']) { sprintf(bkpinfo->scratchdir, "%s/mondo.scratch.%ld", flag_val['S'], random()%32768); }
  if (flag_set['T']) { sprintf(bkpinfo->tmpdir, "%s/tmp.mondo.%ld", flag_val['T'], random()%32768); }
  if (flag_set['A']) { strcpy(bkpinfo->call_after_iso, flag_val['A']); }
  if (flag_set['B']) { strcpy(bkpinfo->call_before_iso,flag_val['B']); }
  if (flag_set['F']) { g_skip_floppies=TRUE; }
  if (flag_set['H']) { g_cd_recovery=TRUE; }
  if (flag_set['l']) { bkpinfo->boot_loader        = flag_val['l'][0]; }
  if (flag_set['f']) { strcpy(bkpinfo->boot_device,  flag_val['f']); }
  if (flag_set['P']) { strcpy(bkpinfo->postnuke_tarball,    flag_val['P']); }
  if (flag_set['L'])
    {
      bkpinfo->use_lzo=TRUE;
      if (run_program_and_log_output("which lzop"))
        { retval++; fprintf(stderr,"Please install LZOP. You can't use '-L' until you do.\n"); }
    }

/* and finally... */
  g_current_media_number=1;
  if (bkpinfo->use_lzo)
    {
      strcpy(bkpinfo->zip_exe,"lzop");
      strcpy(bkpinfo->zip_suffix,"lzo");
    }
  else
    {
      strcpy(bkpinfo->zip_exe,"bzip2");
      strcpy(bkpinfo->zip_suffix,"bz2");
    }
  if (flag_set['c'] || flag_set['w'])
    {
      extra_cdrom_params[0]='\0';
      strcpy(tmp, call_program_and_get_last_line_of_output("cdrecord -version"));
      if (tmp[0]=='\0')
        { strcpy(tmp, call_program_and_get_last_line_of_output("cdrecord --version")); }
      if (tmp[0]=='\0')
        { fatal_error("Cannot discern cdrecord's version#"); }
      if (strstr(tmp, " 1.7") || strstr(tmp, " 1.8"))
        { log_to_screen("Warning - cdrecord does not support -waiti. Upgrade soon!"); }
      else
        { strcat(extra_cdrom_params,"-waiti "); }
      if (flag_set['w'])
        { strcat(extra_cdrom_params,"blank=fast "); }
      sprintf(bkpinfo->call_make_iso, "mkisofs -b images/mindi-boot.2880.img \
-c boot.cat -J -r -p MondoRescue -P www.microwerks.net/~hugo/ -A Mondo_Rescue_GPL_Version \
-V _CD#_ . 2> _ERR_ | cdrecord -eject %s fs=4m dev=%s speed=%d -", \
extra_cdrom_params, bkpinfo->media_device, bkpinfo->cdrw_speed);
    }
  if (flag_set['t'] && flag_set['O'])
    {
      sprintf(tmp,"dd if=/dev/zero of=%s bs=4k count=1 > /dev/null 2> /dev/null", bkpinfo->media_device);
      if (system(tmp))
        { retval++; fprintf(stderr,"Cannot write to tape device. Is the tape set read-only?\n"); }
    }
  //  log_it("Finished processing incoming params");
  if (retval) { fprintf(stderr, "Type 'man mondoarchive' for help.\n"); }
  return(retval);
}






void resolve_naff_tokens(char*output,char*ip,char*value,char*token)
{
  char input[MAX_STR_LEN],*p;
  strcpy(output,ip); /* just in case the token doesn't appear in string at all */
  for(strcpy(input,ip); strstr(input,token); strcpy(input,output))
    {
      strcpy(output,input);
      p=strstr(output,token);
      *p='\0';
      strcat(output,value);
      p=strstr(input,token) + strlen(token);
      strcat(output,p);
    }
}




int retrieve_switches_from_command_line(int argc, char*argv[], char flag_val[128][MAX_STR_LEN], bool flag_set[128])
{
  int opt,i;
  bool bad_switches=FALSE;

  for(i=0;i<128;i++) { flag_val[i][0]='\0'; flag_set[i]=FALSE; }
  while((opt = getopt(argc, argv, "123456789A:B:CDE:FHI:LOP:S:T:Vc:d:f:gik:l:n:s:tw:x:"))!=-1)
    {
      if (opt=='?')
        {
	  bad_switches=TRUE;
	  /*fprintf(stderr,"Invalid option: %c\n",optopt);*/
        }
      else
        {
          if (flag_set[optopt])
	    {
	      bad_switches=TRUE;
	      fprintf(stderr,"Switch -%c previously defined as %s\n", opt, flag_val[i]);
	    }
          else
	    {
	      flag_set[opt]=TRUE;
	      if (optarg) { strcpy(flag_val[opt], optarg); }
	    }
        }
    }
  for(i=optind; i<argc; i++)
    {
      bad_switches=TRUE;
      fprintf(stderr,"Invalid arg -- %s\n", argv[i]);
    }
  return(bad_switches);
}




void make_list_of_files_to_ignore(char*ignorefiles_fname, char*filelist_fname, char*cklist_fname)
{
  char command[MAX_STR_LEN];
  /* make a list of files which have changed on the disk since backup */
  log_to_screen("Making a list of files which have changed on hard disk since backup\n");
  sprintf(command,"%s/mondo-checksum %s %s / --verify | grep -v \"not found on filesystem\" | cut -f1 > %s",g_mondo_home,filelist_fname,cklist_fname,ignorefiles_fname);
  log_it(command);
  if (system(command)) {log_it("Failed to make list of files to ignore");}
  exclude_nonexistent_files(ignorefiles_fname);
}

















/* 
AmILive() { 
    EqualOrDie $# 0 "AmILive - wrong noof params" 
    local res 
#    echo -n "Checking to see if I'm running on a 'live' system..." 
    res=`WhereIsRootMounted` 
    if [ "$res" != "/dev/ram" ] && [ "$res" != "/dev/root" ] ; then 
#	echo "Done. I'm LIVE." 
        LogIt "I AM RUNNING LIVE. Fine."
	return 1 
    else 
        LogIt "I AM RUNNING ON A CD. Fine."
#	echo "Done. I'm on a CD." 
	return 0 
    fi 
} 
*/
 



  
void store_nfs_config(struct s_bkpinfo *bkpinfo)
{
  char outfile[MAX_STR_LEN], nfs_dev[MAX_STR_LEN], nfs_mount[MAX_STR_LEN],
    nfs_client_ipaddr[MAX_STR_LEN],
    nfs_server_ipaddr[MAX_STR_LEN], *p, tmp[MAX_STR_LEN], command[MAX_STR_LEN];
  FILE*fout;

  log_it("Storing NFS configuration");
  strcpy(tmp, bkpinfo->nfs_mount);
  p=strchr(tmp,':');
  if (!p) { fatal_error("NFS mount doesn't have a colon in it, e.g. 192.168.1.4:/home/nfs"); }
  *(p++)='\0';
  strcpy(nfs_server_ipaddr, tmp);
  strcpy(nfs_mount, p);
  sprintf(command,"ifconfig | tr '\n' '#' | sed s/##// | tr '#' ' ' | tr '' '\n' | head -n1 | cut -d' ' -f1");
  strcpy(nfs_dev, call_program_and_get_last_line_of_output(command));
  sprintf(command,"ifconfig | tr '\n' '#' | sed s/##// | tr '#' ' ' | tr '' '\\n' | head -n1 | tr -s '\t' ' ' | cut -d' ' -f7 | cut -d':' -f2");
  strcpy(nfs_client_ipaddr, call_program_and_get_last_line_of_output(command));
  sprintf(tmp, "nfs_client_ipaddr=%s; nfs_server_ipaddr=%s; nfs_mount=%s", nfs_client_ipaddr, nfs_server_ipaddr, nfs_mount);
  //  log_it(tmp);
  if (strlen(nfs_dev)<2) { fatal_error("Unable to find ethN (eth0, eth1, ...) adapter via NFS mount you specified."); }
  sprintf(outfile,"%s/start-nfs",bkpinfo->tmpdir);
  sprintf(tmp,"outfile = %s",outfile);
  log_it(tmp);
  if (!(fout=fopen(outfile,"w"))) { fatal_error("Cannot store NFS config"); }
  fprintf(fout, "ifconfig %s %s; # config client\n", nfs_dev, nfs_client_ipaddr);
  fprintf(fout, "# ping -c1 %s; # ping server\n", nfs_server_ipaddr);
  fprintf(fout, "# mount %s -t nfs /mnt/isodir\n", bkpinfo->nfs_mount);
  fprintf(fout, "exit 0\n");
  fclose(fout);
  chmod(outfile, 777);
  sprintf(tmp,"%s/NFS-DEV",bkpinfo->tmpdir);   write_one_liner_data_file(tmp, nfs_dev);

  sprintf(tmp,"%s/NFS-CLIENT-IPADDR",bkpinfo->tmpdir); write_one_liner_data_file(tmp, nfs_client_ipaddr);
  sprintf(tmp,"%s/NFS-SERVER-IPADDR",bkpinfo->tmpdir); write_one_liner_data_file(tmp, nfs_server_ipaddr);
  sprintf(tmp,"%s/NFS-SERVER-MOUNT",bkpinfo->tmpdir); write_one_liner_data_file(tmp, bkpinfo->nfs_mount);
  sprintf(tmp,"%s/NFS-SERVER-PATH",bkpinfo->tmpdir); write_one_liner_data_file(tmp, bkpinfo->nfs_remote_dir);
  log_it("Finished storing NFS configuration");
}




int find_cdrw_device(char*cdrw_device)
{
  char scratchfile[MAX_STR_LEN], comment[MAX_STR_LEN],
    devices_file[MAX_STR_LEN], tmp[MAX_STR_LEN];

  strcpy(tmp, call_program_and_get_last_line_of_output("cdrecord -scanbus | tr -s '\t' ' ' | grep \"[0-9]*,[0-9]*,[0-9]*\" | grep -v \"[0-9]*) \\*\" | grep CD | cut -d' ' -f2 | head -n1"));
  if (strlen(tmp)<2)
    { log_to_screen("Could not find CDRW device"); return 1; }
  else
    {
      strcpy(cdrw_device, tmp);
      sprintf(comment, "Found CDRW device - %s",cdrw_device);
      log_to_screen(comment);
    }      
  unlink(devices_file);
  return(0);


/*
  sprintf(scratchfile,"/tmp/mojo-jojo-tries-to-find-cdrw-device.%ld",random()%32768);
  sprintf(devices_file,"/tmp/mojo-jojo-found-these-devices.%ld",random()%32768);
  sprintf(command,"cdrecord -scanbus > %s 2> /dev/null", scratchfile);
  system(command);
  sprintf(command,"cat %s | grep CD | tr -s ' ' '\t' | \
grep \"[0-9]*,[0-9]*,[0-9]*\" | grep -v \"[0-9]*) [*]\" | \
grep -n \"\" | tr -s ':' '\t' | cut -f2 > %s", scratchfile, devices_file);
  system(command);
  if (count_lines_in_file(devices_file)==0)
    { log_to_screen("Unable to find any CDRW devices"); unlink(devices_file); return(1); }
  strcpy(cdrw_device, last_line_of_file(devices_file));
  if (count_lines_in_file(devices_file)>1)
    { log_to_screen("Multiple CDRW devices found. Assuming last one is the one."); }
  sprintf(tmp, "Found CDRW device - %s",cdrw_device);
  log_to_screen(tmp);
  unlink(devices_file);
  return(0);
*/
} 





void help_screen()
{
  fprintf(stderr,"Type 'man mondo-archive' for more information\n");
  exit(1);
} 







int whine_if_not_found(char*fname)
{
  char command[MAX_STR_LEN], errorstr[MAX_STR_LEN];

  sprintf(command,"which %s > /dev/null 2> /dev/null", fname);
  sprintf(errorstr,"Please install '%s'. I cannot find it on your system.", fname);
  if (system(command))
    {
      log_to_screen(errorstr);
      log_to_screen("There may be hyperlink at http://www.microwerks.net/~hugo/download.html which");
      log_to_screen("will take you to the relevant (missing) package.");
      return(1);
    }
  else
    {
      return(0);
    }
}



int some_basic_system_sanity_checks()
{
  char tmp[MAX_STR_LEN];
  int retval=0;

  mvaddstr_and_log_it(g_currentY,0,"Checking sanity of your Linux distribution");
  strcpy(tmp, call_program_and_get_last_line_of_output("free | grep Mem | head -n1 | tr -s ' ' '\t' | cut -f2"));
  if (atol(tmp)<35000) { retval++; log_to_screen("You must have at least 32MB of RAM to use Mondo."); }
  if (atol(tmp)<66000) { log_to_screen("WARNING! You have very little RAM. Please upgrade to 64MB or more."); }
  if (system("mke2fs -V > /dev/null 2> /dev/null"))
    { retval++; log_to_screen("Unable to find mke2fs in system path. Please use \"su -\", not \"su\" to become root. OK?"); }
  if (run_program_and_log_output("cat /proc/devices | grep ramdisk"))
    { retval++; log_to_screen("Please recompile your kernel to include ramdisk support."); }
  retval+=whine_if_not_found("mke2fs");
  retval+=whine_if_not_found("afio");
  retval+=whine_if_not_found("buffer");
  retval+=whine_if_not_found("mkisofs");
  retval+=whine_if_not_found("cdrecord");
  retval+=whine_if_not_found("bzip2");
  retval+=whine_if_not_found("awk");
  retval+=whine_if_not_found("md5sum");
  retval+=whine_if_not_found("strings");
  retval+=whine_if_not_found("mindi");
  strcpy(tmp, call_program_and_get_last_line_of_output("mount | grep \"cdr[om|w]\""));
  if (strcmp("",tmp))
    { retval++; log_to_screen("Warning - your CD-ROM drive is mounted."); }
  if (!does_file_exist("/etc/modules.conf"))
    { retval++; log_to_screen("Please find out what happened to /etc/modules.conf"); }
/* 
[ "`bzip2 -V | grep Version | tr -s '#' '|' | sed s/Version/#/ | cut -d'#' -f2 | sed s/,/' '/ | cut -d' ' -f2 | grep -x "0\.[8-9][0-9].*"`"
` ] && FatalError "Your bzip2 is woefully out of date (ver=$bzip_ver)" 
*/
  if (retval) { mvaddstr_and_log_it(g_currentY++,74,"Failed."); }
  else { mvaddstr_and_log_it(g_currentY++,74,"Done."); }
  return(retval);
}

 
 


char *where_is_root_mounted()
{
  static char tmp[MAX_STR_LEN];
  strcpy(tmp, call_program_and_get_last_line_of_output("mount | grep \" on / \" | cut -d' ' -f1 | sed s/[0-9]// | sed s/[0-9]//"));
  return(tmp);
} 




void wipe_temp_and_scratch_dirs(struct s_bkpinfo *bkpinfo)
{
  log_to_screen("wipe_temp_and_scratch_dirs(struct s_bkpinfo *bkpinfo) hasn't been written yet");
}



char *find_home_of_exe(char *fname)
{
  static char output[MAX_STR_LEN];
  char incoming[MAX_STR_LEN], command[MAX_STR_LEN];

  incoming[0]='\0';
  sprintf(command,"which %s", fname);
  strcpy(incoming, call_program_and_get_last_line_of_output(command));
  if (incoming[0]!='\0')
    {
      sprintf(command,"file %s | awk '{print $NF;}'", incoming);
      strcpy(incoming, call_program_and_get_last_line_of_output(command));
    }
  if (incoming[0]!='\0')
    {
      sprintf(command,"dirname %s", incoming);
      strcpy(incoming, call_program_and_get_last_line_of_output(command));
    }
  strcpy(output, incoming);
  return(output);
}




void estimate_noof_media_required(struct s_bkpinfo *bkpinfo)
{
  char tmp[MAX_STR_LEN];
  long scratchL;

  log_it("Estimating number of media required...");
  scratchL = g_noof_sets * bkpinfo->optimal_set_size + size_of_all_biggiefiles_K(bkpinfo);
  scratchL = (scratchL / 1024) / bkpinfo->media_size;
  scratchL ++;
  if (bkpinfo->use_lzo)
    { scratchL = (scratchL*2) / 3; }
  else 
    { scratchL = scratchL / 2; }
  if (!scratchL) { scratchL++; }
  if (scratchL<=1)
    { sprintf(tmp, "Your backup will probably occupy a single CD/tape/ISO. Maybe two."); }
  else
    { sprintf(tmp, "Your backup will probably occupy %s media.", number_to_text((int)(scratchL+1))); }
  log_to_screen(tmp);
}



/* -----------------------------main-------------------------- */





int main(int argc, char*argv[])
{
  struct s_bkpinfo bkpinfo_record, *bkpinfo;
  int res=0,retval=0;
  long diffs=0;
  char tmp[MAX_STR_LEN], say_at_end[MAX_STR_LEN];

  if (getuid()!=0)
    { fprintf(stderr,"Please run as root.\n"); exit(127); }
  srandom(time(NULL));
  unlink(MONDO_LOGFILE);
  unlink("/tmp/changed.files");
  say_at_end[0]='\0';
//  strcpy(g_mondo_home, find_home_of_exe("mondo-archive"));
  printf("Initializing...\n");
  strcpy(g_mondo_home, call_program_and_get_last_line_of_output("find /usr/{local,share} -name mondo -type d -maxdepth 2 | grep -v \"1\\.[2-9]x\""));
  if (g_mondo_home[0]=='\0')
    {
      printf("Still initializing :-) ...\n");
      strcpy(g_mondo_home, call_program_and_get_last_line_of_output("find /usr -type d -name mondo -maxdepth 3 | grep -v \"1\\.[2-9]x\""));
    }
  if (g_mondo_home[0]=='\0')
    {
      fprintf(stderr,"Cannot find Mondo's homedir. Please notify the author.\n");
      exit(1);
    }
  sprintf(tmp,"Mondo Archive v%s --- http://www.microwerks.net/~hugo", MONDO_VERSION);
  log_it(tmp);
  sprintf(tmp,"g_mondo_home = %s", g_mondo_home);
  /*  log_it(tmp); */
  bkpinfo = &bkpinfo_record;
  reset_bkpinfo(bkpinfo);
  bkpinfo->postnuke_tarball[0]=g_startdir[0]=bkpinfo->nfs_mount[0] = '\0';
  res=handle_incoming_parameters(argc, argv, bkpinfo);
  if (res)
    {
      fprintf(stderr,"Bad parameters. Type 'man mondoarchive' to se manual. Mondo will now exit.\n");
      exit(res);
    }
  printf("See %s for details of backup run.\n", MONDO_LOGFILE);
  setup_newt_stuff();
  res=some_basic_system_sanity_checks(bkpinfo);
  retval+=res;
  if (res) { fatal_error("Your distribution did not pass Mondo's sanity test."); }
  if (bkpinfo->backup_data)
    {
      res=prepare_filelist(bkpinfo); /* generate scratchdir/filelist.full */
      if (retval+=res) { fatal_error("Failed to generate filelist catalog"); }
      call_filelist_chopper(bkpinfo);
      copy_mondo_and_mindi_stuff_to_scratchdir(bkpinfo);
      res=call_mindi_to_supply_boot_disks(bkpinfo);
      if (retval+=res) { fatal_error("Failed to generate boot+data disks"); }
      if (bkpinfo->include_paths[0]=='\0') { fatal_error("Why no backup path?"); }
      retval+=do_that_initial_stuff_dude(bkpinfo);
      estimate_noof_media_required(bkpinfo);
      retval+=make_those_afios_dude(bkpinfo);
      retval+=make_those_slices_dude(bkpinfo);
      retval+=do_that_final_stuff_dude(bkpinfo);
      log_it("Dude, those archives have been made.");
      if (retval) { strcat(say_at_end, "Data archived. Please check the logs, just as a precaution. "); }
      else { strcat(say_at_end, "Data archived OK. "); }
    }
  if (bkpinfo->verify_data)
    {
      if (bkpinfo->using_tape || bkpinfo->using_cdstream)
        {
          chdir("/");
          mvaddstr_and_log_it(g_currentY,0,"Verifying archives against live filesystem");
          if (bkpinfo->using_cdstream) { strcpy(bkpinfo->media_device, "/dev/cdrom"); }
          verify_tape_backups(bkpinfo);
          mvaddstr_and_log_it(g_currentY++,74,"Done.");
        }
      else
        {
          chdir("/");
          for(g_current_media_number = 1; g_current_media_number<99 && bkpinfo->verify_data; g_current_media_number++)
            {
              res=verify_cd_image(bkpinfo);
              retval+=res;
              if (res)
                {
                  sprintf(tmp,"Warnings/errors were reported while checking CD #%d", g_current_media_number);
                  log_to_screen(tmp);
                }
            }
          sprintf(tmp,"cat %s | grep \"afio: \" | cut -d'\"' -f2 | sort -u | awk '{print \"/\"$0;};' | tr -s '/' '/' | grep -vx \"/afio:.*\" > /tmp/changed.files", MONDO_LOGFILE);
          if (system(tmp)) { log_it("Warning - unable to check logfile to derive list of changed files"); }
        }
      diffs=count_lines_in_file("/tmp/changed.files");
      if (diffs>0)
        {
          sprintf(tmp,"%ld files differed from live filesystem; type 'less /tmp/changed.files' to see. ",diffs);
          log_it(tmp);
          sprintf(tmp,"Data verified. %ld files differ. ", diffs);
          strcat(say_at_end, tmp);
	  retval++;
        }
      else
        {
          strcat(say_at_end,"All data verified OK. ");
        }
    }
  if (bkpinfo->backup_data)
    {
      mvaddstr_and_log_it(g_currentY,0,"Writing boot+data floppy images to disk");
      if (g_skip_floppies)
	{ 
	  mvaddstr_and_log_it(g_currentY++,74,"Skip'd"); 
	}
      else if (!does_file_exist("/root/images/mindi/mindi-boot.1722.img")) 
	{
	  mvaddstr_and_log_it(g_currentY++,74,"No Imgs"); 
	  if (does_file_exist("/root/images/mindi/mindi.iso"))
	    {
	      popup_and_OK("Boot+data floppy creation failed. However, FYI, you may burn /root/images/mindi/mindi.iso to a CD and boot from that instead if you wish.");
	    }
	}
      else
	{
	  offer_to_write_floppies(bkpinfo,"/root/images/mindi"); mvaddstr_and_log_it(g_currentY++,74,"Done."); 
	}
    }
  if (!res)
    { mvaddstr_and_log_it(g_currentY++,0,"Backup and/or verify ran to completion. Everything appears to be fine."); }
  else
    { mvaddstr_and_log_it(g_currentY++,0,"Backup and/or verify ran to completion. However, errors did occur."); }
/*  sleep(3); */
  sprintf(tmp,"rm -Rf %s",bkpinfo->scratchdir); system(tmp);
  sprintf(tmp,"rm -Rf %s",bkpinfo->tmpdir); system(tmp);
  if (does_file_exist("/root/images/mindi/mindi.iso")) { log_to_screen("/root/images/mindi/mindi.iso, a boot/utility CD, is available if you want it"); }
  if (length_of_file("/tmp/changed.files") > 2)
    { log_to_screen("Type 'less /tmp/changed.files' to see which files don't match the archives"); }
  else
    { unlink("/tmp/changed.files"); }
  log_to_screen(say_at_end);
  sprintf(tmp,"rm -Rf %s %s", bkpinfo->tmpdir, bkpinfo->scratchdir);
  system(tmp);
  if (!g_text_mode) {popup_and_OK("Mondo Archive has finished its run. Please press ENTER to return to the shell prompt.");newtFinished();}
  exit(retval);


/* [ "$MOUNT_AND_UNMOUNT_NFS" ] && umount $NFS_SERVER_MOUNT
LogIt "Mondo is exiting (status = $mondo_exit_value)"
[ "`echo "$TMP" | grep "tmp.mondo.$$"`" != "" ] && rm -Rf "$TMP"
[ "`echo "$scratchdir" | grep "mondo.scratch"`" != "" ] && rm -Rf "$scratchdir"
if [ "$mondo_exit_value" -ne "0" ] || [ "$DEBUGGING" = "yes" ] ; then
    tail $LOGFILE -n5
    cd /tmp
    mkdir -p mondo.err
    for i in /etc/fstab /etc/raidtab /etc/lilo.conf /var/log/mindi.log /var/log/mondo-archive.log ; do
	[ -e "$i" ] && cp -f $i mondo.err/
    done
    tar -c mondo.err | gzip -9 > mondo.err.$$.tgz
    rm -Rf mondo.err
fi
*/

}








