"use strict";

var helpers = require("../../helpers/helpers");

exports["Europe/Moscow"] = {

	"guess:by:offset" : helpers.makeTestGuess("Europe/Moscow", { offset: true }),

	"guess:by:abbr" : helpers.makeTestGuess("Europe/Moscow", { abbr: true }),

	"1916" : helpers.makeTestYear("Europe/Moscow", [
		["1916-07-02T21:29:42+00:00", "23:59:59", "MMT", -9017 / 60],
		["1916-07-02T21:29:43+00:00", "00:01:02", "MMT", -9079 / 60]
	]),

	"1917" : helpers.makeTestYear("Europe/Moscow", [
		["1917-07-01T20:28:40+00:00", "22:59:59", "MMT", -9079 / 60],
		["1917-07-01T20:28:41+00:00", "00:00:00", "MST", -12679 / 60],
		["1917-12-27T20:28:40+00:00", "23:59:59", "MST", -12679 / 60],
		["1917-12-27T20:28:41+00:00", "23:00:00", "MMT", -9079 / 60]
	]),

	"1918" : helpers.makeTestYear("Europe/Moscow", [
		["1918-05-31T19:28:40+00:00", "21:59:59", "MMT", -9079 / 60],
		["1918-05-31T19:28:41+00:00", "00:00:00", "MDST", -16279 / 60],
		["1918-09-15T20:28:40+00:00", "00:59:59", "MDST", -16279 / 60],
		["1918-09-15T20:28:41+00:00", "00:00:00", "MST", -12679 / 60]
	]),

	"1919" : helpers.makeTestYear("Europe/Moscow", [
		["1919-05-31T19:28:40+00:00", "22:59:59", "MST", -12679 / 60],
		["1919-05-31T19:28:41+00:00", "00:00:00", "MDST", -16279 / 60],
		["1919-06-30T23:59:59+00:00", "04:31:18", "MDST", -16279 / 60],
		["1919-07-01T00:00:00+00:00", "04:00:00", "MSD", -240],
		["1919-08-15T19:59:59+00:00", "23:59:59", "MSD", -240],
		["1919-08-15T20:00:00+00:00", "23:00:00", "MSK", -180]
	]),

	"1921" : helpers.makeTestYear("Europe/Moscow", [
		["1921-02-14T19:59:59+00:00", "22:59:59", "MSK", -180],
		["1921-02-14T20:00:00+00:00", "00:00:00", "MSD", -240],
		["1921-03-20T18:59:59+00:00", "22:59:59", "MSD", -240],
		["1921-03-20T19:00:00+00:00", "00:00:00", "+05", -300],
		["1921-08-31T18:59:59+00:00", "23:59:59", "+05", -300],
		["1921-08-31T19:00:00+00:00", "23:00:00", "MSD", -240],
		["1921-09-30T19:59:59+00:00", "23:59:59", "MSD", -240],
		["1921-09-30T20:00:00+00:00", "23:00:00", "MSK", -180]
	]),

	"1922" : helpers.makeTestYear("Europe/Moscow", [
		["1922-09-30T20:59:59+00:00", "23:59:59", "MSK", -180],
		["1922-09-30T21:00:00+00:00", "23:00:00", "EET", -120]
	]),

	"1930" : helpers.makeTestYear("Europe/Moscow", [
		["1930-06-20T21:59:59+00:00", "23:59:59", "EET", -120],
		["1930-06-20T22:00:00+00:00", "01:00:00", "MSK", -180]
	]),

	"1981" : helpers.makeTestYear("Europe/Moscow", [
		["1981-03-31T20:59:59+00:00", "23:59:59", "MSK", -180],
		["1981-03-31T21:00:00+00:00", "01:00:00", "MSD", -240],
		["1981-09-30T19:59:59+00:00", "23:59:59", "MSD", -240],
		["1981-09-30T20:00:00+00:00", "23:00:00", "MSK", -180]
	]),

	"1982" : helpers.makeTestYear("Europe/Moscow", [
		["1982-03-31T20:59:59+00:00", "23:59:59", "MSK", -180],
		["1982-03-31T21:00:00+00:00", "01:00:00", "MSD", -240],
		["1982-09-30T19:59:59+00:00", "23:59:59", "MSD", -240],
		["1982-09-30T20:00:00+00:00", "23:00:00", "MSK", -180]
	]),

	"1983" : helpers.makeTestYear("Europe/Moscow", [
		["1983-03-31T20:59:59+00:00", "23:59:59", "MSK", -180],
		["1983-03-31T21:00:00+00:00", "01:00:00", "MSD", -240],
		["1983-09-30T19:59:59+00:00", "23:59:59", "MSD", -240],
		["1983-09-30T20:00:00+00:00", "23:00:00", "MSK", -180]
	]),

	"1984" : helpers.makeTestYear("Europe/Moscow", [
		["1984-03-31T20:59:59+00:00", "23:59:59", "MSK", -180],
		["1984-03-31T21:00:00+00:00", "01:00:00", "MSD", -240],
		["1984-09-29T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1984-09-29T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1985" : helpers.makeTestYear("Europe/Moscow", [
		["1985-03-30T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1985-03-30T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1985-09-28T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1985-09-28T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1986" : helpers.makeTestYear("Europe/Moscow", [
		["1986-03-29T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1986-03-29T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1986-09-27T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1986-09-27T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1987" : helpers.makeTestYear("Europe/Moscow", [
		["1987-03-28T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1987-03-28T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1987-09-26T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1987-09-26T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1988" : helpers.makeTestYear("Europe/Moscow", [
		["1988-03-26T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1988-03-26T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1988-09-24T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1988-09-24T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1989" : helpers.makeTestYear("Europe/Moscow", [
		["1989-03-25T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1989-03-25T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1989-09-23T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1989-09-23T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1990" : helpers.makeTestYear("Europe/Moscow", [
		["1990-03-24T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1990-03-24T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1990-09-29T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1990-09-29T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1991" : helpers.makeTestYear("Europe/Moscow", [
		["1991-03-30T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1991-03-30T23:00:00+00:00", "02:00:00", "EEST", -180],
		["1991-09-28T23:59:59+00:00", "02:59:59", "EEST", -180],
		["1991-09-29T00:00:00+00:00", "02:00:00", "EET", -120]
	]),

	"1992" : helpers.makeTestYear("Europe/Moscow", [
		["1992-01-18T23:59:59+00:00", "01:59:59", "EET", -120],
		["1992-01-19T00:00:00+00:00", "03:00:00", "MSK", -180],
		["1992-03-28T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1992-03-28T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1992-09-26T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1992-09-26T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1993" : helpers.makeTestYear("Europe/Moscow", [
		["1993-03-27T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1993-03-27T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1993-09-25T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1993-09-25T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1994" : helpers.makeTestYear("Europe/Moscow", [
		["1994-03-26T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1994-03-26T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1994-09-24T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1994-09-24T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1995" : helpers.makeTestYear("Europe/Moscow", [
		["1995-03-25T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1995-03-25T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1995-09-23T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1995-09-23T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1996" : helpers.makeTestYear("Europe/Moscow", [
		["1996-03-30T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1996-03-30T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1996-10-26T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1996-10-26T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1997" : helpers.makeTestYear("Europe/Moscow", [
		["1997-03-29T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1997-03-29T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1997-10-25T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1997-10-25T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1998" : helpers.makeTestYear("Europe/Moscow", [
		["1998-03-28T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1998-03-28T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1998-10-24T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1998-10-24T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"1999" : helpers.makeTestYear("Europe/Moscow", [
		["1999-03-27T22:59:59+00:00", "01:59:59", "MSK", -180],
		["1999-03-27T23:00:00+00:00", "03:00:00", "MSD", -240],
		["1999-10-30T22:59:59+00:00", "02:59:59", "MSD", -240],
		["1999-10-30T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2000" : helpers.makeTestYear("Europe/Moscow", [
		["2000-03-25T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2000-03-25T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2000-10-28T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2000-10-28T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2001" : helpers.makeTestYear("Europe/Moscow", [
		["2001-03-24T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2001-03-24T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2001-10-27T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2001-10-27T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2002" : helpers.makeTestYear("Europe/Moscow", [
		["2002-03-30T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2002-03-30T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2002-10-26T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2002-10-26T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2003" : helpers.makeTestYear("Europe/Moscow", [
		["2003-03-29T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2003-03-29T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2003-10-25T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2003-10-25T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2004" : helpers.makeTestYear("Europe/Moscow", [
		["2004-03-27T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2004-03-27T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2004-10-30T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2004-10-30T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2005" : helpers.makeTestYear("Europe/Moscow", [
		["2005-03-26T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2005-03-26T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2005-10-29T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2005-10-29T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2006" : helpers.makeTestYear("Europe/Moscow", [
		["2006-03-25T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2006-03-25T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2006-10-28T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2006-10-28T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2007" : helpers.makeTestYear("Europe/Moscow", [
		["2007-03-24T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2007-03-24T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2007-10-27T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2007-10-27T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2008" : helpers.makeTestYear("Europe/Moscow", [
		["2008-03-29T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2008-03-29T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2008-10-25T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2008-10-25T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2009" : helpers.makeTestYear("Europe/Moscow", [
		["2009-03-28T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2009-03-28T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2009-10-24T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2009-10-24T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2010" : helpers.makeTestYear("Europe/Moscow", [
		["2010-03-27T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2010-03-27T23:00:00+00:00", "03:00:00", "MSD", -240],
		["2010-10-30T22:59:59+00:00", "02:59:59", "MSD", -240],
		["2010-10-30T23:00:00+00:00", "02:00:00", "MSK", -180]
	]),

	"2011" : helpers.makeTestYear("Europe/Moscow", [
		["2011-03-26T22:59:59+00:00", "01:59:59", "MSK", -180],
		["2011-03-26T23:00:00+00:00", "03:00:00", "MSK", -240]
	])
};