#!/usr/bin/env python
"""
    Start script for the standalone Wiki server.
    Use this for small, private and local wikis *ONLY*,
    like when using on your local PC or notebook.

    @copyright: 2004-2005 Thomas Waldmann, Nir Soffer
    @license: GNU GPL, see COPYING for details.
"""

# System path configuration

import sys

# Path of the directory where wikiconfig.py is located.
# YOU NEED TO CHANGE THIS TO MATCH YOUR SETUP.
sys.path.insert(0, '/path/to/wikiconfig')

# Path to MoinMoin package, needed if you installed with --prefix=PREFIX
# or if you did not use setup.py.
## sys.path.insert(0, 'PREFIX/lib/python2.3/site-packages')

# Path of the directory where farmconfig is located (if different).
## sys.path.insert(0, '/path/to/farmconfig')


from MoinMoin.server.standalone import StandaloneConfig, run


class Config(StandaloneConfig):

    # Path to moin shared files (default '/usr/share/moin/wiki/htdocs')
    docs = '/usr/share/moin/htdocs'

    # The server will run with as this user and group (default 'www-data')
    user = 'www-data'
    group = 'www-data'

    # Port (default 8000)
    # To serve privileged port under 1024 you will have to run as root.
    port = 8000

    # Interface (default 'localhost')
    # The default will listen only to localhost.
    # '' - will listen to any interface
    interface = 'localhost'

    # Log (default commented)
    # Log is written to stderr or to a file you specify here.
    ## logPath = 'moin.log'
    
    # Memory profile (default commented)
    # Useful only if you are a developer or interested in moin memory usage
    # A memory profile named 'moin_standalone--2004-09-27--01-24.log' is
    # created each time you start the server.
    ## from MoinMoin.util.profile import Profiler
    ## memoryProfile = Profiler('moin_standalone',
    ##                          requestsPerSample=100,
    ##                          collect=0)

    # Hotshot profile (default commented)
    ## import hotshot
    ## hotshotProfile = hotshot.Profile("moin.prof")


# Run moin moin server:
run(Config)

