/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.kneschke.de/projekte/modlogan
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: template.h,v 1.4 2001/12/24 16:50:28 ostborn Exp $
*/
#ifndef _TEMPLATE_H_
#define _TEMPLATE_H_

#include <stdio.h>

#include "mconfig.h"

typedef struct {
	FILE *f;
	
	char *buffer;
	int buf_inc;
	int buf_len;
} tmpl_file;

typedef struct {
	const char *string;
	int str_pos;
	
	char *buffer;
	int buf_len;
} tmpl_string;

typedef struct {
	char *name;
	char *value;
	char *defvalue;
} tmpl_key;

typedef struct {
	char *name;
	char *value;
} tmpl_block;

typedef struct {
	/* keys */
	tmpl_key **tmpl_keys;
	int tmpl_keys_pos;
	int tmpl_keys_size;
	
	/* blocks */
	tmpl_block **tmpl_blocks;
	int tmpl_blocks_pos;
	int tmpl_blocks_size;
	
	char *tmpl_current_block;
	
	int debug_level;
} tmpl_main;

/* Con/Destructor */

tmpl_main *tmpl_init();
int tmpl_free(tmpl_main *tmpl);
int tmpl_free_keys(tmpl_main *tmpl);
int tmpl_free_blocks(tmpl_main *tmpl);

int tmpl_load_template(tmpl_main *tmpl, const char *filename);
int tmpl_load_string(tmpl_main *tmpl, const char *string);
int tmpl_parse_current_block(tmpl_main *tmpl);
char * tmpl_replace_block(tmpl_main *tmpl, const char *block);
char * tmpl_replace(tmpl_main *tmpl);

int tmpl_insert_key(tmpl_main *tmpl, const char *s, const char *defval);
int tmpl_current_block_append(tmpl_main *tmpl, const char *s);
int tmpl_set_current_block(tmpl_main *tmpl, const char *key);
int tmpl_clear_block(tmpl_main *tmpl, const char *key);

int tmpl_set_var(tmpl_main *tmpl, const char *key, const char *value);
int tmpl_append_var(tmpl_main *tmpl, const char *key, const char *value);
int tmpl_clear_var(tmpl_main *tmpl, const char *key);

#endif
