package org.codehaus.modello.plugin;

/*
 * Copyright (c) 2004, Codehaus.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

/**
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @version $Id: AbstractPluginManager.java 508 2005-10-25 00:37:08Z brett $
 */
public abstract class AbstractPluginManager
    extends AbstractLogEnabled
    implements Initializable
{
    private Map plugins;

    public void initialize()
    {
        if ( plugins == null )
        {
            plugins = Collections.EMPTY_MAP;
        }
    }

    public Map getPlugins()
    {
        return plugins;
    }

    public Iterator getPluginsIterator()
    {
        return plugins.values().iterator();
    }

    public Object getPlugin( String name )
    {
        Object plugin = plugins.get( name );

        if ( plugin == null )
        {
            throw new ModelloRuntimeException( "No such plugin: " + name );
        }

        return plugin;
    }

    public boolean hasPlugin( String name )
    {
        return plugins.containsKey( name );
    }
}
