/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>

#include "udm_common.h"
#include "udm_word.h"
#include "udm_doc.h"
#include "udm_utils.h"
#include "udm_result.h"
#include "udm_parsehtml.h"


UDM_RESULT *UdmResultInit(UDM_RESULT *Res){
	if(!Res){
		Res=(UDM_RESULT*)UdmMalloc(sizeof(UDM_RESULT));
		bzero((void*)Res, sizeof(UDM_RESULT));
		Res->freeme=1;
	}else{
		bzero((void*)Res, sizeof(UDM_RESULT));
	}
	Res->items = (UDM_STACK_ITEM*)UdmMalloc(UDM_MAXSTACK * sizeof(UDM_STACK_ITEM));
	Res->mitems = UDM_MAXSTACK;
	return Res;
}

void __UDMCALL UdmResultFree(UDM_RESULT * Res){
	size_t i;
	
	if(!Res)return;
	UDM_FREE(Res->items);
	UDM_FREE(Res->PerSite);
	UDM_FREE(Res->CoordList.Coords);
	for (i = 0; i < Res->CoordList.ncoords; i++)
	{
	  UDM_FREE(Res->CoordList.Data[i].url);
          UDM_FREE(Res->CoordList.Data[i].section);
	}
	UDM_FREE(Res->CoordList.Data);
	UdmWideWordListFree(&Res->WWList);
	if(Res->Doc){
		for(i=0;i<Res->num_rows;i++){
			UdmDocFree(&Res->Doc[i]);
		}
		UDM_FREE(Res->Doc);
	}
	if(Res->freeme){
		UDM_FREE(Res);
	}else{
		bzero((void*)Res, sizeof(*Res));
	}
	return;
}


int UdmResultFromTextBuf(UDM_RESULT *R,char *buf){
	size_t	num_rows=0;
	char	*tok,*lt;
	
	for(tok = udm_strtok_r(buf,"\r\n",&lt); tok; tok = udm_strtok_r(NULL,"\r\n",&lt)) {
		if(!memcmp(tok,"<DOC",4)){
			UDM_DOCUMENT	D;
			UdmDocInit(&D);
			UdmDocFromTextBuf(&D,tok);
			R->Doc=(UDM_DOCUMENT*)UdmRealloc(R->Doc,sizeof(UDM_DOCUMENT)*(R->num_rows+1));
			R->Doc[R->num_rows]=D;
			R->num_rows++;
		}else
		if(!memcmp(tok,"<WRD",4)){
			size_t		i;
			UDM_HTMLTOK	tag;
			const char	*htok,*last;
			UDM_WIDEWORD	*W;
			
			R->WWList.Word=(UDM_WIDEWORD*)UdmRealloc(R->WWList.Word,sizeof(R->WWList.Word[0])*(R->WWList.nwords+1));
			W=&R->WWList.Word[R->WWList.nwords];
			bzero((void*)W, sizeof(*W));
			
			UdmHTMLTOKInit(&tag);
			htok=UdmHTMLToken(tok,&last,&tag);
			
			for(i=0;i<tag.ntoks;i++){
				size_t  nlen=tag.toks[i].nlen;
				size_t  vlen=tag.toks[i].vlen;
				char	*name = UdmStrndup(tag.toks[i].name,nlen);
				char	*data = UdmStrndup(tag.toks[i].val,vlen);
				if(!strcmp(name,"word")){
					W->word = (char*)UdmStrdup(data);
				}else
				if(!strcmp(name,"order")){
					W->order=atoi(data);
				}else
				if(!strcmp(name,"count")){
					W->count=atoi(data);
				}else
				if(!strcmp(name,"origin")){
					W->origin=atoi(data);
				}
				UDM_FREE(name);
				UDM_FREE(data);
			}
			R->WWList.nwords++;
		}else{
			size_t		i;
			UDM_HTMLTOK	tag;
			const char	*htok,*last;
			
			UdmHTMLTOKInit(&tag);
			htok=UdmHTMLToken(tok,&last,&tag);
			
			for(i=0;i<tag.ntoks;i++){
				size_t  nlen=tag.toks[i].nlen;
				size_t  vlen=tag.toks[i].vlen;
				char	*name = UdmStrndup(tag.toks[i].name,nlen);
				char	*data = UdmStrndup(tag.toks[i].val,vlen);
				if(!strcmp(name,"first")){
					R->first=atoi(data);
				}else
				if(!strcmp(name,"last")){
					R->last=atoi(data);
				}else
				if(!strcmp(name,"count")){
					R->total_found=atoi(data);
				}else
				if(!strcmp(name,"rows")){
					num_rows=atoi(data);
				}
				UDM_FREE(name);
				UDM_FREE(data);
			}
		}
	}
	return UDM_OK;
}


int UdmResultToTextBuf(UDM_RESULT *R,char *buf,size_t len){
	char	*end=buf;
	size_t	i;
	
	end+=sprintf(end,"<RES\ttotal=\"%d\"\trows=\"%d\"\tfirst=\"%d\"\tlast=\"%d\">\n", R->total_found, R->num_rows, R->first, R->last);
	
	for (i = 0; i< R->WWList.nwords; i++) {
		UDM_WIDEWORD	*W=&R->WWList.Word[i];
		end+=sprintf(end,"<WRD\tword=\"%s\"\torder=\"%d\"\tcount=\"%d\"\torigin=\"%d\">\n",
			W->word,W->order,W->count,W->origin);
	}
	
	for(i=0;i<R->num_rows;i++){
		UDM_DOCUMENT	*D=&R->Doc[i];
		size_t		nsec;
		
		for(nsec=0;nsec<D->Sections.nvars;nsec++)
			D->Sections.Var[nsec].section=1;
		
		UdmDocToTextBuf(D,end,len-1);
		end+=strlen(end);
		*end='\n';
		end++;
	}
	return UDM_OK;
}
