      DOUBLE PRECISION FUNCTION XMNUSR(XX,YY,NP,DPAR,NUSER,WFERR)
C
C     Breit-Wigner function convoluted with a Gaussian
C
C     Input arguments:
C       XX     is first variable
C       YY     is the second variable
C       NP     is number of parameters
C       DPAR   are the parameters in DOUBLE PRECISION
C       NUSER  is the user function number
C       WFERR  is the error on the function (0 in most cases)
C
      implicit none
C
      REAL          XMINNM,XMAXNM,XBINNM,YMINNM,YMAXNM,YBINNM
      COMMON/MNUSR/ XMINNM,XMAXNM,XBINNM,YMINNM,YMAXNM,YBINNM
      LOGICAL QDEBUG
      INTEGER NDEBUG
      COMMON/MNDBG/ QDEBUG,NDEBUG
C     Mn_Fit registers - Do not overwrite this common block
      REAL REGIS
      COMMON/MNREGI/REGIS(0:500)
C
      REAL XX,YY
      INTEGER NP,NUSER
      DOUBLE PRECISION DPAR(20),WFERR,WXX,WYY,dxbin,wxpar(3)
C     Z2PI  =  2.0 * PI
      double precision z2pi
      integer nfun,nstep,npar,npar2,i
      double precision rsigma,wxstep,wtmp
      double precision wsigma,wnorm,wxxlo,wxxhi,WFVAL(0:100),wxxx
      real xxx
C
      double precision dsimps, xmnclc
C
      DATA Z2PI   /  6.283185307179586D0 /
C
      WXX = DBLE(XX)
      WYY = DBLE(YY)
      dxbin = dble(xbinnm)
*
*     The parameters
*     1 = NORM
*     2 = MEAN
*     3 = BW width
*     4 = Gauss width
*
*     Breit-Wigner is Mn_Fit function 9
*
      nfun  = 9
      npar  = 3
      npar2 = 0
      wxpar(1) = dpar(1)
      wxpar(2) = dpar(2)
      wxpar(3) = dpar(3)
      wsigma   = dpar(4)
*
*     Check that parameters are reasonable
*
      if (dpar(3).eq.0.0d0) then
         xmnusr = 0.0d0
         return
      endif
*
*     Parameters needed for convolution
*     100 steps and 3 sigma
*
      NSTEP  = 100
      RSIGMA = 3.0D0
      WXXLO   = WXX - RSIGMA*WSIGMA
      WXXHI   = WXX + RSIGMA*WSIGMA
      WXSTEP  = (WXXHI - WXXLO) / DBLE(NSTEP)
C
C     Convolute Breit Wigner with a Gaussian
C
      if(wsigma.eq.0.0d0) then
         xmnusr = XMNCLC(NFUN,WXPAR(1),NPAR,NPAR2,XX,YY)
      else
        WNORM  = 1.0D0 / (DSQRT(Z2PI) * WSIGMA)
         WXXX  = WXXLO - WXSTEP
         DO I=0,NSTEP
            WXXX = WXXX + WXSTEP
            XXX  = SNGL(WXXX)
            WTMP = XMNCLC(NFUN,WXPAR(1),NPAR,NPAR2,XXX,YY)
            WFVAL(I) = WTMP *
     +           WNORM * DEXP(-0.5D0*((WXXX-WXX)/WSIGMA)**2)
         ENDDO
         xmnusr = DSIMPS(WFVAL(0),WXXLO,WXXHI,NSTEP)
      endif
C
      END
