      SUBROUTINE M_HCMP(NMODE,IDA1,IDB1,IDA2,IDB2,IERR)
C
C     Compares the bins and limits of 2 plots to see if they are compatible
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnlun.inc"
C
      INTEGER IDBIN1(MDIMMX),IDBIN2(MDIMMX)
      REAL ADLO1(MDIMMX),ADHI1(MDIMMX),ADLO2(MDIMMX),ADHI2(MDIMMX)
C
      IERR = 1
C
      CALL MN_HGT(IDA1,IDB1,NH1)
      IF(NH1.LE.0) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4,'' does not exist'')'
     +     ,IOSTAT=IOERR) IDA1,IDB1
          CALL MN_ERR('M_HCMP',TXTERR)
          GOTO 9000
      ENDIF
      NPTRH1 = NPTRH
      NPTRD1 = NPTRD
      NDIM1  = NDIM
      NWPPT1 = NWPPT
      NPNT1  = NPNT
      NBPPT1 = NBPPT
      NSDAT1 = NSDATE
      NSTIM1 = NSTIME
      NTMOD1 = NTMODE
      EDENT1 = EDENT
      EDLO1  = EDLO
      EDHI1  = EDHI
      CALL UCOPY_i(IDBIN,IDBIN1,IABS(NDIM))
      CALL UCOPY_r(ADLO,ADLO1,IABS(NDIM))
      CALL UCOPY_r(ADHI,ADHI1,IABS(NDIM))
C
      CALL MN_HGT(IDA2,IDB2,NH2)
      IF(NH2.LE.0) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4,'' does not exist'')'
     +     ,IOSTAT=IOERR) IDA2,IDB2
          CALL MN_ERR('M_HCMP',TXTERR)
          GOTO 9000
      ENDIF
      NPTRH2 = NPTRH
      NPTRD2 = NPTRD
      NDIM2  = NDIM
      NWPPT2 = NWPPT
      NPNT2  = NPNT
      NBPPT2 = NBPPT
      NSDAT2 = NSDATE
      NSTIM2 = NSTIME
      NTMOD2 = NTMODE
      EDENT2 = EDENT
      EDLO2  = EDLO
      EDHI2  = EDHI
      CALL UCOPY_i(IDBIN,IDBIN2,IABS(NDIM))
      CALL UCOPY_r(ADLO,ADLO2,IABS(NDIM))
      CALL UCOPY_r(ADHI,ADHI2,IABS(NDIM))
C
      IF(IABS(NDIM1).NE.IABS(NDIM2)) THEN
          WRITE(TXTERR,'('' Histograms'',I7,I4,'';'',I7,I4
     1     ,'' do not have the same dimensions'',2I4)')
     2     IDA1,IDB1,IDA2,IDB2,NDIM1,NDIM2
          CALL MN_ERR('M_HCMP',TXTERR)
          GOTO 9000
      ENDIF
C
      DO 2100 II=1,IABS(NDIM1)
          IF(NDIM1.GT.1) THEN
              NBIN1 = IDBIN1(II)
          ELSE
              NBIN1 = NPNT1
          ENDIF
          IF(NDIM1.GT.1) THEN
              NBIN2 = IDBIN2(II)
          ELSE
              NBIN2 = NPNT2
          ENDIF
          IF(NMODE.EQ.0) THEN
              IF(NBIN1.NE.NBIN2) THEN
                  WRITE(TXTERR,'(''Var.'',I3,''  Number of''
     1             ,'' bins is not identical'')') II
                  CALL MN_ERR('M_HCMP',TXTERR)
                  GOTO 9000
              ENDIF
          ENDIF
C
          IF(NMODE.EQ.0) THEN
              IF((ADHI1(II)-ADLO1(II)).LE.0.0 .OR.
     1           (ADHI2(II)-ADLO2(II)).LE.0.0 .OR.
     2           (ADLO1(II).EQ.0.0 .AND. ADLO2(II).NE.0.0) .OR.
     2           (ADLO2(II).EQ.0.0 .AND. ADLO1(II).NE.0.0) .OR.
     2           (ADHI1(II).EQ.0.0 .AND. ADHI2(II).NE.0.0) .OR.
     2           (ADHI2(II).EQ.0.0 .AND. ADHI1(II).NE.0.0) .OR.
     3           (ADLO1(II).NE.0.0 .AND.
     3            ABS(ADLO2(II)-ADLO1(II)).GT.1.0E-05*ABS(ADLO1(II)))
     3           .OR. (ADHI1(II).NE.0.0 .AND.
     3            ABS(ADHI2(II)-ADHI1(II)).GT.1.0E-05*ABS(ADHI1(II))))
     +         THEN
                  WRITE(TXTERR,'(''Var.'',I3,'' Error in''
     1             ,'' limits'',2(1PG11.4),''; '',2(1PG11.4))')
     2             II,ADLO1(II),ADHI1(II),ADLO2(II),ADHI2(II)
                  CALL MN_ERR('M_HCMP',TXTERR)
                  GOTO 9000
              ENDIF
          ENDIF
2100  CONTINUE
C
      IERR = 0
C
9000  CONTINUE
      END

