C SPLINE FITTER FROM FXB$CG.  I THINK THIS IS FROM THE STANFORD
C SPSS PACKAGE.
       SUBROUTINE T2SPLN (N,X,Y,B,C,D)
      INTEGER  N
      REAL  X(N), Y(N), B(N), C(N), D(N)
C
C  THE COEFFICIENTS B(I), C(I), AND D(I), I=1,2,...,N-1 ARE COMPUTED
C  FOR THE NATURAL CUBIC INTERPOLATING SPLINE
C
C     Y(X) = Y(I) + B(I)*(X-X(I)) + C(I)*(X-X(I))**2 + D(I)*(X-X(I))**3
C
C  FOR X(I) .LE. X .LE. X(I+1) .
C
C  INPUT..
C
C     N  THE NUMBER OF DATA POINTS OR KNOTS  (N.GE.4)
C     X  THE ABSCISSAS OF THE KNOTS IN STRICTLY INCREASING ORDER
C     Y  THE ORDINATES OF THE KNOTS
C
C  OUTPUT..
C
C     B, C, D  ARRAYS OF SPLINE COEFFICIENTS AS DEFINED ABOVE.
C     B(N)  HAS THE APPROPRIATE VALUE TO DEFINE
C     THE SPLINE FOR  X .GT. X(N) .
C
C  USING  P  TO DENOTE DIFFERENTIATION,
C
C     Y(I) = S(X(I))
C     B(I) = SP(X(I))
C     C(I) = SPP(X(I))/2
C     D(I) = SPPP(X(I))/6
C
      INTEGER  NM1, NM2, IB, I
      REAL T
      NM1=N-1
      NM2=N-2
C
C  SET UP TRIDIAGONAL SYSTEM
C
C  B = DIAGONAL, D = OFFDIAGONAL, C = RIGHT HAND SIDE.
C
      D(1)=X(2)-X(1)
      C(2)=(Y(2)-Y(1))/D(1)
      DO 10 I=2,NM1
        D(I)=X(I+1)-X(I)
        B(I)=2.*(D(I-1)+D(I))
        C(I+1)=(Y(I+1)-Y(I))/D(I)
        C(I)=C(I+1)-C(I)
 10   CONTINUE
C
C  NATURAL SPLINE END CONDITIONS
C
      C(1)=0.
      C(N)=0.
C
C  FORWARD ELIMINATION
C
      DO 20 I=3,NM1
        T=D(I-1)/B(I-1)
        B(I)=B(I)-T*D(I-1)
        C(I)=C(I)-T*C(I-1)
 20   CONTINUE
C
C  BACK SUBSTITUTION
C
      C(NM1)=C(NM1)/B(NM1)
      DO 30 IB=2,NM2
        I=N-IB
        C(I)=(C(I)-D(I)*C(I+1))/B(I)
 30   CONTINUE
C
C  C(I) IS NOW THE SIGMA(I) OF THE TEXT
C
C  COMPUTE POLYNOMIAL COEFFICIENTS
C
      B(N)=(Y(N)-Y(NM1))/D(NM1)+D(NM1)*C(NM1)
      DO 40 I=1,NM1
        B(I)=(Y(I+1)-Y(I))/D(I)-D(I)*(C(I+1)+2.*C(I))
        D(I)=(C(I+1)-C(I))/D(I)
        C(I)=3.*C(I)
 40   CONTINUE
      RETURN
      END
