# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Mascot Parameters.

parameters = {}

parameters['partials'] = ['0','1','2','3','4','5','6','9','8','9']

parameters['masstype'] = [
                        'Monoisotopic',
                        'Average',
                        ]

parameters['peptolunits'] = [
                        'Da',
                        'mmu',
                        '%',
                        'ppm',
                        ]

parameters['pepcharge'] = [
                        '1-',
                        'Mr',
                        '1+',
                        ]

parameters['msmstolunits'] = [
                        'Da',
                        'mmu',
                        ]

parameters['msmscharge'] = [
                        '8-',
                        '7-',
                        '6-',
                        '5-',
                        '4-',
                        '3-',
                        '2- and 3-',
                        '2-',
                        '1-, 2- and 3-',
                        '1-',
                        'Mr',
                        '1+',
                        '1+, 2+ and 3+',
                        '2+',
                        '2+ and 3+',
                        '3+',
                        '4+',
                        '5+',
                        '6+',
                        '7+',
                        '8+',
                        ]

parameters['database'] = [
                        'MSDB',
                        'NCBInr',
                        'EST_human',
                        'EST_mouse',
                        'EST_others',
                        'SwissProt',
                        'Random',
                        'HG',
                        ]

parameters['enzyme'] = [
                        'Trypsin',
                        'Arg-C',
                        'Asp-N',
                        'Asp-N_ambic',
                        'Chymotrypsin',
                        'CNBr',
                        'CNBr+Trypsin',
                        'Formic_acid',
                        'Lys-C',
                        'Lys-C/P',
                        'PepsinA',
                        'Tryp-CNBr',
                        'TrypChymo',
                        'Trypsin/P',
                        'V8-DE',
                        'V8-E',
                        'semiTrypsin',
                        'LysC+AspN',
                        'None',
                        ]

parameters['mods'] = [
                        'none',
                        'Acetyl (K)',
                        'Acetyl (N-term)',
                        'Amide (C-term)',
                        'Biotin (K)',
                        'Biotin (N-term)',
                        'Carbamidomethyl (C)',
                        'Carbamyl (K)',
                        'Carbamyl (N-term)',
                        'Carboxymethyl (C)',
                        'Cystine (C)',
                        'Deamidation (NQ)',
                        'EtOH (C)',
                        'Guanidination (K)',
                        'HNE (CHK)',
                        'HSe (C-term M)',
                        'Hse_lact (C-term M)',
                        'ICAT_heavy',
                        'ICAT_light',
                        'ICPL_heavy (K)',
                        'ICPL_heavy (Protein)',
                        'ICPL_light (K)',
                        'ICPL_light (Protein)',
                        'iTRAQ (K)',
                        'iTRAQ (N-term)',
                        'iTRAQ (Y)',
                        'Me-ester (C-term)',
                        'Me-ester (DE)',
                        'MMTS (C)',
                        'N-Acetyl (Protein)',
                        'N-Formyl (Protein)',
                        'NIPCAM (C)',
                        'O18 (C-term)',
                        'Oxidation (M)',
                        'Oxidation (HW)',
                        'PEO-Biotin (C)',
                        'Phospho (ST)',
                        'Phospho (Y)',
                        'Propionamide (C)',
                        'Pyro-cmC (N-term camC)',
                        'Pyro-glu (N-term Q)',
                        'Pyro_glu (N-term E)',
                        'S-pyridylethyl (C)',
                        'SMA (K)',
                        'SMA (N-term)',
                        'Sodiated (C-term)',
                        'Sodiated (DE)',
                        'Sulfation (S)',
                        'Sulfation (T)',
                        'Sulfation (Y)',
                        'Sulphone (M)',
                        ]

parameters['taxonomy'] = [
                        'All entries',
                        '. . Archaea (Archaeobacteria)',
                        '. . Eukaryota (eucaryotes)',
                        '. . . . Alveolata (alveolates)',
                        '. . . . . . Plasmodium falciparum (malaria parasite)',
                        '. . . . . . Other Alveolata',
                        '. . . . Metazoa (Animals)',
                        '. . . . . . Caenorhabditis elegans',
                        '. . . . . . Drosophila (fruit flies)',
                        '. . . . . . Chordata (vertebrates and relatives)',
                        '. . . . . . . . bony vertebrates',
                        '. . . . . . . . . . lobe-finned fish and tetrapod clade',
                        '. . . . . . . . . . . . Mammalia (mammals)',
                        '. . . . . . . . . . . . . . Primates',
                        '. . . . . . . . . . . . . . . . Homo sapiens (human)',
                        '. . . . . . . . . . . . . . . . Other primates',
                        '. . . . . . . . . . . . . . Rodentia (Rodents)',
                        '. . . . . . . . . . . . . . . . Mus.',
                        '. . . . . . . . . . . . . . . . . . Mus musculus (house mouse)',
                        '. . . . . . . . . . . . . . . . Rattus',
                        '. . . . . . . . . . . . . . . . Other rodentia',
                        '. . . . . . . . . . . . . . Other mammalia',
                        '. . . . . . . . . . . . Xenopus laevis (African clawed frog)',
                        '. . . . . . . . . . . . Other lobe-finned fish and tetrapod clade',
                        '. . . . . . . . . . Actinopterygii (ray-finned fishes)',
                        '. . . . . . . . . . . . Takifugu rubripes (Japanese Pufferfish)',
                        '. . . . . . . . . . . . Danio rerio (zebra fish)',
                        '. . . . . . . . . . . . Other Actinopterygii',
                        '. . . . . . . . Other Chordata',
                        '. . . . . . Other Metazoa',
                        '. . . . Dictyostelium discoideum',
                        '. . . . Fungi',
                        '. . . . . . Saccharomyces Cerevisiae (baker\'s yeast)',
                        '. . . . . . Schizosaccharomyces pombe (fission yeast)',
                        '. . . . . . Pneumocystis carinii',
                        '. . . . . . Other Fungi',
                        '. . . . Viridiplantae (Green Plants)',
                        '. . . . . . Arabidopsis thaliana (thale cress)',
                        '. . . . . . Oryza sativa (rice)',
                        '. . . . . . Other green plants',
                        '. . . . Other Eukaryota',
                        '. . Bacteria (Eubacteria)',
                        '. . . . Actinobacteria (class)',
                        '. . . . . . Mycobacterium tuberculosis complex',
                        '. . . . . . Other Actinobacteria (class)',
                        '. . . . Firmicutes (gram-positive bacteria)',
                        '. . . . . . Bacillus subtilis',
                        '. . . . . . Mycoplasma',
                        '. . . . . . Streptococcus Pneumoniae',
                        '. . . . . . Streptomyces coelicolor',
                        '. . . . . . Other Firmicutes',
                        '. . . . Proteobacteria (purple bacteria)',
                        '. . . . . . Agrobacterium tumefaciens',
                        '. . . . . . Campylobacter jejuni',
                        '. . . . . . Escherichia coli',
                        '. . . . . . Neisseria meningitidis',
                        '. . . . . . Salmonella',
                        '. . . . . . Other Proteobacteria',
                        '. . . . Other Bacteria',
                        '. . Viruses',
                        '. . . . Hepatitis C virus',
                        '. . . . Other viruses',
                        '. . Other (includes plasmids and artificial sequences)',
                        '. . unclassified',
                        '. . Species information unavailable',
                        ]

parameters['instrument'] = [
                        'Default',
                        'ESI-QUAD-TOF',
                        'MALDI-TOF-PSD',
                        'ESI-TRAP',
                        'ESI-QUAD',
                        'ESI-FTICR',
                        'MALDI-TOF-TOF',
                        'ESI-4SECTOR',
                        'FTMS-ECD',
                        'MALDI-QUAD-TOF',
                        'MALDI-QIT-TOF',
                        ]

parameters['showhits'] = [
                        'AUTO',
                        '5',
                        '10',
                        '20',
                        '30',
                        '50',
                        ]
