signature S =
   sig
      type t

      val f: t -> t
      val x: t
   end

functor F (S: sig
		 structure S1: S
		 structure S2: S
		 sharing S1 = S2
	      end) =
   struct
      open S
      val _ = S1.f S2.x
      val _ = S2.f S1.x
   end

structure Z = F (structure S1 =
		    struct
		       type t = int

		       val x = 13
		       fun f x = 15
		    end
		 structure S2 =
		    struct
		       type t = int

		       val x = 17
		       fun f x = 19
		    end)
      
