/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQDetailedFolderView_H
#define MvQDetailedFolderView_H

#include <QSettings>
#include <QTreeView>

#include "MvQFolderViewBase.h"

class MvQActionList;
class MvQContextItemSet;
class MvQDetailedViewDelegate;
class MvQIconMimeData;
class Folder;

#include "IconObject.h"

class MvQDetailedFolderView : public QTreeView, public MvQFolderViewBase
{
    Q_OBJECT

public:
    MvQDetailedFolderView(MvQFolderModel*, MvQActionList*, MvQActionList*, QWidget* parent = 0);
    ~MvQDetailedFolderView();
    static void writeGlobalSettings(QSettings&);
    static void readGlobalSettings(QSettings&);
    QWidget* concreteWidget();
    void doReset();

public slots:
    void slotIconShortCut();
    void slotDefaultShortCut();
    void slotDesktopShortCut();
    void slotContextMenu(const QPoint&);
    void slotSelectItem(const QModelIndex&);
    void slotEntered(const QModelIndex&);
    void slotDoubleClickItem(const QModelIndex&);
    void slotObjectRenamed(const QModelIndex&, QString);
    void slotIconSizeChanged();
    void slotHeaderContextMenu(const QPoint&);

signals:
    void currentFolderChanged(Folder*);
    void itemEntered(IconObject*);
    void iconCommandRequested(QString, IconObjectH);
    void desktopCommandRequested(QString, QPoint);

protected:
    void attachModel();
    void detachModel();

    MvQContextItemSet* cmSet();
    void setupShortCut();
    void setPositions(){}
    void blink(const QModelIndex&);
    void showIcon(const QModelIndex&);
    void rename(IconObject*);

    void changeEvent(QEvent* event);
    void leaveEvent(QEvent* event);
    void mousePressEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);
    void performDrag(Qt::DropAction, QPoint);
    void checkDropTarget(QDropEvent* event);
    void removeDropTarget();
    void dragEnterEvent(QDragEnterEvent*);
    void dragMoveEvent(QDragMoveEvent*);
    void dragLeaveEvent(QDragLeaveEvent*);
    void dropEvent(QDropEvent*);
    void performDrop(Qt::DropAction dropAction, const MvQIconMimeData* data,
                     QPoint cursorScenePos, bool fromSameView);

    void keyPressEvent(QKeyEvent* event);

    QModelIndexList selectedList();
    QRect itemRect(IconObject*);
    QRect itemRect(QList<IconObject*>);
    QRect pixmapRect(QList<IconObject*>);
    QRect pixmapRect(IconObject*);

    bool ignoreItemPositionForCm() { return true; }

    void folderChanged();
    void iconCommandFromMain(QString name);
    virtual void iconCommand(QString, IconObjectH);
    virtual void desktopCommand(QString, QPoint);

    static void broadcastHeaderChange();
    void updateHeader();

    QPoint startPos_;
    bool moveActionEnabled_;
    MvQDetailedViewDelegate* delegate_;
    QShortcut* defaultShortCut_;
    MvQActionList* appIconActions_;
    MvQActionList* appDesktopActions_;
    IconObject* itemInfo_{nullptr};
};

#endif
