#ifndef DataToolsDEFINED
#define DataToolsDEFINED
#include <mars.h>

#ifndef MAXFLOAT
const float MAXFLOAT =	3.4E37;
#endif

#ifndef BIGFLOAT
const float BIGFLOAT =	3.4E35;
#endif

#include <math.h>

void		AppendRequest (request* head, request* tail);
err		GetFieldFromRequest (request* filter, request* mars, field* g);
err		GetFieldFromRequest (int par, int lev, request* mars, field* g);
err		GetFieldFromRequest (int lev, request* mars, field* g);
err		GetFieldFromRequest (request* mars, field* g);
void		AskLNSP (request* mars);
request*	FilterRequest (int par, int lev, request* mars);
int		ModelLevels (field* grib);
//float		ModelLevelPressure (field* lnsp, float sp, int lev);
//void		Statistics (field* g, float* fmin, float* fmax, float* fmean);
err 		UpdateFile (const char* fname, field* g);
request*	GetRequestFromFile (const char* fname);
void		ExpandRequest (request* r);
void		GetCompactRequest (request* compact, request* extended);
void		SortParam (request *r, const char* parname, int ascending);
void		PutValue(request *r,const char *parname,const char *valname);
void 		PutValueAtHead (request *r,const char *parname,const char *valname);
//float		InterpolateAt (double x, double y, field* grib);
//void		InterpolateAlong (float* val, int npoint, float x1, float y1, float x2, float y2, field* grib, int met=0);
void		EvaluateLine (float loni, float lati, float lonf, float latf, int npt, double* lona, double* lata, int met=0);
//float		AverageAt (float x1, float y1, float x2, float y2, field* grib);
//void		AverageAlong (float* val, int npoint, float x1, float y1, float x2, float y2, field* grib, int equator);
float		Distance (float x1, float y1, float x2, float y2);
request*	LoopRequest (request *r, int index, int count, char *strings[]);
const char*		Date2Date (const char*);
#endif
