/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQObstatCurveData_H
#define MvQObstatCurveData_H

#include <vector>

#include <QDateTime>
#include <QStringList>

#include "ObsStatDecoder.h"

using magics::ObsStatDecoder;

class MvKeyProfile;
class ObsStatDecoder;

using namespace std;


class MvQObstatCurveItem
{
public:
	QString name;
	float min;
	float max;
	QMap<QString,QList<float> > data;
};



class MvQObstatCurveData : public ObsStatDecoder
{
public:
	MvQObstatCurveData();
	~MvQObstatCurveData();

	void loadData();
	void loadKeyProfile(MvKeyProfile*);
	void setFileName(QString);
	QString fileName() {return fileName_;}
	int itemNum() {return itemNum_;}
	//MvQCurveItem* item(int);
	void getStatItem(QList<MvQObstatCurveItem*>&);


	
protected:
	void clearData();
	void catStringVector(vector<string> &,string &);
 	void getStatColumnData(int,StatItem*,string , QList<float> &);

	QString fileName_;
	int itemNum_;
	//ObsStatDecoder *decoder_;
};


#endif
