/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FolderDrawers_H
#include "FolderDrawers.h"
#endif

#ifndef IconDrawer_H
#include "IconDrawer.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#include "Tab.h"

bool FolderDrawers::doneFill_   = false;  // initialise
bool FolderDrawers::doneUpdate_ = false;  // initialise

FolderDrawers::FolderDrawers(Folder* f):
	folder_(f),
	widget_(0)
{
}

FolderDrawers::~FolderDrawers()
{
	folder_->removeObserver(this);		
	
	// Remove the observers for all its kids also
	map<FolderH,IconDrawer*>::iterator ii = drawers_.begin();
	for (; ii != drawers_.end(); ii++)
	  {
	    FolderH folder = (*ii).first;
	    IconDrawer *iconDrawer =  (*ii).second;
	    XtDestroyWidget(iconDrawer->xd_rootwidget());
	    folder->removeObserver(iconDrawer);
	    delete iconDrawer;
	  }
}

void FolderDrawers::install(Widget w)
{
	widget_ = w;
	folder_->addObserver(this);

	int n = 0;


	while(drawers_.size() == 0 && fill(n++)) 
		;

/*
	// ir/2010-09-26: changed the behaviour so that the drawers
	// will be re-synced with the system ones each time MetviewUI
	// is started.

	//while(fill(n++)) 
	while(!FolderDrawers::doneFill_ && fill(n++))
	{
		FolderDrawers::doneFill_ = true;
	} 


	// for each local drawer folder, copy any new files from the system


	if (!FolderDrawers::doneUpdate_)
	{
		FolderDrawers::doneUpdate_ = true;

		map<FolderH,IconDrawer*>::iterator ii = drawers_.begin();
		for (; ii != drawers_.end(); ii++)
		{
			FolderH folder = (*ii).first;

			Folder* systemFolder = Folder::folder( "system_stationary"
                                        	, folder->name()
                                        	, false
                                        	);

			// only update drawers which have a corresponding system folder

			if( systemFolder )
			{
				//printf ("Copying:::: %s to %s\n", folder->name().c_str(), systemFolder->name().c_str());
				folder->copyContent( systemFolder );
				folder->ensureChildrenWritable();
			}
		}
	}*/

}

void FolderDrawers::arrived(IconObject* o)
{     
	Folder* f = dynamic_cast<Folder*>(o);
	if(!f) return;
	drawers_[f] = new IconDrawer(*this,f);

}

void FolderDrawers::opened(IconObject* o)
{     
	Folder* f = dynamic_cast<Folder*>(o);
	if(!f) return;
	IconDrawer* p = drawers_[f];
	if(p) {
		
	}
}

void FolderDrawers::closed(IconObject* o)
{     
}

void FolderDrawers::gone(IconObject* o)
{	    
	Folder* f = dynamic_cast<Folder*>(o);
	if(!f) return;
	IconDrawer* p = drawers_[f];
	if(p) {
		XtDestroyWidget(p->xd_rootwidget());	
		delete p;
		drawers_.erase(f);
	}

	int n = 0;
	while(drawers_.size() == 0 && fill(n++))
		;
}

void FolderDrawers::position(IconObject* o,int x,int y)
{
}

void FolderDrawers::renamed(IconObject* o)
{	      
	Folder* f = dynamic_cast<Folder*>(o);
	if(!f) return;
	IconDrawer* p = drawers_[f];
	if(p) TabSetName(widget_,p->xd_rootwidget(),o->name().c_str());
}

Widget FolderDrawers::widget()
{
	return widget_;
}

void FolderDrawers::newFolder()
{
	IconClass::find("FOLDER").createOne(folder_);
}
