//   -*- mode: c++; -*-

//#include <Regex.h>

#ifndef ADSTRING_H
#define ADSTRING_H

#include "regex-c.h"
#include <iostream.h>
#include <fstream.h>
#include <vector.h>
#include <string>
#include <locale.h>
#include <libintl.h>
#include <stdio.h>

#define LOCALEDIR "/usr/share/locale"
#define _(String) gettext(String)

#define MAX_LINE 10240  


// ************* String.h replacement code:
class Regex;

class String:public string{
public:
  //  operator const char*() const{
  //  return c_str();
  //};
  String():string(){};
  String(string r):string(r){};
  String(char *s):string(s){};
  string after(size_type pos){
    return substr(pos);
  }
  bool contains(const string &sub, size_type pos=0) const{
    size_type i;
    if(this->length() < (sub.length()+pos))
      return false;
    for(i=0; 
	(i<sub.length())&&(sub[i]==(*this)[i+pos]); 
	i++)
      ;
    return i==sub.length();
  }
  bool contains(char c){
    return find(c) != npos;
  }
};

typedef vector <String> StrVec;
typedef vector <const String> cStrVec;


template <class charT, class Alloc>
bool
operator== (const string &left, const char *right) {
    return left.compare(string(right)) == 0;
}


class Regex{
  struct re_pattern_buffer* patt;
public:
  Regex(const char *s);
  struct re_pattern_buffer* pattern() const {return patt;};
};


extern String upcase(const String& x);
extern String Sprintf(const char *, String &);
int readline(istream& s, String& x, 
		char terminator = '\n');//,int discard_terminator = 1);



// ************* "own" string handling code:


class parsestream;
class parseinfo{
public:
  vector<int> lineno;
  String buffer;
  string::size_type pos;
  vector<String> fname;

public:
  int    linenumber(){return lineno[lineno.size()-1];}
  void set_linenumber(int l){
    lineno[lineno.size()-1]=l;
  }
  String filename(){  
    return fname [fname.size()-1];
  }
  void set_filename(const String &s){
    fname[fname.size()-1]=s;
  }
  virtual ~parseinfo();
};

// ************* exceptions:

class genexcept{
public:
  virtual void report(){
    cerr<<message()<<endl;
  }
  virtual String message(){
    return "Unknown Error";
  }
  virtual ~genexcept(){};
};

class except_pi: public genexcept{
public:
  parsestream *pi;
  except_pi(parsestream *p);
  void report();
};

class except_String: public genexcept{
public:
  String msg;
  except_String(String s){
    msg=s;
  };
  String message(){
    return Sprintf(_("Unknown Error, message=%s"),msg);
  }
};

class except_pi_String: public except_pi{
public:
  String msg;
  except_pi_String(parsestream *p, String s);
  String message(){
    return Sprintf(_("Unknown Error, message=%s"),msg);
  }
};


class endoffile: public except_pi{
public:
  endoffile(parsestream *p):except_pi(p){};
  String message(){return _("Unexpected end of file");}
};
class endofline: public except_pi{
public:
  endofline(parsestream *p):except_pi(p){};
  String message(){return _("Unexpected end of line");}
};
class ident_expected: public except_pi{
public:
  ident_expected(parsestream *p):except_pi(p){};
  const char *errormsg(){return _("Identifier expected");}
};
class char_expected: public except_pi_String{
public:
  char_expected(parsestream *p, String s):except_pi_String(p,s){};
  String message(){
    return Sprintf(_("Expected: \"%s\"."), msg);
  };
};
class char_unexpected: public except_pi_String{
public:
  char_unexpected(parsestream *p, String s):except_pi_String(p,s){};
  String message(){
    return Sprintf(_("Unexpected character :\"%s\"."),msg);
  };
};  

class unexpectedtrailing: public except_pi_String{
public:
  unexpectedtrailing(parsestream *p, String s):except_pi_String(p,s){};
  String message(){
    return Sprintf(_("Trailing chars on line :\"%s\"."),msg);
  };
};  

class boolean_expected: public except_pi_String{
public:
  boolean_expected(parsestream *p, String s):except_pi_String(p,s){};
  String message(){
    return Sprintf(_("Boolean (eighter true or false) expeced.\n"
		     "Found: \"%s\""),msg);
  };
};  

class ferror_open: public except_String{
public:
  ferror_open(String s):except_String(s){};
  String message(){
    return Sprintf(_("Unable to open file \"%s\""),msg);
  };
};

class unknown_compat: public except_pi_String{
public:
  unknown_compat(parsestream *p, String s):except_pi_String(p,s){};
  String message(){
    return Sprintf(_("Unknown compat mode: \"%s\""),msg);
  };
};



class parsestream: public parseinfo{
public:
  enum eol_type {eol_newline, eol_semicolon};
private:
  vector<istream *> i;
  bool in_constructor;
  void new_line();
  void preprocess(String &s);
  istream *current_istr(){return i[i.size()-1];};
  void close_file();
  void new_file(const String &s);
  bool stdin_file;
  eol_type eolmode;
  String otherdir;
public:
  void init(istream *in, String s, bool stin){
    stdin_file=stin;

    if(!in_constructor){
      if(!*in||!in->good())
	throw ferror_open(s);
    }
    pos=0;
    eolmode=eol_newline;
    i.push_back(in); 
    lineno.push_back(0);
    fname.push_back(s);

    new_line();
  }
  parsestream(istream &in, String other=""){

    in_constructor=true;
    otherdir=other;
    init(&in,_("(probably) stdin"),true);
    in_constructor=false;
  };
  parsestream(const String &s, String other=""){
    istream *f=new ifstream(s.c_str());

    if(!f && (s[0]!='/')){
      String add=other+"/"+s;
      f=new ifstream(add.c_str());
    }
    if(!*f){
      throw ferror_open("cannot open file " +s);
    }
    in_constructor=true;
    otherdir=other;
    init(f,s,false);
    in_constructor=false;
  };
  ~parsestream(){
    //delete i;
  };
  bool good(){
    return i.size();//&&current_istr() && (*current_istr());
  };
  char get_char();
  char put_back(char);
  String get_name();
  String get_name(const Regex &);
  String get_eq_name();
  String get_Stringconst();
  String get_eq_Stringconst();
  bool   get_boolean();
  bool   get_eq_boolean();
  int    get_integer();
  int    get_eq_integer();
  double get_double();
  double get_eq_double();
  String get_line();
  void skip_line();
  void skip_space();
  void skip_char(char expect);
  void seteolmode(eol_type mode);
  //int linenumber(){return linenumber();};
  //String filename(){return fname;};
};

extern String rmtrailingspace(String &s);
extern String escape_doublequotes(const String &s);
extern String escape_String(const String &s, const String &esc);
extern String escapewith_String(const String &s, 
				const String &esc, 
				const String &with);
extern String tolower_String(const String &s);
extern String toupper_String(const String &s);
extern String replacewith_String(const String &s, 
				 const String &replace, 
				 const String &with);
extern String cppesc_String(const String &s);
extern String replace(String s,char match, char replace);
extern int Stringtoi(const String &s);
extern String itoString(int i);
extern String itohexString(int i);
extern String sort_hotkey(String s);
extern String String_parent(String s);
extern String String_basename(String s);
extern String String_stripdir(String s);
extern String String_lastname(String s);
extern void break_char(const String &sec,StrVec &sec_vec, char);
extern void break_slashes(const String &sec,StrVec &sec_vec);
extern void break_commas(const String &sec,StrVec &sec_vec);
extern const char *ldgettext(const char *language, 
			     const char *domain,
			     const char *msgid);


#endif /*ADSTRING_H*/
