/* defs.h - MemTest-86 assembler/compiler definitions
 *
 * Released under version 2 of the Gnu Public License.
 * By Chris Brady, cbrady@sgi.com
 */ 

#define SETUPSECS	4		/* Number of setup sectors */

/*
 * Caution!! There is magic in the build process.  Read
 * README.build-process before you change anything.  
 * Unlike earlier versions all of the settings are in defs.h
 * so the build process should be more robust.
 */
#define LOW_TEST_ADR	0x02000			/* Final adrs for test code */
#define HIGH_TEST_ADR	0x110000		/* Relocation base address */
#define MAIN_SIZE	0xa000			/* Estimated size of primary test code */
#define TEST_SIZE	(2*MAIN_SIZE)		/* Total test size */

#define LOW_ADR		0x00 	        	/* Lowest adrs for testing */
#define START_ADR	(TEST_SIZE+LOW_TEST_ADR)/* Starting adrs for testing 
						 * Note: START_ADR must be 256 byte
						 * aligned.
						 */
#define BOOTSEG		0x07c0			/* Segment adrs for inital boot */
#define INITSEG		0x9000			/* Segment adrs for relocated boot */
#define SETUPSEG	(INITSEG+0x20)		/* Segment adrs for relocated setup */
#define TESTSEG		(LOW_TEST_ADR/0x10)	/* Final segment adrs for test code */
#define TSTLOAD		0x1000			/* Segment adrs for load of test */
#define KERNEL_CS	0x10			/* 32 bit segment adrs for code */
#define KERNEL_DS	0x18			/* 32 bit segment adrs for data */
