##############################################################################
#
# Widget to add new items <Peter.Bienstman@ugent.be>
#
##############################################################################

from qt import *

from memaid_core import *
from add_items_frm import *



##############################################################################
#
# AddItemsDlg
#
##############################################################################

class AddItemsDlg(AddItemsFrm):

    ##########################################################################
    #
    # __init__
    #
    ##########################################################################

    def __init__(self,parent = None,name = None,modal = 0,fl = 0):
        
        AddItemsFrm.__init__(self,parent,name,modal,fl)
        
        self.categories.insertItem("<default>")
        for cat in get_categories():
            if cat.name != "<default>":
                self.categories.insertItem(cat.name)

        self.connect(self.grades,SIGNAL("clicked(int)"),
                     self.new_item)
        
        self.question.setTabChangesFocus(1)
        self.answer.setTabChangesFocus(1)

    ##########################################################################
    #
    # new_item
    #
    ##########################################################################
    
    def new_item(self, grade):

        cat_name = unicode(self.categories.currentText())
        if cat_name not in category_by_name.keys():
            self.categories.insertItem(cat_name)

        q = unicode(self.question.text())
        a = unicode(self.answer.text())

        if q == "" or a == "":
            return
            
        add_new_item(grade, q, a, cat_name)
        if self.addViceVersa.isOn():
            add_new_item(grade, a, q, cat_name)

        self.question.setText("")
        self.answer.setText("")
        self.question.setFocus()
