/* Mednafen - Multi-system Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>

#include "types.h"
#include "mednafen.h"
#include "memory.h"
#include "general.h"

void *MDFN_gmalloc(uint32 size)
{
 void *ret;
 ret=malloc(size);
 if(!ret)  
 {
  MDFN_PrintError(_("Error allocating memory!  Doing a hard exit."));
  exit(1);
 }
 return ret;
}

void *MDFN_malloc(uint32 size)
{
 void *ret;
 ret=malloc(size);
 if(!ret)
 {
  MDFN_PrintError(_("Error allocating memory!"));
  return(0);
 }
 return ret;
}

void MDFN_free(void *ptr)		// Might do something with this and MDFN_malloc later...
{
 free(ptr);
}

void MDFN_gfree(void *ptr)
{
 free(ptr);
}
