%typemap(java,in) char* %{ 
  setlocale (LC_ALL, "ja_JP");
  $1 = 0;
  if ($input) {
    const jchar *jsrc = (jchar*)JCALL2 (GetStringChars, jenv, $input, 0);
    jsize len = JCALL1 (GetStringLength, jenv, $input);
    wchar_t* wsrc = new wchar_t [len + 1];
    for (int i = 0; i < len; i++) wsrc[i] = jsrc[i];
    $1 = new char [3*len];
    memset ($1, 0, 3*len);
    wcstombs ($1, wsrc, 3*len); 
    delete [] wsrc;
  }
%}

%typemap(java,out) char* %{
   {
     size_t len = strlen ($1);
     wchar_t* wre = new wchar_t [2*len];
     jchar* jre = new jchar [2*len];
     memset (wre, 0, 2 * len);
     size_t len2  = mbstowcs (wre, result, 2*len);
     for (int i = 0; i < len2; i++) jre[i] = wre[i];
     if ($1) jresult = JCALL2(NewString, jenv, jre, len2);
     delete [] jre;
     delete [] wre;
   }
%}

%typemap(java,freearg) char* %{ 
  if ($1) JCALL2(ReleaseStringUTFChars, jenv, $input, $1); 
  delete [] $1;
%}
