""" The handler used to restore editors. """


# Standard library imports.
import logging

# Enthought library imports.
from enthought.pyface.dock.api import SetStructureHandler


# Setup a logger for this module.
logger=logging.getLogger(__name__)


class EditorSetStructureHandler(SetStructureHandler):
    """ The handler used to restore editors.

    This is part of the 'dock window' API. It is used to resolve dock control
    Ids when setting the structure of a dock window.

    """

    ###########################################################################
    # 'object' interface.
    ###########################################################################

    def __init__(self, window_layout, resource_references):
        """ Creates a new handler. """

        self.window_layout = window_layout
        self.resource_references = resource_references

        return

    ###########################################################################
    # 'SetStructureHandler' interface.
    ###########################################################################

    def resolve_id(self, id):
        """ Resolves an unresolved dock control id. """

        window_layout = self.window_layout
        window        = window_layout.window

        try:
            # Try to create the resource with this id.
            resource = self._create_resource(id)

            # Create an editor for the resource.
            editor = window.create_editor(resource)

            # Get the editor's toolkit-specific control.
            #
            # fixme: This is using a 'private' method on the window layout.
            # This may be ok since this is really part of the layout!
            control = window_layout._get_editor_control(editor)

            # fixme: This is ugly manipulating the editors list from in here!
            window.editors.append(editor)

        except:
            logger.warn('could not restore editor [%s]', id)
            control = None

        return control

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _create_resource(self, id):
        """ Creates the resource with the specified Id.

        Raises a 'ValueError' if the resource cannot be created.

        """

        reference = self.resource_references.get(id)
        if reference is None:
            raise ValueError('no resource reference with Id %s' % id)

        return reference.create_resource()

#### EOF ######################################################################
