""" Base class for all actions that listen to the window selection. """


# Local imports.
from workbench_action import WorkbenchAction


class SelectionListenerAction(WorkbenchAction):
    """ Base class for all actions that listen to the window selection. """

    ###########################################################################
    # 'SelectionListenerAction' interface.
    ###########################################################################

    def refresh(self):
        """ Refresh the enabled/disabled state of the action etc.

        This is called whenever the workbench window that the action is in
        and/or the selection in that window have been changed.

        """

        raise NotImplementedError
    
    ###########################################################################
    # Private interface.
    ###########################################################################

    #### Trait change handlers ################################################

    def _window_changed(self, old, new):
        """ Static trait change handler. """

        if old is not None:
            old.on_trait_change(self.refresh, 'selection', remove=True)

        if new is not None:
            new.on_trait_change(self.refresh, 'selection')

        self.refresh()
            
        return

#### EOF ######################################################################
