#!/devtool/local/bin/perl



use Getopt::Long;

use Sys::Hostname;



my $hostname = hostname();



my $basetarg = "/sapmnt/hs0030/a/SAP_DB/chr-arch/";

my $basename = "chr-";

my $basepfx  = ".cpio.gz";



my $localpfx = "/SAP_DB/chr/arch";



$cpio_param = "";



if ($hostname =~ /us0062/) {

	$cpio_param = "c";

}
if ($hostname =~ /us4150/) {

	$cpio_param = "c";

}

elsif ($hostname =~ /us4010/) {

	$cpio_param = "c";

}

elsif ($hostname =~ /ds0116/) {

	$cpio_param = "e";

}

elsif ($hostname =~ /hs0102/) {

	$cpio_param = "x";

}

elsif ($hostname =~ /hs0030/) {

	$cpio_param = "x";

}

elsif ($hostname =~ /hs0116/) {

	$cpio_param = "x";

}

elsif ($hostname =~ /ihls../) {

	$cpio_param = "c";

}

elsif ($hostname =~ /l...../) {

	$cpio_param = "c";

}




print "Hostname = $hostname\ncpio_param = $cpio_param\n";



if ($< != 0) {

	print "You are not root.\nBye bye\n";

	exit(1);

}



if ($ARGV[0] =~ /create/) {

	if (-d $localpfx) {

		system  ("rm -rf $localpfx");

	}

	mkdir $localpfx, 0777;

	system("cd $localpfx && cat " . $basetarg . $basename . $hostname . $basepfx . " | gzip -d | cpio -idv$cpio_param");

} elsif ($ARGV[0] =~ /pack/) {

	if (-d $localpfx) {

		system("cd $localpfx && find . -print -depth | cpio -ov$cpio_param | gzip -9 > " . $basetarg . $basename . $hostname . $basepfx);

	}

} elsif ($ARGV[0] =~ /simul/) {

	print "rm -rf $localpfx\n";

	print "cd $localpfx && cat " . $basetarg . $basename . $hostname . $basepfx . " | gzip -d | cpio -idv$cpio_param\n";

	print "cd $localpfx && find . -print -depth | cpio -ov$cpio_param | gzip -9 > " . $basetarg . $basename . $hostname . $basepfx . "\n";

} else {

	print "A simple tool for maintaining chr-archives\nEither use $0 create for unpacking the current archive to $localpfx and $0 pack for storing it back\n";

}

