#!/usr/bin/perl
#
#    CheckOptFlags.pl - caller for optimization data.
#
#    @(#)CheckOptFlags.pl     2005-05-24
#
#    &gar, SAP AG
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

use Getopt::Long;
use SDB::Make::OptimizationInfo;
use strict;
my $progname = $0;
$progname=~ s,(.*/)|(.*\\),,;

my %Opts;
my $config = undef; 

sub Usage
{
	print <<USAGE_END;
    
Usage: $progname [-config (fast|quick|slow)] [-platform <platform>] [target] [-(h|help|?)]                   
                                       
Where:
     -config <version> 
         default version is fast
         
     target
         default is all.mac
USAGE_END
}     


if (!GetOptions( \%Opts,
                'config=s',
                'compact|c',
                'q',
                's', 
                'platform=s',
                'h|help') || $Opts{'h'})
{
    Usage();
    exit(0);
}

my $target = shift;
my %COF_Options = ();
# only necessary for compact info
my %OptHash = ();
my @platforms_to_check = ( defined $Opts{'platform'} ? split ",", $Opts{'platform'} : "local");
$COF_Options{'config'} = (defined $Opts{'config'}) ? $Opts{'config'} : "fast";
if ($Opts{'compact'})
{	$COF_Options{'silent'} = 1; }

foreach my $platform (@platforms_to_check)
{
	print ("Looking for modified optimization " . (($platform =~  /^local$/) ? "...\n" : "on $platform ...\n"));
	$COF_Options{'platform'} = $platform;
	my $count;
	my $TargetOptHash;
	if ($Opts{'compact'})
	{ 
		($count, $TargetOptHash) = get_modified_optimization($target, \%COF_Options);
		if ($count > 0)
		{
			foreach (keys %$TargetOptHash)
			{	$OptHash{$_}->{$platform}=$TargetOptHash->{$_};	}
		}
	}
	else
	{	$count = get_modified_optimization($target, \%COF_Options); }
		
	if ($count < 0)
	{   print ("ERROR while collecting!"); }
	elsif ($count == 0)
	{	print ("No \"manipulated\" targets found\n"); }
	elsif ($count == 1)
	{ print ("1 \"manipulated\" target found\n"); }
	else
	{ print ("$count \"manipulated\" targets found\n"); }
}

if ($Opts{'compact'})
{
	foreach my $target (sort keys %OptHash)
	{
		print "$target\n";
		foreach (sort keys %{$OptHash{$target}})
		{	print "    $_: $OptHash{$target}->{$_}\n"; }
	}
}
