#!/usr/bin/perl
# @(#) test_selector.pl	05-05-2004	Ulrich Jansen
#
# Bereitstellen eines Parameter-Strings fr die Tests.
#
#    ========== licence begin  GPL
#    Copyright (C) 2001 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

BEGIN {
	if ($^O !~ /win32/i) {
		unshift @INC, ("/devtool/TOOL/tool/lib/perl5", "/devtool/TOOL/tool/lib/Perl", "/devtool/TOOL/tool/bin", "/SAP_DB/TESTDB");
	}
	unshift @INC, ($^O =~ /win32/i ? "\\SAP_DB\\TESTDB\\lib" : "/SAP_DB/TESTDB/lib");
}

use strict;

use Net::HTTP;
use HTTP::Status;
use Sys::Hostname;
use File::Basename;
use XML::Simple;
use Getopt::Long;
use Time::Local;
use QAConnect;

$| = 1;
print "\nlcatest_selector 1.00 (c)2005, SAP AG\n\n";

# Local Variables:
my $DEBUG			= 1;
my $hostname 		= lc(hostname());
my $daytime			= (((localtime(time))[6] > 0) && ((localtime(time))[6] < 6)) ? ((((localtime(time))[2] > 8) && ((localtime(time))[2] < 18)) ? 1 : 0) : 0;
my %opts;
my $datfile  		= ($^O =~ /win32/i ? "\\SAP_DB\\TESTDB\\" : "/SAP_DB/TESTDB/") . "lcatest_selector.dat";
my $datfile_dirty 	= 0;
my %versdata;
my $platform_id 	= 0;
my $platform 		= "";
my $lcaver 			= 0;
my $lcastate 		= "";
my $lcver 			= 0;
my $lcstate 		= "";
my $idlca 			= 0;
my $idlc 			= 0;

usage() unless (GetOptions(\%opts, 'lcamakeid=i', 'lcaver=s', 'lcver=s', 'debug', 'clear', 'notest'));
(print "You have to either define a lcamakeid or lcaver and lcver.\n" and usage()) if (!$opts{'lcamakeid'} && !$opts{'lcaver'} && !$opts{'lcver'});
(print "When using lcamakeid, you can't use lcaver or lcver!\n" and usage()) if ($opts{'lcmakeid'} && ($opts{'lcaver'} || $opts{'lcver'}));
(print "Options lcaver and lcver have to used as couple!\n" and usage()) if (($opts{'lcaver'} && !$opts{'lcver'}) || (!$opts{'lcaver'} && $opts{'lcver'}));
(print "Options lcaver has the wrong format!\n" and usage()) if ($opts{'lcaver'} && !$opts{'lcaver'} =~ /\d\d\d(DEV|COR|RAMP|HOT)/);
(print "Options lcver has the wrong format!\n" and usage()) if ($opts{'lcver'} && !$opts{'lcver'} =~ /\d\d\d\d(DEV|COR|RAMP|HOT)/);
($lcaver, $lcastate) = ($1, $2) if($opts{'lcaver'} =~ /^(\d\d\d)(DEV|COR|RAMP|HOT)$/);
($lcver, $lcstate) = ($1, $2) if($opts{'lcver'} =~ /^(\d\d\d\d)(DEV|COR|RAMP|HOT)$/);


$DEBUG = $opts{'debug'};
if ($opts{'clear'}) {
	print "Deleting dat file.." if ($DEBUG);
	unlink ($datfile);
	$datfile_dirty = 1;
	print "..OK\n" if ($DEBUG);
} else {
	read_data();
}

clean_exit(0) if ($opts{'notest'});

print "Checking platform name.." if ($DEBUG);
my ($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "select IDPLATFORM from TESTER.SERVERS where HOST like '$hostname\%'", 1); 
(ref($href) and $href->{'Rows'}->{'Row'}[0]->{'IDPLATFORM'}) or QAConnect::throw_error("UNKNOWN HOSTNAME", "This host ($hostname) has no entry in the SERVERS table!", 1);
$platform_id = $href->{'Rows'}->{'Row'}[0]->{'IDPLATFORM'};
($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "select DESCTEXT from TESTER.PLATFORMS where ID=$platform_id", 1); 
(ref($href) and $href->{'Rows'}->{'Row'}[0]->{'DESCTEXT'}) or QAConnect::throw_error("UNKNOWN HOSTNAME", "Platform ID '$platform_id' has no name!!!!", 1);
$platform = $href->{'Rows'}->{'Row'}[0]->{'DESCTEXT'};
print "..OK ($platform)\n" if ($DEBUG);

if ($opts{'lcamakeid'}) {
	print "MakeID support not implemented, yet! Feel free to do so...;-)\n";
	clean_exit(1);
} else {
	print "Collecting suitable makes.." if ($DEBUG);
	my $leastid = $versdata{$lcaver . $lcastate . $lcver . $lcstate};
	$leastid = "0" unless($leastid);
	($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "select ID, IDLCMAKE from TESTER.MONITOR_LCAMAKES where ID>$leastid AND LCVERSION='$lcver' AND LCQASTATUS='$lcstate' AND LCAVERSION like '$lcaver\%' AND LCAQASTATUS='$lcastate' AND PLATFORM='$platform' ORDER BY ID DESC", 1); 
	(ref($href)) or QAConnect::throw_error("UNKNOWN ERROR", "There has been an unknown error while reading LCAMAKES table!", 1);
	unless ($href->{'Rows'}->{'Row'}) {
		print "..none found!\n" if ($DEBUG);
		print "Could not find any suitable makes with ID greater than $leastid!\n";
		clean_exit(111);
	}
	my $max_rows = scalar(@{$href->{'Rows'}->{'Row'}});
	print "..OK (found $max_rows entries)\n" if ($DEBUG);
	my $row = 0;
	while ($row < $max_rows) {
		($idlca, $idlc) = ($href->{'Rows'}->{'Row'}[0]->{'ID'}, $href->{'Rows'}->{'Row'}[0]->{'IDLCMAKE'});
		print "Checking LCA make ID $idlca.." if ($DEBUG);
		($rc, $href) = QAConnect::httpsql_request("QADB_HTTPSQL", "select IDOBJSTATUS from TESTER.LCAMAKES where ID=$idlca", 1); 
		(ref($href) and $href->{'Rows'}->{'Row'}[0]->{'IDOBJSTATUS'}) or QAConnect::throw_error("UNKNOWN ERROR", "There has been an unknown error while reading LCAMAKES table!", 1);
		if ($href->{'Rows'}->{'Row'}[0]->{'IDOBJSTATUS'} >= 1000) {
			print "..looks good!\n" if ($DEBUG);
			last;
		} else {
			print "..seem to have errors --> Skipping!\n" if ($DEBUG);
		}
		$row ++;
	}
	
	if ($row >= $max_rows) {
		print "Sorry, there's nothing to test for me...\n";
		clean_exit(111);
	}
}

print "\n";
print "Took the following release: $lcver$lcstate ($idlc)\n";
$versdata{$lcaver . $lcastate . $lcver . $lcstate} = $idlca;
$datfile_dirty = 1;

# Dump output 
open(ENV_OUT, ">>$ENV{'DTM_TASKEXPORTFILE'}") or QAConnect::throw_error("ENV OPEN ERROR", "Can't open temporary env output file!", 1);
print ENV_OUT "\nTEST_PKGS=-packid $idlc\n";
close (ENV_OUT) or QAConnect::throw_error("OOPS!", "Can't close temoprary env file?!");

clean_exit(0);

sub read_data {
	print "Reading version data file.." if ($DEBUG);
	if (open(DAT_IN, "<$datfile")) {
		while (<DAT_IN>) {
			if (/^(.+)=(\d+)$/) {
				$versdata{$1} = $2;
			}
		}
		close (DAT_IN);
		print "..OK\n" if ($DEBUG);
	} else {
		print "..FAILED (file not existent / readable)!\n" if ($DEBUG);
		$datfile_dirty = 1;
	}
}

sub write_data {
	print "Writing version data file.." if ($DEBUG);
	if (open(DAT_OUT, ">$datfile")) {
		foreach my $key (keys %versdata) {
			print DAT_OUT "$key=$versdata{$key}\n";
		}
		close (DAT_OUT);
		print "..OK\n" if ($DEBUG);
	} else {
		print "..FAILED (can't open file for writing)!\n" if ($DEBUG);
	}
	$datfile_dirty = 0;
}

sub clean_exit {
	my $rc = shift;
	write_data() if ($datfile_dirty);
	print "\nExiting...\n" if ($DEBUG);
	exit($rc);
}

sub usage {
    print <<USAGE_END;
	
Usage:
lcatest_selector [-lcamakeid <ID> || (-lcaver <LCAVER> && -lcver <LCVER>)]

Where
    either:
        -lcamakeid <ID> is a unique LCA Make-ID.
    or:
        -lcaver <LCAVER> is a valid LCA-Version.
        -lcver <LCVER> is the corresponding liveCache make ID.

Format:
    LCAVER: DDD(DEV|COR|RAMP|HOT) e.g. 410HOT or 500DEV
    LCVER:  DDDD(DEV|COR|RAMP|HOT) e.g. 7403RAMP or 7600DEV

USAGE_END
	clean_exit(1);
}

