/*!
  @file           gos222.h
  @author         RaymondR
  @brief          Microsoft Cluster Server   ( generated by AppWizard! )
              CBasePropertyPage class.
  @see            

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/



#ifndef GOS222_H
#define GOS222_H



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

# include <CluAdmEx.h>
# include "gos225.h"  // for CExtObject
# include "gos224.h"	// for CClusPropList, CObjectProperty


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/


/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/////////////////////////////////////////////////////////////////////////////
// Forward Class Declarations
/////////////////////////////////////////////////////////////////////////////

class CBasePropertyPage;

/////////////////////////////////////////////////////////////////////////////
// External Class Declarations
/////////////////////////////////////////////////////////////////////////////

class CExtObject;
interface IWCWizardCallback;

/////////////////////////////////////////////////////////////////////////////
// CBasePropertyPage dialog
/////////////////////////////////////////////////////////////////////////////

class CBasePropertyPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CBasePropertyPage)

// Construction
public:
	CBasePropertyPage(void);
	CBasePropertyPage(IN UINT nIDTemplate, IN UINT nIDCaption = 0);
	virtual ~CBasePropertyPage(void) { }

	// Second phase construction.
	virtual BOOL			BInit(IN OUT CExtObject * peo);
	BOOL					BCreateParamsKey(void);

protected:
	void					CommonConstruct(void);

// Attributes
protected:
	CExtObject *			m_peo;
	HPROPSHEETPAGE			m_hpage;

	IDD						m_iddPropertyPage;
	IDD						m_iddWizardPage;
	IDS						m_idsCaption;

	HPROPSHEETPAGE			Hpage(void) const				{ return m_hpage; }

	IDD						IddPropertyPage(void) const		{ return m_iddPropertyPage; }
	IDD						IddWizardPage(void) const		{ return m_iddWizardPage; }
	IDS						IdsCaption(void) const			{ return m_idsCaption; }

public:
	CExtObject *			Peo(void) const					{ return m_peo; }
	void					SetHpage(IN OUT HPROPSHEETPAGE hpage) { m_hpage = hpage; }
	inline CLUADMEX_OBJECT_TYPE	Cot(void) const;

// Dialog Data
	//{{AFX_DATA(CBasePropertyPage)
	enum { IDD = 0 };
	//}}AFX_DATA
	CStatic	m_staticIcon;
	CStatic	m_staticTitle;
	CString	m_strTitle;

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CBasePropertyPage)
	public:
	virtual BOOL OnSetActive();
	virtual BOOL OnApply();
	virtual LRESULT OnWizardBack();
	virtual LRESULT OnWizardNext();
	virtual BOOL OnWizardFinish();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

	virtual DWORD			DwParseUnknownProperty(
								IN LPCWSTR							pwszName,
								IN const CLUSPROP_BUFFER_HELPER &	rvalue,
								IN DWORD							cbBuf
								)		{ return ERROR_SUCCESS; }
	virtual BOOL			BApplyChanges(void);
	virtual void			BuildPropList(IN OUT CClusPropList & rcpl);

	virtual const CObjectProperty *	Pprops(void) const	{ return NULL; }
	virtual DWORD					Cprops(void) const	{ return 0; }

// Implementation
protected:
	BOOL					m_bBackPressed;
	BOOL					m_bDoDetach;

	BOOL					                BBackPressed(void) const		{ return m_bBackPressed; }
	inline IWCWizardCallback *		PiWizardCallback(void) const;
	inline BOOL		                BWizard(void) const;
	inline HCLUSTER			          Hcluster(void) const;
	void					                EnableNext(IN BOOL bEnable = TRUE);

	DWORD					DwParseProperties(IN const CClusPropList & rcpl);
	BOOL					BSetPrivateProps(IN BOOL bValidateOnly = FALSE);

	// Generated message map functions
	//{{AFX_MSG(CBasePropertyPage)
	afx_msg int	  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void  OnDestroy();
	virtual BOOL  OnInitDialog();
	//}}AFX_MSG
	afx_msg void OnChangeCtrl();
	DECLARE_MESSAGE_MAP()

};  //*** class CBasePropertyPage


inline IWCWizardCallback * CBasePropertyPage::PiWizardCallback(void) const
{
	ASSERT(Peo() != NULL);
	return Peo()->PiWizardCallback();
}

inline BOOL CBasePropertyPage::BWizard(void) const
{
	ASSERT(Peo() != NULL);
	return Peo()->BWizard();
}

inline HCLUSTER CBasePropertyPage::Hcluster(void) const
{
	ASSERT(Peo() != NULL);
	return Peo()->Hcluster();
}

inline CLUADMEX_OBJECT_TYPE CBasePropertyPage::Cot(void) const
{
	ASSERT(Peo() != NULL);
	return Peo()->Cot();
}


/////////////////////////////////////////////////////////////////////////////
// CPageList
/////////////////////////////////////////////////////////////////////////////

typedef CList<CBasePropertyPage *, CBasePropertyPage *> CPageList;

/////////////////////////////////////////////////////////////////////////////



/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/


/*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/



#endif  /* GOS222_H */
