/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#ifndef XMLQCLIB_SESSION_EMBEDDED_H
#define XMLQCLIB_SESSION_EMBEDDED_H

/*!**********************************************************************

  module: XMLQCLib_SessionEmbedded.h

  -----------------------------------------------------------------------

  responsible:  Daniel Kirmse (D027470 - Daniel.Kirmse@SAP.com)

  special area: WebDAV / XML Indexing

  description:  Point of entry for WebDAV embedded XML Html Modelling GUI

  see also:		/

  -----------------------------------------------------------------------

  copyright:                (c) 2000-2004 SAP AG

************************************************************************/


	/*===================================================================
	// Includes
	//===================================================================*/
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_Common_TextConstants.h"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_Common_Utils.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_InitialFrameEmbedded.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_HeaderEmbedded.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_NavigationEmbedded.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_ClientQuery.hpp"
	#include "SAPDB/XML/QueryClientLib/XMLQCLib_HtmlTemplate_FreeQuery.hpp"
	

	/*===================================================================
	// Defines
	//===================================================================*/
	void sendInitialFrameQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendHeaderQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendMessageQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendNavigationQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendClientQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep);
	void sendFreeQuery(sapdbwa_Handle wa, sapdbwa_HttpRequestP req, sapdbwa_HttpReplyP rep, XMLQSLib_Handle qs, XMLIMAPI_Handle xml);

#endif