/*!
   @defgroup       Catalog SAPDB catalog implementation
*/
/*!
  @file           Catalog_Types.hpp
  @author         ThomasA 
  @ingroup        Catalog
  @brief          defines types used in the catalog area

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



\endif
*/

#ifndef CATALOG_TYPES_HPP
#define CATALOG_TYPES_HPP

#include "SQLManager/SQLMan_Types.hpp"

typedef tak_messblock_record      Catalog_MessBlockObjectPascal;  //!< the c++ name for tak_messblock_record
typedef tak_systembuffer          Catalog_Object_Pascal;          //!< the c++ name for tak_systembuffer
typedef tak_baserecord            Catalog_TableObjectPascal;      //!< the c++ name for tak_baserecord
typedef tgg00_Surrogate           Catalog_ObjectId;               //!< the c++ name for tgg00_Surrogate
typedef tak00_columninfo          Catalog_ColumnInfo;             //!< the c++ name for tak00_columninfo
typedef tak00_colinfo_ptr         Catalog_ColumnInfoPtr;          //!< the c++ name for tak00_colinfo_ptr
typedef tak_methodrecord          Catalog_MethodObjectPascal;     //!< the c++ name for tak_methodrecord
typedef tak_method_fileinforecord Catalog_MethodFileObjectPascal; //!< the c++ name for tak_methodfileinforecord
typedef tak_method_inforecord     Catalog_MethodInfoObjectPascal; //!< the c++ name for tak_method_inforecord
typedef tak_param_info            Catalog_ParameterInfo;          //!< new c++ name for tak_param_info

/*!
   @brief macro calculating the offset of a class member
 */
#define CATALOG_OFFSET(T,M) (((char*) &((T*) 0)->M) - (char*) 0)

#define CATALOG_OBJECT_CAST(TYPE,PTR,OFFSET) reinterpret_cast<TYPE*>(reinterpret_cast<unsigned char*>(PTR) + OFFSET)

#endif
