/*!
    @ingroup Restart
    @file    Rst_IRedoReadTask.hpp
    @author  UweH
    @brief   defines an interface class of a singleton to handle log reader tasks
*/
/*

    ========== licence begin  GPL
    Copyright (c) 2000-2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



 */
#ifndef RST_IREDO_READ_TASK_H
#define RST_IREDO_READ_TASK_H

struct Log_EntryInfo;
struct tgg00_TransContext;

/*!
   @interface Rst_IRedoReadTask
   @brief     interface class of a singleton to handle log reader tasks
 */
class Rst_IRedoReadTask
{
public:
	/// Reads log entries from the archive log or the log save and creates redo files
    virtual void ReadLogAndCreateRedoFiles (tgg00_TransContext &TransContext) = 0;
	/// The actual read position is determined. e.g. for the savepoint.
    virtual void GetReadPosition (Log_EntryInfo &entryInfo) const = 0;
};
#endif  /* RST_IREDO_READ_TASK_H */
