/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#ifndef __OMS_FREELISTHEADERDEF_HPP
#define __OMS_FREELISTHEADERDEF_HPP

#include "Oms/OMS_Defines.h"

class OMS_Context;
class OmsObjectContainer;

class OMS_FreeListHeader {
public:
  OMS_FreeListHeader *next;
  OmsObjectContainer *free;
  size_t             size;

  inline OMS_FreeListHeader(size_t sz);
  inline void* operator new(size_t sz, OMS_Context* context);
#if defined(OMS_PLACEMENT_DELETE)
  inline void operator delete(void* p, OMS_Context* context);
#endif
  inline void DeleteSelf(OMS_Context* context);
  void operator delete(void*p); // not implemented, attempt to call will force linker error
};

#endif // __OMS_FREELISTHEADERDEF_HPP
