/*

    ========== licence begin  GPL
    Copyright (c) 2005 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*/
#ifndef __OMS_CLASSHASH_HPP
#define __OMS_CLASSHASH_HPP

#include "Oms/OMS_IGuidHash.hpp"

class OMS_Context;
class OMS_ClassInfo;
class OMS_FreeListHeader;
class OMS_GuidEntry;
class OMS_DumpInterface;

class OMS_ClassHash : public OMS_IGuidHash {
public:
#define GUID_HASH_ENTRIES_CO13 49

  OMS_ClassHash();
  ~OMS_ClassHash();
  void Create(OMS_Context* context);
  void HashInsert(OMS_ClassInfo* pClassInfo, OMS_FreeListHeader* freeHead, OMS_FreeListHeader* freeHeadInVersion);
  OMS_GuidEntry *HashFind(const ClassIDRef guid);
  void Dump(OMS_DumpInterface& dumpObj) const;
private :
  OMS_Context*   m_context;
  OMS_GuidEntry* m_head[GUID_HASH_ENTRIES_CO13];
};

#endif // __OMS_CLASSHASH_HPP
